/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.sharedpassword;

import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.GroupNotEmptyException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.sharedpassword.FilePassword;
import com.sun.enterprise.security.auth.realm.sharedpassword.FilePrivileges;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordAuthHandler;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordUser;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public final class SharedPasswordRealm
extends Realm {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$realm$sharedpassword$SharedPasswordRealm == null ? (class$com$sun$enterprise$security$auth$realm$sharedpassword$SharedPasswordRealm = SharedPasswordRealm.class$("com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordRealm")) : class$com$sun$enterprise$security$auth$realm$sharedpassword$SharedPasswordRealm);
    private static String PASSWORD_FILE_NAME = "keyfile";
    private static String PRIVILEGES_FILE_NAME = "privileges";
    private static String PASSWORD_DIR_PROP = "directory";
    private static String AUTH_TYPE = "password";
    private boolean initted = false;
    private FilePassword passwords;
    private FilePrivileges privileges;
    private AuthenticationHandler authHandler = new SharedPasswordAuthHandler(this);
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$realm$sharedpassword$SharedPasswordRealm;

    public String getAuthType() {
        return AUTH_TYPE;
    }

    FilePassword getPasswords() {
        return this.passwords;
    }

    FilePrivileges getPrivileges() {
        return this.privileges;
    }

    public Enumeration getGroupNames() throws BadRealmException {
        if (this.privileges != null) {
            String[] groups = this.privileges.get("Groups");
            Vector<String> v2 = new Vector<String>();
            int i2 = 0;
            while (i2 < groups.length) {
                v2.add(groups[i2]);
                ++i2;
            }
            return v2.elements();
        }
        throw new BadRealmException(localStrings.getLocalString("sharedpassword.not_supported", "Not Supported"));
    }

    public Enumeration getGroupNames(String username) throws InvalidOperationException, NoSuchUserException {
        SharedPasswordUser spu = null;
        Vector<String> v2 = new Vector<String>();
        try {
            FilePassword filePassword = this.passwords;
            synchronized (filePassword) {
                spu = (SharedPasswordUser)this.getUser(username);
            }
            Privilege[] priv = spu.getGroups();
            int i2 = 0;
            while (i2 < priv.length) {
                v2.add(new String(priv[i2].getName()));
                ++i2;
            }
        }
        catch (Exception e10) {
            throw new InvalidOperationException(e10.toString());
        }
        return v2.elements();
    }

    public void addGroup(String groupName) throws BadRealmException {
        if (this.privileges != null) {
            String[] values = this.privileges.get("Groups");
            if (values != null) {
                int i2 = 0;
                while (i2 < values.length) {
                    if (values[i2].equals(groupName)) {
                        String msg = localStrings.getLocalString("sharedpassword.duplicate_group", "There is already a group named {0} ", new Object[]{groupName});
                        throw new BadRealmException(msg);
                    }
                    ++i2;
                }
            }
        } else {
            throw new BadRealmException(localStrings.getLocalString("sharedpassword.not_supported", "Not Supported"));
        }
        this.privileges.set("Groups", groupName);
    }

    public void removeGroup(String groupName) throws BadRealmException, GroupNotEmptyException {
        if (this.privileges != null) {
            String listOfUsers = this.passwords.getUsersInGroup(groupName);
            if (listOfUsers != null) {
                throw new GroupNotEmptyException(localStrings.getLocalString("sharedpassword.not_empty_group", "Group has users: {0} , remove the users first!", new Object[]{listOfUsers}));
            }
        } else {
            throw new BadRealmException(localStrings.getLocalString("sharedpassword.not_supported", "Not Supported"));
        }
        this.privileges.remove("Groups", groupName);
    }

    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        if (!this.initted) {
            this.initted = true;
            super.init(props);
            String dirname = FileUtil.getAbsolutePath(props.getProperty(PASSWORD_DIR_PROP));
            this.passwords = new FilePassword(dirname + File.separator + PASSWORD_FILE_NAME);
            this.privileges = new FilePrivileges(dirname + File.separator + PRIVILEGES_FILE_NAME);
        }
    }

    public Enumeration getUserNames() {
        return this.passwords.users();
    }

    public User getUser(String name) throws NoSuchUserException {
        name = name.replace(' ', '_');
        return new SharedPasswordUser(this, name);
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    public void createUser(String userName, String password, String[] groups) throws BadRealmException {
        FilePassword filePassword = this.passwords;
        synchronized (filePassword) {
            try {
                User u2 = this.getUser(userName);
                String message = localStrings.getLocalString("sharedpassword.duplicate_user", "There is already a user named {0}.", new Object[]{userName});
                throw new BadRealmException(message);
            }
            catch (NoSuchUserException e10) {
                String group = this.allGroupsPresent(groups);
                if (group != null) {
                    String message = localStrings.getLocalString("sharedpassword.group_absent", "Cannot add user. Please add group {0} first.", new Object[]{group});
                    throw new BadRealmException(message);
                }
                this.passwords.addUser(userName, password, groups);
            }
        }
    }

    private String allGroupsPresent(String[] grpsToCheck) {
        String[] grpsInRealm = this.privileges.get("Groups");
        int i2 = 0;
        while (i2 < grpsToCheck.length) {
            boolean present = true;
            int j2 = 0;
            while (j2 < grpsInRealm.length) {
                if (grpsToCheck[i2].equals(grpsInRealm[j2])) {
                    present = true;
                    break;
                }
                present = false;
                ++j2;
            }
            if (!present) {
                return grpsToCheck[i2];
            }
            ++i2;
        }
        return null;
    }

    public void deleteUser(String userName) throws BadRealmException, NoSuchUserException {
        FilePassword filePassword = this.passwords;
        synchronized (filePassword) {
            User u2 = this.getUser(userName);
            this.passwords.removeUser(userName);
        }
    }

    public void refresh() throws BadRealmException {
        SharedPasswordRealm sharedPasswordRealm = this;
        synchronized (sharedPasswordRealm) {
            try {
                this.passwords.read();
                this.privileges.read();
            }
            catch (Exception e10) {
                throw new BadRealmException(e10.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

