/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.sqlgen.DBInfoImpl;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.jms.JmsUtil;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogReaderImpl;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.naming.SerialContextProviderImpl;
import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.repository.ConfigurationImpl;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.security.RealmManager;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.ServerObject;
import com.sun.enterprise.server.ServerObjectImpl;
import com.sun.enterprise.tools.deployment.backend.JarInstallerImpl;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.util.DebugController;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.UniqueValueGeneratorBackendImpl;
import com.sun.enterprise.util.Utility;
import com.sun.jms.spi.JMSManager;
import com.sun.web.server.WebServer;
import com.sun.web.server.WebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public final class J2EEServer {
    public static final String ADMIN_PORT = "ejb.http.port";
    public static final String DEFAULT_ADMIN_PORT = "9191";
    public static final String CODEBASE_PREFIX = "http://" + Utility.getLocalHost() + ":";
    public static final String J2EE_HOME = "com.sun.enterprise.home";
    public static final String J2EE_APPNAME = "com.sun.enterprise.appname";
    public static final String JTS_RECOVERABLE = "distributed.transaction.recovery";
    public static final String J2EE_SERVER_ID_PROP = "com.sun.enterprise.J2EEServerId";
    public static SecureRandom secureRandom = new SecureRandom();
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$server$J2EEServer == null ? (class$com$sun$enterprise$server$J2EEServer = J2EEServer.class$("com.sun.enterprise.server.J2EEServer")) : class$com$sun$enterprise$server$J2EEServer);
    private static PrintStream ostream = System.out;
    private static PrintStream estream = System.err;
    private static final int J2EE_SERVERID = 100;
    private static final int MAX_INITIAL_CONTEXT_RETRIES = 15;
    private static final String VERBOSE = "-verbose";
    private static final String HELP = "-help";
    private static final String VERSION = "-version";
    private static final String FULL_VERSION = "-fullversion";
    private static final String SINGLEVM = "-singleVM";
    private static final String MULTIVM = "-multiVM";
    private static final String DEBUG = "-debug";
    private static final String STOP = "-stop";
    private static final String NOJMS = "-noJMS";
    private static final String INSTRUMENT = "-instrument";
    private static final String APPLICATIONS_DIRECTORY = "ejb.applications.directory";
    private static final String REPOSITORY_DIRECTORY = "ejb.repository.directory";
    private static final String REPOSITORY_DIR_SYSTEMPROP = "com.sun.enterprise.repository.directory";
    private static final String CODEBASE_PROP = "java.rmi.server.codebase";
    private static final String DefaultDbDir = "orb.db";
    private static final String CATALINA_HOME = "catalina.home";
    private static final String CATALINA_NAMING = "catalina.useNaming";
    private static final String LISTEN_PROP = "com.sun.CORBA.connection.ORBListenSocket";
    private static final String DEFAULT_KEYSTORE_PROP = SSLUtils.getKeyStoreProp();
    private static final String DEFAULT_KEYSTORE_NAME = SSLUtils.getDefaultKeyStoreName();
    private static final String SERVEROBJECT_NAME = "ServerObject";
    private static final String OUTPUT_LOG = "system.out";
    private static final String ERROR_LOG = "system.err";
    private File repositoryDir;
    private Properties defaultProperties;
    private int orbInitialPort;
    private Configuration conf = null;
    private ORB orb;
    private ProtocolManager protocolMgr;
    private JMSManager jmsManager = null;
    private boolean shutdownStarted = false;
    static /* synthetic */ Class class$com$sun$enterprise$server$J2EEServer;
    static /* synthetic */ Class class$com$sun$enterprise$server$ServerObject;

    private void run(String[] args, boolean verbose, boolean startJMS) {
        try {
            String secureSeedFileName = System.getProperty(J2EE_HOME) + File.separator + "lib" + File.separator + "security" + File.separator + "secure.seed";
            File secureSeedFile = new File(secureSeedFileName);
            long seed = this.readSecureSeed(secureSeedFile);
            secureRandom.setSeed(seed);
            seed = secureRandom.nextLong();
            this.writeSecureSeed(secureSeedFile, seed);
            secureSeedFile = null;
            this.defaultProperties = Utility.getPropertiesFromFile("default.properties");
            Properties props = System.getProperties();
            String repname = "repository";
            try {
                ConfigurationImpl config = new ConfigurationImpl();
                repname = config.getProperty(REPOSITORY_DIRECTORY);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String repositoryDirName = repname + File.separator + Utility.getLocalHost();
            ((Hashtable)props).put(REPOSITORY_DIR_SYSTEMPROP, FileUtil.getAbsolutePath(repositoryDirName));
            String serverId = new Integer(100).toString();
            props.setProperty(J2EE_SERVER_ID_PROP, serverId);
            props.setProperty(J2EE_APPNAME, "j2ee");
            try {
                this.orb = this.createORB(args);
                try {
                    Object obj = this.orb.resolve_initial_references("RootPOA");
                }
                catch (InvalidName in) {
                    in.printStackTrace();
                }
            }
            catch (Exception ex3) {
                Log.err.println(ex3);
                throw new RuntimeException("Unable to create ORB. Possible causes include TCP/IP ports in use by another process");
            }
            this.createRepositoryDir();
            if (!verbose) {
                this.redirectStreams();
            }
            Switch theSwitch = Switch.getSwitch();
            theSwitch.setContainerType(2);
            this.protocolMgr = new POAProtocolMgr(this.orb);
            theSwitch.setProtocolManager(this.protocolMgr);
            this.protocolMgr.setPersistentServerPort(ORBManager.getORBInitialPort());
            this.protocolMgr.setPersistentServerId(100);
            this.protocolMgr.initializeNaming(this.repositoryDir, this.orbInitialPort);
            ((POAProtocolMgr)this.protocolMgr).initializePOAs();
            System.out.println(localStrings.getLocalString("j2ee.naming", "Naming service started: ") + this.orbInitialPort);
            SerialContextProviderImpl.initSerialContextProvider();
            InvocationManagerImpl invMgr = new InvocationManagerImpl();
            theSwitch.setInvocationManager(invMgr);
            NamingManagerImpl nm = new NamingManagerImpl();
            theSwitch.setNamingManager(nm);
            this.createServerObject();
            this.protocolMgr.initTransactionService("com.sun.jts.CosTransactions.DefaultTransactionService");
            this.createConfiguration();
            File dir = LogUtil.getLogDirectory("j2ee", "j2ee");
            LogUtil.initDefaultLogFiles(dir);
            this.startAuthenticationService();
            J2EETransactionManager tm = J2EETransactionManagerImpl.createTransactionManager();
            theSwitch.setTransactionManager(tm);
            ResourceInstaller installer = theSwitch.getResourceInstaller();
            installer.installJdbcDataSources();
            installer.installConnectionFactories();
            if (startJMS) {
                this.jmsManager = JmsUtil.startJmsService();
            }
            System.setSecurityManager(new J2EESecurityManager());
            JarManagerImpl jarManager = new JarManagerImpl();
            theSwitch.setEJBJarManager(jarManager);
            ContainerFactoryImpl cf2 = new ContainerFactoryImpl();
            theSwitch.setContainerFactory(cf2);
            String recoverableStr = this.defaultProperties.getProperty(JTS_RECOVERABLE);
            boolean recoverable = "true".equals(recoverableStr);
            if (recoverable) {
                System.err.println(localStrings.getLocalString("ejbserver.recovery", "Perform recovery of XAResources..."));
                installer.recoverXAResources();
            }
            System.setProperty(CATALINA_HOME, System.getProperty(J2EE_HOME));
            System.setProperty(CATALINA_NAMING, "false");
            WebServer webServer = null;
            ServerConfiguration sc = ServerConfiguration.getConfiguration();
            webServer = this.startWebService(sc);
            this.startAdminService(sc);
            JarInstallerImpl jarinstaller = this.createInstaller(webServer);
            nm.publishObject("UserTransaction", (java.lang.Object)new UserTransactionImpl(), true);
            DBInfoImpl dbInfo = new DBInfoImpl();
            this.bindObject(this.orb, "DatabaseInformation", dbInfo);
            UniqueValueGeneratorBackendImpl uniqueValueGen = new UniqueValueGeneratorBackendImpl();
            this.bindObject(this.orb, "J2EE_UNIQUE_VALUE_GEN", uniqueValueGen);
            installer.installResourceAdapters();
            this.loadDeployedApplications();
            this.restoreWebComponents(jarinstaller);
            LogReaderImpl.exportRemoteInterface();
            LogUtil.writevmModeDefaultLogFiles(dir);
            String startupComplete = localStrings.getLocalString("j2ee.started", "J2EE server startup complete.");
            System.out.println(startupComplete);
            if (!verbose) {
                ostream.println(startupComplete);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHelper(this)));
            this.orb.run();
        }
        catch (Exception ex4) {
            ex4.printStackTrace();
            Log.err.println(ex4);
            Log.err.flush();
            throw new RuntimeException(ex4.getMessage());
        }
    }

    private ORB createORB(String[] args) throws Exception {
        Properties props = new Properties();
        String recoverableStr = this.defaultProperties.getProperty(JTS_RECOVERABLE);
        boolean recoverable = "true".equals(recoverableStr);
        J2EEServer.initJTSProperties(recoverable, true, props);
        ORBManager.init(args, props);
        this.orbInitialPort = ORBManager.getORBInitialPort();
        System.out.println(localStrings.getLocalString("j2ee.listenPort", "J2EE server listen port: ") + this.orbInitialPort);
        return ORBManager.getORB();
    }

    public static void initJTSProperties(boolean recoverable, boolean lateRegistration, Properties props) {
        if (!lateRegistration) {
            ((Hashtable)props).put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        }
        if (recoverable) {
            String serverId = System.getProperty(J2EE_SERVER_ID_PROP);
            if (serverId == null) {
                serverId = "0";
            }
            ((Hashtable)props).put(J2EE_SERVER_ID_PROP, serverId);
            ((Hashtable)props).put("com.sun.jts.ManualRecovery", "true");
            String hostname = "";
            try {
                InetAddress ia = InetAddress.getLocalHost();
                hostname = ia.getHostName();
            }
            catch (UnknownHostException ex2) {
                hostname = "localhost";
            }
            String logdir = FileUtil.getAbsolutePath("logs/" + hostname + "/jts");
            new File(logdir).mkdirs();
            ((Hashtable)props).put("com.sun.jts.logDirectory", logdir);
        }
    }

    private JarInstallerImpl createInstaller(WebServer httpd) {
        JarInstallerImpl impl = null;
        try {
            impl = new JarInstallerImpl(httpd, this.getApplicationDirectory());
            PortableRemoteObject.exportObject((Remote)impl);
            this.bindObject(this.orb, "JarInstaller", impl);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new RuntimeException("Unable to create JarInstaller remote object");
        }
        return impl;
    }

    private void createServerObject() {
        ServerObjectImpl impl = null;
        try {
            impl = new ServerObjectImpl(this);
            this.bindObject(this.orb, SERVEROBJECT_NAME, impl);
        }
        catch (Exception e10) {
            Log.err.println(e10);
            throw new RuntimeException("Unable to create ServerObjectImpl remote object");
        }
    }

    private void loadDeployedApplications() throws MalformedURLException {
        try {
            JarManagerImpl jarimpl = Switch.getSwitch().getEJBJarManager();
            Vector appList = JarRepository.getApplicationList();
            int i2 = 0;
            while (i2 < appList.size()) {
                String name = (String)appList.elementAt(i2);
                String url = JarRepository.getJarName(name);
                String jarfile = new URL(url).getFile();
                System.out.println(localStrings.getLocalString("j2ee.load", "Loading jar:{0}", new java.lang.Object[]{jarfile}));
                jarimpl.loadJar(jarfile);
                ++i2;
            }
        }
        catch (RemoteException re) {
            Log.err.println(re);
        }
    }

    private File getApplicationDirectory() {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String repname = config.getProperty(REPOSITORY_DIRECTORY, "repository");
        String dirname = config.getProperty(APPLICATIONS_DIRECTORY, "applications");
        String docRoot = repname + File.separator + Utility.getLocalHost() + File.separator + dirname;
        File applicationDirectory = new File(FileUtil.getAbsolutePath(docRoot));
        applicationDirectory.mkdirs();
        return applicationDirectory;
    }

    void redirectStreams() throws Exception {
        String appname = System.getProperty(J2EE_APPNAME, "j2ee");
        File logDir = LogUtil.getLogDirectory(appname, "j2ee");
        File ofile = new File(logDir, OUTPUT_LOG);
        FileOutputStream foutStream = new FileOutputStream(ofile.getAbsolutePath(), true);
        File efile = new File(logDir, ERROR_LOG);
        FileOutputStream ferrStream = new FileOutputStream(efile.getAbsolutePath(), true);
        PrintStream pSout = new PrintStream(foutStream, true);
        PrintStream pSerr = new PrintStream(ferrStream, true);
        LogUtil.printInfo(pSout);
        LogUtil.printInfo(pSerr);
        System.setOut(pSout);
        System.setErr(pSerr);
        ostream.println(localStrings.getLocalString("j2ee.redirect", "Redirecting the output and error streams to the following files:"));
        ostream.println(ofile.getAbsolutePath());
        ostream.println(efile.getAbsolutePath());
    }

    private void createConfiguration() throws RemoteException, NamingException {
        this.conf = new ConfigurationImpl();
        PortableRemoteObject.exportObject((Remote)this.conf);
        this.bindObject(this.orb, "ServerConfiguration", this.conf);
    }

    private void createRepositoryDir() {
        Properties props = System.getProperties();
        this.repositoryDir = new File(props.getProperty(REPOSITORY_DIR_SYSTEMPROP, props.getProperty("user.dir") + File.separator + "repository"));
        String reposDirName = this.repositoryDir.getAbsolutePath();
        ((Hashtable)props).put(REPOSITORY_DIR_SYSTEMPROP, reposDirName);
        if (!this.repositoryDir.exists()) {
            this.repositoryDir.mkdir();
        }
    }

    private void bindObject(ORB orb, String publishedName, Remote remote) throws RemoteException, NamingException {
        Tie servantsTie = Util.getTie((Remote)remote);
        servantsTie.orb(orb);
        NamingManager namingMgr = Switch.getSwitch().getNamingManager();
        namingMgr.publishObject(publishedName, (java.lang.Object)servantsTie, true);
    }

    private WebService startAdminService(ServerConfiguration sc) throws Exception {
        String httpPort = null;
        java.lang.Object root = null;
        httpPort = sc.getProperty(ADMIN_PORT, DEFAULT_ADMIN_PORT);
        String rootDir = this.getApplicationDirectory().getAbsolutePath();
        WebService admin = new WebService(Utility.getLocalHost(), rootDir, false);
        admin.addConnector(Integer.valueOf(httpPort), -1, null, false);
        admin.start();
        return admin;
    }

    private WebServer startWebService(ServerConfiguration sc) throws Exception {
        WebServer server = WebServer.getInstance();
        server.start();
        return server;
    }

    private void startAuthenticationService() {
        try {
            RealmManager rlmMgr = new RealmManager();
            rlmMgr.init();
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
        }
    }

    /*
     * Loose catch block
     */
    private void restoreWebComponents(JarInstallerImpl jarinstaller) {
        int i2 = 0;
        while (i2 < 15) {
            jarinstaller.restoreWebComponents();
            java.lang.Object var5_3 = null;
            try {
                Thread.sleep(3000L);
            }
            catch (Exception ie) {}
            break;
            {
                catch (Exception e10) {
                    var5_3 = null;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception ie) {}
                }
            }
            catch (Throwable throwable) {
                var5_3 = null;
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception ie) {
                    // empty catch block
                }
                throw throwable;
            }
            ++i2;
        }
    }

    private long readSecureSeed(File fname) {
        try {
            FileInputStream fis = new FileInputStream(fname);
            try {
                byte[] seed = new byte[8];
                fis.read(seed);
                fis.close();
                Long lseed = new Long(new String(seed));
                return lseed;
            }
            catch (IOException e10) {
                if (fis != null) {
                    fis.close();
                }
                return secureRandom.nextLong();
            }
        }
        catch (IOException e11) {
            return secureRandom.nextLong();
        }
    }

    private void writeSecureSeed(File fname, long seed) {
        try {
            FileOutputStream fos = new FileOutputStream(fname);
            String sseed = Long.toString(seed);
            fos.write(sseed.getBytes());
            fos.close();
        }
        catch (IOException e10) {
            String errmsg = localStrings.getLocalString("j2ee.startupslow", "Cannot write the seed file for fast startup. The next startup will be slow.");
            System.err.println(errmsg);
        }
    }

    private static void printHelp(PrintStream out) {
        out.println(localStrings.getLocalString("j2ee.server", "Java 2 Enterprise Edition"));
        out.println(localStrings.getLocalString("j2ee.options", "Options:"));
        out.print("    ");
        out.println("-verbose\t\t" + localStrings.getLocalString("j2ee.verbose", "Redirect logging output to the current shell."));
        out.print("    ");
        out.println("-help\t\t" + localStrings.getLocalString("j2ee.help", "Print this help message."));
        out.print("    ");
        out.println("-version\t\t" + localStrings.getLocalString("j2ee.version", "Print the version."));
        out.print("    ");
        out.println("-stop\t\t" + localStrings.getLocalString("j2ee.stop", "Stop the J2EE server."));
    }

    public static void main(String[] args) {
        Utility.checkJVMVersion();
        boolean verbose = false;
        boolean startJMS = true;
        boolean dbg = false;
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].trim().equals(HELP)) {
                J2EEServer.printHelp(System.out);
                return;
            }
            if (args[i2].trim().equals(STOP)) {
                J2EEServer.clientShutdown();
                return;
            }
            if (args[i2].trim().equals(VERSION) || args[i2].trim().equals(FULL_VERSION)) {
                System.out.println(localStrings.getLocalString("j2ee.server_version", "Java 2 Enterprise Edition version ", new String[]{"1.3.1", "1.3.1-b17"}));
                return;
            }
            if (args[i2].trim().equals(VERBOSE)) {
                verbose = true;
            } else if (args[i2].trim().equals(DEBUG)) {
                dbg = true;
            } else if (!args[i2].trim().equals(SINGLEVM)) {
                if (args[i2].trim().equals(MULTIVM)) {
                    System.out.println(localStrings.getLocalString("j2ee.msg001", "Warning: The multi-VM mode is no longer supported. Starting in single VM mode."));
                } else if (args[i2].trim().equals(NOJMS)) {
                    startJMS = false;
                } else if (args[i2].trim().equals(INSTRUMENT)) {
                    AppVerification.setInstrument(true);
                } else {
                    J2EEServer.printHelp(System.out);
                    return;
                }
            }
            ++i2;
        }
        try {
            if (dbg) {
                DebugController.init();
            }
            J2EEServer j2ee = new J2EEServer();
            j2ee.run(args, verbose, startJMS);
        }
        catch (Exception e10) {
            e10.printStackTrace();
            if (e10.getMessage() != null) {
                System.err.println("J2EE server reported the following error: " + e10.getMessage());
            }
            System.err.println("Error executing J2EE server ...");
            System.err.flush();
            System.exit(1);
        }
    }

    private static void clientShutdown() {
        ServerObject server = null;
        try {
            System.setProperty(LISTEN_PROP, "");
            System.out.println(localStrings.getLocalString("j2ee.shutdown", "Shutting down the J2EE server..."));
            server = (ServerObject)Utility.lookupObject(SERVEROBJECT_NAME, class$com$sun$enterprise$server$ServerObject == null ? (class$com$sun$enterprise$server$ServerObject = J2EEServer.class$("com.sun.enterprise.server.ServerObject")) : class$com$sun$enterprise$server$ServerObject);
        }
        catch (Throwable t2) {
            Log.err.println(t2);
            System.out.println(localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
        }
        try {
            if (server != null) {
                server.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void shutdown() {
        if (this.shutdownStarted) {
            return;
        }
        try {
            this.shutdownNoExit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    void shutdownNoExit() {
        try {
            System.out.println(localStrings.getLocalString("j2ee.shutdown", "Shutting down the J2EE server..."));
            this.shutdownStarted = true;
            if (AppVerification.doInstrument()) {
                AppVerification.getInstrumentLogger().writeResults();
            }
            this.shutdownJMSService();
            Log.flushAll();
        }
        catch (Throwable t2) {
            Log.err.println(t2);
            System.out.println(localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
        }
    }

    private void shutdownJMSService() {
        try {
            System.out.println(localStrings.getLocalString("jms.shutdown", "Shutting down JMS service..."));
            if (this.jmsManager != null) {
                this.jmsManager.stopJMSService();
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (Switch.getSwitch().getContainerType() != 1) {
            System.setProperty(DEFAULT_KEYSTORE_PROP, DEFAULT_KEYSTORE_NAME);
        }
    }

    class ShutdownHelper
    implements Runnable {
        private J2EEServer j2eeServer;

        ShutdownHelper(J2EEServer j2eeServer) {
            this.j2eeServer = j2eeServer;
        }

        public void run() {
            try {
                if (!J2EEServer.this.shutdownStarted) {
                    this.j2eeServer.shutdownNoExit();
                }
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                System.out.println(localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
            }
        }
    }
}

