/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admin;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.security.IRealmManager;
import com.sun.enterprise.security.RealmManager;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordRealm;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class RealmTool {
    private static boolean debug = false;
    private static final String DEFAULT_USER = "auth.default.principal.name";
    private static final String DEFAULT_PASS = "auth.default.principal.password";
    private static String SHOW = "-show";
    private static String LIST = "-list";
    private static String ADD = "-add";
    private static String ADD_GROUP = "-addGroup";
    private static String REMOVE = "-remove";
    private static String REMOVE_GROUP = "-removeGroup";
    private static String IMPORT = "-import";
    private static String LIST_GROUP = "-listGroups";
    private static String LIST_USER_GROUPS = "-userGroups";
    private static String REALMS_LIST = "auth.realms";
    private static String REALM_PREFIX = "auth.realm.";
    private static ServerConfiguration config = ServerConfiguration.getConfiguration();
    private static IRealmManager rlmMgr = null;
    private static JarInstaller dtool = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$admin$RealmTool == null ? (class$com$sun$enterprise$tools$admin$RealmTool = RealmTool.class$("com.sun.enterprise.tools.admin.RealmTool")) : class$com$sun$enterprise$tools$admin$RealmTool);
    static /* synthetic */ Class class$com$sun$enterprise$tools$admin$RealmTool;
    static /* synthetic */ Class class$com$sun$enterprise$security$IRealmManager;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarInstaller;

    public static Realm getDefaultRealm() {
        Realm r2 = null;
        try {
            block4: {
                try {
                    r2 = Realm.getInstance("default");
                    if (r2 != null) break block4;
                    Realm.initialize();
                    r2 = Realm.getInstance("default");
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                    Object var3_2 = null;
                    return r2;
                }
            }
            Object var3_1 = null;
            return r2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            return r2;
        }
    }

    public static void main(String[] args) {
        Utility.checkJVMVersion();
        try {
            Realm.initialize();
            if (args.length == 0) {
                RealmTool.help();
            } else if (args[0].equals(LIST)) {
                Realm r2;
                if (args.length != 2) {
                    RealmTool.help();
                }
                if ((r2 = Realm.getInstance(args[1].trim())) == null) {
                    System.err.println(localStrings.getLocalString("tools.admin.invalidrealm", "Invalid realm: {0}", new Object[]{args[1]}));
                    RealmTool.help();
                }
                Enumeration e10 = r2.getUserNames();
                while (e10.hasMoreElements()) {
                    System.out.println(e10.nextElement());
                }
            } else if (args[0].equals(SHOW)) {
                String[] realms;
                if (args.length != 1) {
                    RealmTool.help();
                }
                if ((realms = Realm.getSupported()) == null) {
                    System.err.println(localStrings.getLocalString("tools.admin.realmunavailable", "No realms currently available."));
                    RealmTool.help();
                }
                if (realms.length > 0) {
                    System.out.println(localStrings.getLocalString("tools.admin.realmsupported", "The following realms are supported:"));
                    int i2 = 0;
                    while (i2 < realms.length) {
                        System.out.println(realms[i2]);
                        ++i2;
                    }
                }
            } else if (args[0].equals(ADD)) {
                if (args.length != 4) {
                    RealmTool.help();
                }
                SharedPasswordRealm r3 = (SharedPasswordRealm)RealmTool.getDefaultRealm();
                String username = args[1];
                String pass = args[2];
                String groups = args[3];
                r3.createUser(username.trim(), pass.trim(), TypeUtil.stringToArray(groups.trim(), ","));
                System.out.println(localStrings.getLocalString("tools.admin.useradded", "User {0} has been added successfully.", new Object[]{username.trim()}));
                if (rlmMgr != null) {
                    rlmMgr.refreshRealms(r3.getName());
                } else {
                    System.out.println(localStrings.getLocalString("tools.admin.restartserver", "This change will take effect after starting the J2EE server."));
                }
                if (dtool != null) {
                    dtool.changed();
                }
            } else if (args[0].equals(ADD_GROUP)) {
                if (args.length != 2) {
                    RealmTool.help();
                }
                SharedPasswordRealm r4 = (SharedPasswordRealm)RealmTool.getDefaultRealm();
                String group = args[1];
                r4.addGroup(group.trim());
                System.out.println(localStrings.getLocalString("tools.admin.groupadded", "Group {0} has been added successfully.", new Object[]{group.trim()}));
                if (rlmMgr != null) {
                    rlmMgr.refreshRealms(r4.getName());
                } else {
                    System.out.println(localStrings.getLocalString("tools.admin.restartserver", "This change will take effect after starting the J2EE server."));
                }
                if (dtool != null) {
                    dtool.changed();
                }
            } else if (args[0].equals(LIST_GROUP)) {
                if (args.length != 1) {
                    RealmTool.help();
                }
                SharedPasswordRealm r5 = (SharedPasswordRealm)RealmTool.getDefaultRealm();
                Enumeration en2 = r5.getGroupNames();
                while (en2.hasMoreElements()) {
                    System.out.println(en2.nextElement());
                }
            } else if (args[0].equals(LIST_USER_GROUPS)) {
                if (args.length != 2) {
                    RealmTool.help();
                }
                SharedPasswordRealm r6 = (SharedPasswordRealm)RealmTool.getDefaultRealm();
                String username = args[1];
                Enumeration en3 = r6.getGroupNames(username);
                while (en3.hasMoreElements()) {
                    System.out.println(en3.nextElement());
                }
            } else if (args[0].equals(REMOVE_GROUP)) {
                if (args.length != 2) {
                    RealmTool.help();
                }
                SharedPasswordRealm r7 = (SharedPasswordRealm)RealmTool.getDefaultRealm();
                String group = args[1];
                r7.removeGroup(group.trim());
                System.out.println(localStrings.getLocalString("tools.admin.groupremoved", "Group {0} has been removed successfully.", new Object[]{group.trim()}));
                if (dtool != null) {
                    dtool.changed();
                }
                if (rlmMgr != null) {
                    rlmMgr.refreshRealms(r7.getName());
                } else {
                    System.out.println(localStrings.getLocalString("tools.admin.restartserver", "This change will take effect after starting the J2EE server."));
                }
            } else if (args[0].equals(IMPORT)) {
                if (args.length != 2) {
                    RealmTool.help();
                }
                CertificateRealm r8 = (CertificateRealm)Realm.getInstance("certificate");
                String certfile = args[1];
                FileInputStream fis = new FileInputStream(certfile.trim());
                DataInputStream dis = new DataInputStream(fis);
                CertificateFactory cf2 = CertificateFactory.getInstance("X.509");
                byte[] bytes = new byte[dis.available()];
                dis.readFully(bytes);
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                X509Certificate[] certs = new X509Certificate[]{};
                Vector<X509Certificate> v2 = new Vector<X509Certificate>();
                if (bais.available() > 0) {
                    X509Certificate cert = (X509Certificate)cf2.generateCertificate(bais);
                    v2.addElement(cert);
                }
                certs = v2.toArray(certs);
                Object username = null;
                if (certs.length <= 0) {
                    throw new Exception(localStrings.getLocalString("tools.admin.usernotadded", "No user found in the certificate."));
                }
                String subject = certs[0].getSubjectDN().getName();
                System.out.println(" Subject = " + subject);
                r8.createUser(subject.trim(), certs[0].getEncoded());
                System.out.println(localStrings.getLocalString("tools.admin.useradded", "User {0} has been added successfully.", new Object[]{subject.trim()}));
                if (dtool != null) {
                    dtool.changed();
                }
                if (rlmMgr != null) {
                    rlmMgr.refreshRealms(r8.getName());
                } else {
                    System.out.println(localStrings.getLocalString("tools.admin.restartserver", "This change will take effect after starting the J2EE server."));
                }
            } else if (args[0].equals(REMOVE)) {
                Realm r9;
                if (args.length != 3) {
                    RealmTool.help();
                }
                if ((r9 = Realm.getInstance(args[1].trim())) == null) {
                    System.err.println(localStrings.getLocalString("tools.admin.invalidrealm", "Invalid realm: {0}", new Object[]{args[1]}));
                    RealmTool.help();
                }
                String defaultUser = config.getProperty(DEFAULT_USER, "guest").trim();
                String defaultPassword = config.getProperty(DEFAULT_PASS, "guest123").trim();
                String username = args[2].trim();
                if (!username.equals(defaultUser)) {
                    if (args[1].trim().equals("default")) {
                        ((SharedPasswordRealm)r9).deleteUser(username.trim());
                    } else if (args[1].trim().equals("certificate")) {
                        ((CertificateRealm)r9).deleteUser(username.trim());
                    }
                    System.out.println(localStrings.getLocalString("tools.admin.userremoved", "User {0} has been removed successfully.", new Object[]{username.trim()}));
                    if (dtool != null) {
                        dtool.changed();
                    }
                    if (rlmMgr != null) {
                        rlmMgr.refreshRealms(r9.getName());
                    } else {
                        System.out.println(localStrings.getLocalString("tools.admin.restartserver", "This change will take effect after starting the J2EE server."));
                    }
                } else {
                    System.out.println(localStrings.getLocalString("tools.admin.userremovefailed", "User {0} could not be removed.", new Object[]{username.trim()}));
                }
            } else {
                RealmTool.help();
            }
        }
        catch (Exception e11) {
            System.err.println(e11);
            e11.printStackTrace();
        }
        System.exit(0);
    }

    public static void help() {
        System.out.println(localStrings.getLocalString("tools.admin.realmtool", "RealmTool"));
        System.out.println(localStrings.getLocalString("tools.admin.realmtooloptions", "Options:"));
        System.out.println(" " + SHOW);
        System.out.println(" " + LIST + "\t\trealm-name");
        System.out.println(" " + ADD + "\t\tusername password group[,group]");
        System.out.println(" " + ADD_GROUP + "\tgroup");
        System.out.println(" " + IMPORT + "\tcertificate-file");
        System.out.println(" " + LIST_GROUP);
        System.out.println(" " + LIST_USER_GROUPS + "\tusername");
        System.out.println(" " + REMOVE + "\trealm-name username");
        System.out.println(" " + REMOVE_GROUP + "\tgroup");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ORBManager.init(null, null);
            rlmMgr = (IRealmManager)Utility.lookupObject(RealmManager.REALM_MANAGER_NAME, class$com$sun$enterprise$security$IRealmManager == null ? (class$com$sun$enterprise$security$IRealmManager = RealmTool.class$("com.sun.enterprise.security.IRealmManager")) : class$com$sun$enterprise$security$IRealmManager);
            dtool = (JarInstaller)Utility.lookupObject("JarInstaller", class$com$sun$enterprise$tools$deployment$backend$JarInstaller == null ? (class$com$sun$enterprise$tools$deployment$backend$JarInstaller = RealmTool.class$("com.sun.enterprise.tools.deployment.backend.JarInstaller")) : class$com$sun$enterprise$tools$deployment$backend$JarInstaller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

