/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.PMDeployer;
import com.sun.ejb.PersistenceUtils;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.tools.deployment.backend.JarInfo;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class JarManagerImpl {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$backend$JarManagerImpl == null ? (class$com$sun$enterprise$tools$deployment$backend$JarManagerImpl = JarManagerImpl.class$("com.sun.enterprise.tools.deployment.backend.JarManagerImpl")) : class$com$sun$enterprise$tools$deployment$backend$JarManagerImpl);
    private boolean useOneLoader;
    private Hashtable jars = new Hashtable();
    private Hashtable appTable = new Hashtable();
    private Hashtable containerTable = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarManagerImpl;

    private Set getEJBClasses(Application app, ClassLoader loader) throws ClassNotFoundException {
        HashSet<String> result = new HashSet<String>();
        Enumeration e10 = app.getEjbDescriptors().elements();
        while (e10.hasMoreElements()) {
            EjbDescriptor next = (EjbDescriptor)e10.nextElement();
            String ejbClassName = next.getEjbClassName();
            Class<?> clz = loader.loadClass(ejbClassName);
            do {
                result.add(clz.getName());
            } while ((clz = clz.getSuperclass()) != null);
        }
        return result;
    }

    public void loadJar(String jarName) throws RemoteException {
        try {
            File applicationJarFile = new File(jarName);
            Application application = ApplicationArchivist.open(applicationJarFile, true);
            JarClassLoader jcl = new JarClassLoader();
            jcl.appendURL(applicationJarFile.toURL());
            Set ejbClasses = this.getEJBClasses(application, jcl);
            final ClassLoader loader = application.getApplicationArchivist().getClassLoader();
            ((JarClassLoader)loader).addEjbClassNames(ejbClasses);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(loader);
                    return null;
                }
            });
            JarInfo jar = new JarInfo(application);
            this.jars.put(application.getName(), jar);
            this.appTable.put(loader, application);
            Vector beanDescriptors = application.getEjbDescriptors();
            Enumeration e10 = beanDescriptors.elements();
            ContainerFactory cf2 = Switch.getSwitch().getContainerFactory();
            while (e10.hasMoreElements()) {
                EjbDescriptor nextDescriptor = (EjbDescriptor)e10.nextElement();
                try {
                    EJBSecurityManager sm = new EJBSecurityManager(loader, nextDescriptor);
                    Container container = cf2.createContainer(nextDescriptor, loader, sm);
                    jar.addContainer(nextDescriptor.getUniqueId(), container);
                    this.containerTable.put(nextDescriptor, container);
                }
                catch (Exception beanEx) {
                    this.undeploy(application.getName());
                    throw beanEx;
                }
            }
            Iterator itr = application.getEjbBundleDescriptors().iterator();
            while (itr.hasNext()) {
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)itr.next();
                PMDeployer pd = PersistenceUtils.getPMDeployer(ebd);
                pd.ejbJarDeployed();
            }
            Enumeration containers = jar.listContainers();
            while (containers.hasMoreElements()) {
                Container c10 = (Container)containers.nextElement();
                c10.doAfterApplicationDeploy();
            }
        }
        catch (Exception ex2) {
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.errorloadingjar", "Error while loading JAR {0} ", new Object[]{jarName}), ex2);
        }
    }

    public synchronized void undeploy(String appName) {
        Object result;
        Switch theSwitch = Switch.getSwitch();
        JarInfo jarInfo = (JarInfo)this.jars.get(appName);
        if (jarInfo == null) {
            return;
        }
        ContainerFactory cf2 = Switch.getSwitch().getContainerFactory();
        Enumeration containers = jarInfo.listContainers();
        while (containers.hasMoreElements()) {
            Container c10 = (Container)containers.nextElement();
            EjbDescriptor ejbDesc = c10.getEjbDescriptor();
            cf2.removeContainer(ejbDesc.getUniqueId());
            c10.undeploy();
            result = this.containerTable.remove(ejbDesc);
            if (result != null) continue;
            Log.err.println(new IllegalStateException("cannot cleanup containerTable: " + ejbDesc));
        }
        this.jars.remove(appName);
        Iterator itr = jarInfo.application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)itr.next();
            PMDeployer pd = PersistenceUtils.getPMDeployer(ebd);
            pd.ejbJarUnDeployed();
        }
        ClassLoader loader = this.getClassLoaderForApplication(appName);
        result = this.appTable.remove(loader);
        if (result == null) {
            Log.err.println(new IllegalStateException("cannot cleanup appTable: " + appName));
        }
    }

    public Container getContainer(EjbDescriptor desc) {
        return (Container)this.containerTable.get(desc);
    }

    public Application getApplication(ClassLoader loader) {
        return (Application)this.appTable.get(loader);
    }

    public ClassLoader getClassLoaderForApplication(String appName) {
        Enumeration e10 = this.appTable.keys();
        while (e10.hasMoreElements()) {
            ClassLoader loader = (ClassLoader)e10.nextElement();
            Application app = (Application)this.appTable.get(loader);
            if (!app.getName().equals(appName)) continue;
            return loader;
        }
        return null;
    }

    public Application getApplication(String appName) {
        ClassLoader cl2 = this.getClassLoaderForApplication(appName);
        if (cl2 == null) {
            return null;
        }
        return this.getApplication(cl2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

