/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Vector;

public class JarRepository {
    private static final String SERVERJAR = ".serverJar";
    private static final String ORIGINALJAR = ".originalJar";
    private static final String CLIENTJAR = ".clientJar";
    private static final String WEBJAR = ".webJar";
    private static final String PREFIX = "server.";
    private static final String SERVER = "server";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$backend$JarRepository == null ? (class$com$sun$enterprise$tools$deployment$backend$JarRepository = JarRepository.class$("com.sun.enterprise.tools.deployment.backend.JarRepository")) : class$com$sun$enterprise$tools$deployment$backend$JarRepository);
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarRepository;

    public static boolean removeFromPropsFile(String applicationName) {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String appKey = PREFIX + applicationName;
        String key = appKey + SERVERJAR;
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.removingkey", "Removing: {0}", new Object[]{key}));
        try {
            config.removeProperty(key);
            key = appKey + CLIENTJAR;
            config.removeProperty(key);
            key = appKey + WEBJAR;
            config.removeProperty(key);
            key = appKey + ORIGINALJAR;
            config.removeProperty(key);
        }
        catch (Throwable e10) {
            e10.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getJarName(String applicationName) {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String appKey = PREFIX + applicationName + SERVERJAR;
        String val = config.getProperty(appKey);
        return val;
    }

    public static String getJarFilename(String applicationName) {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String appKey = PREFIX + applicationName + ORIGINALJAR;
        String originalURLString = config.getProperty(appKey);
        try {
            return new URL(originalURLString).getFile();
        }
        catch (MalformedURLException me) {
            me.printStackTrace();
            return null;
        }
    }

    public static String getServerJarFilename(String applicationName) {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String appKey = PREFIX + applicationName + SERVERJAR;
        String originalURLString = config.getProperty(appKey);
        try {
            return new URL(originalURLString).getFile();
        }
        catch (MalformedURLException me) {
            me.printStackTrace();
            return null;
        }
    }

    public static String getClientJarFilename(String applicationName) {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String appKey = PREFIX + applicationName + CLIENTJAR;
        String val = config.getProperty(appKey);
        return val;
    }

    static Vector getApplicationJarFilenamesFor(String applicationName) {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        HashSet<String> applicationJars = new HashSet<String>();
        try {
            String originalURL;
            String webURL;
            String clientURL;
            String appURL = config.getProperty(PREFIX + applicationName + SERVERJAR);
            if (appURL != null) {
                applicationJars.add(new URL(appURL).getFile());
            }
            if ((clientURL = config.getProperty(PREFIX + applicationName + CLIENTJAR)) != null) {
                applicationJars.add(new URL(clientURL).getFile());
            }
            if ((webURL = config.getProperty(PREFIX + applicationName + WEBJAR)) != null) {
                applicationJars.add(new URL(webURL).getFile());
            }
            if ((originalURL = config.getProperty(PREFIX + applicationName + ORIGINALJAR)) != null) {
                applicationJars.add(new URL(originalURL).getFile());
            }
        }
        catch (MalformedURLException me) {
            me.printStackTrace();
        }
        return new Vector(applicationJars);
    }

    static String writeToPropsFile(String applicationName, File original, File serverJar, File clientJar) {
        String name = original.getName();
        String appName = PREFIX + applicationName;
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String originalJarName = appName + ORIGINALJAR;
        String serverJarName = appName + SERVERJAR;
        String clientJarName = appName + CLIENTJAR;
        String webJarName = appName + WEBJAR;
        try {
            URL originalURL = original.toURL();
            URL clientURL = clientJar.toURL();
            URL serverURL = serverJar.toURL();
            config.setProperty(originalJarName, originalURL.toString());
            config.setProperty(clientJarName, clientURL.toString());
            config.setProperty(serverJarName, serverURL.toString());
            config.setProperty(webJarName, serverURL.toString());
        }
        catch (MalformedURLException mue) {
            System.err.println(localStrings.getLocalString("enterprise.tools.deployment.backend.installfailedinrepository", "Failed to install {0} in the repository.", new Object[]{appName}));
            mue.printStackTrace();
        }
        return serverJarName;
    }

    public static Application getApplicationForName(String applicationName) {
        try {
            ServerConfiguration config = ServerConfiguration.getConfiguration();
            String originalURL = config.getProperty(PREFIX + applicationName + ORIGINALJAR);
            if (originalURL != null) {
                File appFile = new File(new URL(originalURL).getFile());
                return ApplicationArchivist.open(appFile);
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        return null;
    }

    public static Vector getApplicationList() {
        Vector<String> v2 = new Vector<String>();
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String[] keys = config.getKeys(SERVER);
        int i2 = 0;
        while (i2 < keys.length) {
            if (keys[i2].endsWith(SERVERJAR)) {
                int idx = keys[i2].lastIndexOf(".");
                String appname = keys[i2].substring(0, idx);
                idx = appname.indexOf(".");
                String name = appname.substring(idx + 1);
                v2.add(name);
            }
            ++i2;
        }
        return v2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

