/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.main.Log;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ApplicationManager
implements NotificationListener {
    public static String ACTIVE_CHANGED = "active changed";
    public static String APPLICATION_CHANGED = "application changed";
    public static String APPLICATION_LIST_CHANGED = "application list changed";
    public static String LISTENER_ADDED = "listener added";
    public static String APPLICATION_ADDED = "application added";
    public static String APPLICATION_REMOVED = "application removed";
    public static String APPLICATION_PROPERTY = "application property";
    private Application activeApplication;
    private Vector applications = new Vector();
    private Vector applicationListeners = new Vector();
    private File preferencesDirectory;
    private File temp;
    private static String CFG_APP_FILE = "applications";
    private String configFileName = CFG_APP_FILE;

    public ApplicationManager(File preferencesDirectory, File temp) {
        this.preferencesDirectory = preferencesDirectory;
        this.temp = temp;
    }

    public File getTemp() {
        return this.temp;
    }

    public Hashtable restoreFromUserHome() throws IOException {
        Hashtable<String, Throwable> badApplicationJarFilenamesToExceptions = new Hashtable<String, Throwable>();
        File appsFile = new File(this.preferencesDirectory, this.getConfigAppFileName());
        if (appsFile.exists()) {
            FileInputStream fis = new FileInputStream(appsFile);
            Properties applications = new Properties();
            applications.load(fis);
            Enumeration<?> e10 = applications.propertyNames();
            while (e10.hasMoreElements()) {
                String appName = (String)e10.nextElement();
                String appJarFilename = applications.getProperty(appName);
                Object openedApp = null;
                try {
                    this.openApplication(new File(appJarFilename));
                }
                catch (Throwable t2) {
                    badApplicationJarFilenamesToExceptions.put(appJarFilename, t2);
                }
            }
            if (fis != null) {
                fis.close();
            }
        }
        return badApplicationJarFilenamesToExceptions;
    }

    public void saveToUserHome() throws IOException {
        File appsFile = new File(this.preferencesDirectory, this.getConfigAppFileName());
        FileOutputStream fos = new FileOutputStream(appsFile);
        Properties applications = new Properties();
        Enumeration e10 = this.getApplications().elements();
        while (e10.hasMoreElements()) {
            Application nextApplication = (Application)e10.nextElement();
            ((Hashtable)applications).put(nextApplication.getName(), nextApplication.getApplicationArchivist().getApplicationFile().toString());
        }
        applications.store(fos, "J2EE Applications");
        if (fos != null) {
            fos.close();
        }
    }

    public void addNotificationListener(NotificationListener nl) {
        this.applicationListeners.addElement(nl);
        this.notify(LISTENER_ADDED, null, null);
    }

    public void removeNotificationListener(NotificationListener nl) {
        this.applicationListeners.removeElement(nl);
    }

    public void setActiveApplication(Application application) {
        if (application != this.activeApplication) {
            this.activeApplication = application;
            if (application != null) {
                this.notify(ACTIVE_CHANGED, APPLICATION_PROPERTY, application);
            } else {
                this.notify(ACTIVE_CHANGED, null, null);
            }
        }
    }

    public Application getActiveApplication() {
        return this.activeApplication;
    }

    public Vector getApplications() {
        Vector clone = (Vector)this.applications.clone();
        return clone;
    }

    public Application getApplicationWithJar(File jarFilename) {
        Enumeration e10 = this.getApplications().elements();
        while (e10.hasMoreElements()) {
            Application application = (Application)e10.nextElement();
            if (!application.getApplicationArchivist().getApplicationFile().getAbsolutePath().equals(jarFilename.getAbsolutePath())) continue;
            return application;
        }
        return null;
    }

    public Vector getApplicationNames() {
        Vector<String> names = new Vector<String>();
        Enumeration e10 = this.applications.elements();
        while (e10.hasMoreElements()) {
            names.addElement(((Application)e10.nextElement()).getName());
        }
        return names;
    }

    protected String getUniqueApplicationName(String trialName) {
        return Descriptor.createUniqueNameAmongst(trialName, this.getApplicationNames());
    }

    public Application newApplication(String name, String jarFile) {
        Application newApplication = new Application(this.getUniqueApplicationName(name), new File(jarFile));
        try {
            this.saveApplication(newApplication);
        }
        catch (IOException ioe) {
            Log.print(this, ioe);
        }
        this.addApplication(newApplication);
        return newApplication;
    }

    public void saveApplication(Application application) throws IOException {
        ApplicationArchivist archivist = application.getApplicationArchivist();
        archivist.save(archivist.getApplicationFile(), true);
    }

    public void saveAsApplication(Application application, File newJar) throws IOException {
        ApplicationArchivist archivist = application.getApplicationArchivist();
        archivist.save(newJar, true);
    }

    public Application openApplication(File name) throws Exception {
        Application openedApplication = ApplicationArchivist.open(name);
        this.addApplication(openedApplication);
        openedApplication.doneOpening();
        return openedApplication;
    }

    public void closeApplication(Application application) {
        this.applications.removeElement(application);
        this.setActiveApplication(null);
        this.notify(APPLICATION_REMOVED, APPLICATION_PROPERTY, application);
    }

    public void addApplication(Application application) {
        String newName = this.getUniqueApplicationName(application.getName());
        application.setName(newName);
        this.applications.addElement(application);
        application.addNotificationListener(this);
        this.notify(APPLICATION_ADDED, APPLICATION_PROPERTY, application);
        this.setActiveApplication(application);
    }

    protected String getConfigAppFileName() {
        return this.configFileName;
    }

    public void setConfigAppFileName(String cfgAppFile) {
        this.configFileName = cfgAppFile != null ? cfgAppFile : CFG_APP_FILE;
    }

    public void notification(NotificationEvent ne) {
        this.notify(ne.getType(), NotificationEvent.OBJECT_THAT_CHANGED, ne.getObjectThatChanged());
    }

    public void notify(String type, String name, Object value) {
        NotificationEvent ne = null;
        ne = name == null ? new NotificationEvent(this, type) : new NotificationEvent(this, type, name, value);
        Vector listenersClone = null;
        Vector vector = this.applicationListeners;
        synchronized (vector) {
            listenersClone = (Vector)this.applicationListeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(ne);
        }
    }

    public String toString() {
        return "Application Manager";
    }
}

