/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.SQLGenerator;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.main.Log;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.main.StandAloneManager;
import com.sun.enterprise.tools.deployment.main.UIFactory;
import com.sun.enterprise.tools.packager.ComponentPackager;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;

public class DeployTool {
    private ApplicationManager applicationManager;
    private StandAloneManager standaloneManager;
    private ServerManager serverManager;
    private ComponentPackager componentPackager;
    private File workingDirectory;
    private File toolHomeDirectory;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$main$DeployTool == null ? (class$com$sun$enterprise$tools$deployment$main$DeployTool = DeployTool.class$("com.sun.enterprise.tools.deployment.main.DeployTool")) : class$com$sun$enterprise$tools$deployment$main$DeployTool);
    public static final String HOME_DIR = ".j2eedeploymenttool";
    private static DeployTool deployToolInstance = null;
    public static final String UI_STARTUP_CLASS = "com.sun.enterprise.tools.deployment.ui.DT";
    protected UIFactory uiFactory = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$main$DeployTool;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$main$UIFactory;

    public DeployTool(boolean hasUI) {
        deployToolInstance = this;
        this.uiFactory = DeployTool.createUIFactory(hasUI);
        if (this.uiFactory != null) {
            File cfgDir = this.uiFactory.getConfigDirectory();
            File tmpDir = this.uiFactory.getTempDirectory();
            this.applicationManager = new ApplicationManager(cfgDir, tmpDir);
            this.standaloneManager = new StandAloneManager(cfgDir, tmpDir);
            this.serverManager = new ServerManager(cfgDir);
            this.uiFactory.startUI();
        } else {
            File toolDir = this.getToolHomeDirectory();
            File tempDir = this.getWorkingDirectory();
            this.applicationManager = new ApplicationManager(toolDir, tempDir);
            this.standaloneManager = new StandAloneManager(toolDir, tempDir);
            this.serverManager = new ServerManager(toolDir);
        }
    }

    public static DeployTool getDeployToolInstance() {
        return deployToolInstance;
    }

    protected static UIFactory createUIFactory(boolean hasUI) {
        if (hasUI) {
            try {
                Class<?> uiFactoryClass = Class.forName(UI_STARTUP_CLASS);
                if (!(class$com$sun$enterprise$tools$deployment$main$UIFactory == null ? (class$com$sun$enterprise$tools$deployment$main$UIFactory = DeployTool.class$("com.sun.enterprise.tools.deployment.main.UIFactory")) : class$com$sun$enterprise$tools$deployment$main$UIFactory).isAssignableFrom(uiFactoryClass)) {
                    throw new ClassCastException("Class does not implement UIFactory");
                }
                return (UIFactory)uiFactoryClass.newInstance();
            }
            catch (Throwable t2) {
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.error_creating_ui", "Unable to create UI: " + t2));
            }
        }
        return null;
    }

    public Application deployStandaloneModule(File moduleFile) throws Exception {
        File tmpDir = FileUtil.getTempDirectory();
        String appName = "app." + moduleFile.getName().replace('.', '_');
        File appFile = new File(tmpDir, appName + ".ear");
        int i2 = 0;
        while (appFile.exists()) {
            appFile = new File(tmpDir, appName + "_" + ++i2 + ".ear");
        }
        if (i2 > 0) {
            appName = appName + "_" + i2;
        }
        appFile.deleteOnExit();
        Application app = new Application(appName, appFile);
        if (EjbBundleArchivist.isEjbBundle(moduleFile)) {
            app.addEjbJarFile(moduleFile);
        } else if (WebBundleArchivist.isWebBundle(moduleFile)) {
            app.addWebJarFile(moduleFile);
        } else if (ApplicationClientArchivist.isApplicationClientJar(moduleFile)) {
            app.addAppClientJarFile(moduleFile);
        } else {
            throw new IllegalArgumentException("Unsupported module type: " + moduleFile);
        }
        return app;
    }

    public void deploy(Application application, String serverName, DeploymentSession deploymentSession, File clientCodeFile) throws Exception {
        this.deploy(application.getName(), application.getApplicationArchivist().getApplicationFile(), serverName, deploymentSession, clientCodeFile);
    }

    public void deploy(String applicationName, File appArchiveFile, String serverName, DeploymentSession deploymentSession, File clientCodeFile) throws Exception {
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.deployapplicationfileonserversaveasclientjar", "Deploy the application in {0} on the server {1} saving the client jar as {2}", new Object[]{appArchiveFile, serverName, clientCodeFile}));
        Object[] msg = new Object[]{applicationName, serverName};
        String clientCode = null;
        Log.print(this, localStrings.getLocalString("enterprise.tools.deployment.main.deploytool.deploy_command", "Deploy {0} on {1}", msg));
        JarInstaller backend = this.getServerManager().getServerForName(serverName);
        DeploymentSession deploymentSessionToUse = null;
        deploymentSessionToUse = deploymentSession == null ? this.getServerManager().createDeploymentSession(serverName) : deploymentSession;
        FileInputStream fis = new FileInputStream(appArchiveFile);
        DataInputStream dis = new DataInputStream(fis);
        byte[] jarData = new byte[(int)appArchiveFile.length()];
        dis.readFully(jarData);
        dis.close();
        fis.close();
        clientCode = backend.deployApplication(jarData, applicationName, deploymentSessionToUse);
        Log.print(this, localStrings.getLocalString("enterprise.tools.deployment.main.clientcodeat", "client code at {0}", new Object[]{clientCode}));
        if (clientCode != null && clientCodeFile != null) {
            this.writeClientJarToFile(clientCode, clientCodeFile);
            deploymentSessionToUse.notification(new NotificationEvent(this, "Client Code Saved", this));
            deploymentSessionToUse.setStatusMessage(localStrings.getLocalString("enterprise.tools.deployment.main.clientcodefordeployedapplicationsavedtofile", "Client code for the deployed application {0} saved to {1}", new Object[]{applicationName, clientCodeFile}));
        }
    }

    private void writeClientJarToFile(String clientCode, File clientCodeFile) throws IOException {
        URL u2 = new URL(clientCode);
        HttpURLConnection http = (HttpURLConnection)u2.openConnection();
        int code = http.getResponseCode();
        if (code != 200) {
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.cannotdownloadURL", "Cannot download URL {0}", new Object[]{clientCode}));
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.status", "Status: {0}", new Object[]{new Integer(code)}));
            throw new IOException(localStrings.getLocalString("enterprise.tools.deployment.main.cannotdownloadURL", "Cannot download URL {0}", new Object[]{clientCode}));
        }
        BufferedInputStream is = new BufferedInputStream(http.getInputStream());
        FileOutputStream fos = new FileOutputStream(clientCodeFile);
        int len = 0;
        int contentLength = http.getContentLength();
        byte[] buf = new byte[contentLength + 1];
        while ((len = is.read(buf)) != -1) {
            fos.write(buf, 0, len);
        }
    }

    private void saveAsBytes(byte[] data, File file) throws IOException {
        if (data == null) {
            throw new IOException(localStrings.getLocalString("enterprise.tools.deployment.main.nulldataforclientcodefile", "null data for client code file"));
        }
        FileOutputStream fileStream = new FileOutputStream(file);
        fileStream.write(data, 0, data.length);
        fileStream.close();
    }

    public void setRuntimeDeploymentInfo(Application application, File runtimeDeploymentInfo) throws Exception {
        FileInputStream fis = new FileInputStream(runtimeDeploymentInfo);
        RuntimeDescriptorNode node = (RuntimeDescriptorNode)RuntimeDescriptorNode.readRuntimeDescriptorNodes(fis).elementAt(0);
        node.updateRuntimeInformation(application);
        this.getApplicationManager().saveApplication(application);
        Object[] msg = new Object[]{application.getName()};
        Log.print(this, localStrings.getLocalString("enterprise.tools.deployment.main.deploytool.setruntime_command", "Done setting runtime deployment information on {0} to: {1}", msg));
    }

    public void doGenerateSQL(String applicationFilename, String serverName, boolean overWrite) throws Exception {
        DBInfo dbInfo = this.getServerManager().getDBInfo(serverName);
        Application application = ApplicationArchivist.open(new File(applicationFilename));
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)itr.next();
            SQLGenerator.generateSQL(ebd, ebd.getCMPResourceReference(), overWrite, dbInfo);
        }
        application.getApplicationArchivist().save(application.getApplicationArchivist().getApplicationFile(), true);
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.donegeneratingSQL", "Done generating SQL"));
    }

    public ComponentPackager getComponentPackager() {
        if (this.componentPackager == null) {
            this.componentPackager = new ComponentPackager();
        }
        return this.componentPackager;
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    public StandAloneManager getStandAloneManager() {
        return this.standaloneManager;
    }

    public ServerManager getServerManager() {
        return this.serverManager;
    }

    public File getWorkingDirectory() {
        String home = System.getProperty("user.home");
        if (home == null) {
            home = "";
        }
        File tmp = new File(home, "tmp");
        tmp.mkdirs();
        return tmp;
    }

    private File getToolHomeDirectory() {
        String home = System.getProperty("user.home");
        if (home == null) {
            home = "";
        }
        return new File(home, HOME_DIR);
    }

    public String toString() {
        return "Deploy Tool";
    }

    public static void main(String[] args) {
        try {
            DeployTool tool = new DeployTool(false);
            Application app = tool.deployStandaloneModule(new File("/home/tcng/Test/ejb.jar"));
            System.err.println(app.toString());
            app = tool.deployStandaloneModule(new File("/home/tcng/Test/app.jar"));
            System.err.println(app.toString());
            app = tool.deployStandaloneModule(new File("/home/tcng/Test/web.war"));
            System.err.println(app.toString());
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

