/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class StandAloneManager
implements NotificationListener {
    public static final String STANDALONE_PROPERTY = "StandAloneProperty";
    public static final String STANDALONE_ADDED = "StandAloneAdded";
    public static final String STANDALONE_REMOVED = "StandAloneRemoved";
    public static final String LISTENER_ADDED = "ListenerAdded";
    public static final String ACTIVE_CHANGED = "ActiveChanged";
    private Vector standalones = new Vector();
    private Vector standaloneListeners = new Vector();
    private Descriptor activeStandAlone = null;
    private File preferencesDirectory = null;
    private File temp = null;
    public static final String CFG_CONNECTOR_FILE = "standalone";
    private String configFileName = "standalone";

    public StandAloneManager(File preferencesDirectory, File temp) {
        this.preferencesDirectory = preferencesDirectory;
        this.temp = temp;
    }

    public File getTemp() {
        return this.temp;
    }

    public Vector getStandAlones() {
        return (Vector)this.standalones.clone();
    }

    public Vector getStandAloneNames() {
        Vector<String> names = new Vector<String>();
        Enumeration e10 = this.standalones.elements();
        while (e10.hasMoreElements()) {
            names.addElement(((Descriptor)e10.nextElement()).getName());
        }
        return names;
    }

    public Descriptor getStandAloneWithJar(File jarFilename) {
        String absPath = jarFilename.getAbsolutePath();
        Enumeration e10 = this.standalones.elements();
        while (e10.hasMoreElements()) {
            String uri;
            Descriptor d10 = (Descriptor)e10.nextElement();
            if (!(d10 instanceof ConnectorDescriptor ? new File(uri = ((ConnectorDescriptor)d10).getArchivist().getArchiveUri()).getAbsolutePath().equals(absPath) : d10 instanceof Application && ((Application)d10).getApplicationArchivist().getApplicationFile().getAbsolutePath().equals(absPath))) continue;
            return d10;
        }
        return null;
    }

    public Descriptor getActiveStandAlone() {
        return this.activeStandAlone;
    }

    protected String getUniqueStandAloneName(String trialName) {
        return Descriptor.createUniqueNameAmongst(trialName, this.getStandAloneNames());
    }

    public Hashtable restoreFromUserHome() throws IOException {
        Hashtable<String, Throwable> badFiles = new Hashtable<String, Throwable>();
        File propsFile = new File(this.preferencesDirectory, this.getConfigFileName());
        if (propsFile.exists()) {
            FileInputStream fis = new FileInputStream(propsFile);
            Properties props = new Properties();
            props.load(fis);
            Enumeration<?> e10 = props.propertyNames();
            while (e10.hasMoreElements()) {
                String name = (String)e10.nextElement();
                String jarFilename = props.getProperty(name);
                try {
                    this.openStandAlone(new File(jarFilename));
                }
                catch (Throwable t2) {
                    badFiles.put(jarFilename, t2);
                }
            }
            fis.close();
        }
        return badFiles;
    }

    public void saveToUserHome() throws IOException {
        File propsFile = new File(this.preferencesDirectory, this.getConfigFileName());
        FileOutputStream fos = new FileOutputStream(propsFile);
        Properties props = new Properties();
        Enumeration e10 = this.standalones.elements();
        while (e10.hasMoreElements()) {
            Descriptor next = (Descriptor)e10.nextElement();
            String loc = null;
            if (next instanceof ConnectorDescriptor) {
                loc = ((ConnectorDescriptor)next).getArchivist().getArchiveUri();
            } else if (next instanceof Application) {
                loc = ((Application)next).getApplicationArchivist().getApplicationFile().toString();
            }
            if (loc != null) {
                ((Hashtable)props).put(next.getName(), loc);
                continue;
            }
            System.err.println("Unsupported Stand-Alone descriptor type:");
            System.err.println("  " + next.getClass().getName());
        }
        props.store(fos, "J2EE Stand-Alone Descriptors");
        fos.close();
    }

    public Descriptor openStandAlone(File name) throws Exception {
        if (ConnectorArchivist.isConnector(name)) {
            ConnectorDescriptor d10 = ConnectorArchivist.open(name);
            this.addStandAlone(d10);
            return d10;
        }
        if (ApplicationArchivist.isApplication(name)) {
            Application d11 = ApplicationArchivist.open(name);
            this.addStandAlone(d11);
            d11.doneOpening();
            return d11;
        }
        return null;
    }

    public void closeStandAlone(Descriptor desc) {
        this.standalones.removeElement(desc);
        this.setActiveStandAlone(null);
        this.notify(STANDALONE_REMOVED, STANDALONE_PROPERTY, desc);
    }

    public void saveStandAlone(Descriptor desc) throws IOException {
        if (desc instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd2 = (ConnectorDescriptor)desc;
            ConnectorArchivist ca2 = (ConnectorArchivist)cd2.getArchivist();
            ca2.save(new File(ca2.getArchiveUri()));
        }
    }

    public void saveStandAloneAs(Descriptor desc, File newFile) throws IOException {
        if (desc instanceof ConnectorDescriptor) {
            ConnectorDescriptor cd2 = (ConnectorDescriptor)desc;
            ConnectorArchivist ca2 = (ConnectorArchivist)cd2.getArchivist();
            ca2.save(newFile);
        }
    }

    public void addStandAlone(Descriptor desc) {
        String newName;
        String oldName = desc.getName();
        if (!oldName.equals(newName = this.getUniqueStandAloneName(oldName))) {
            desc.setName(newName);
        }
        this.standalones.addElement(desc);
        desc.addNotificationListener(this);
        this.notify(STANDALONE_ADDED, STANDALONE_PROPERTY, desc);
        this.setActiveStandAlone(desc);
    }

    public void setActiveStandAlone(Descriptor desc) {
        if (desc != this.activeStandAlone) {
            this.activeStandAlone = desc;
            if (desc != null) {
                this.notify(ACTIVE_CHANGED, STANDALONE_PROPERTY, desc);
            } else {
                this.notify(ACTIVE_CHANGED, null, null);
            }
        }
    }

    public boolean isStandAloneDescriptor(Descriptor desc) {
        Enumeration e10 = this.standalones.elements();
        while (e10.hasMoreElements()) {
            if (desc != e10.nextElement()) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(Descriptor desc) {
        if (desc instanceof ConnectorDescriptor) {
            return ((ConnectorDescriptor)desc).isDirty();
        }
        if (desc instanceof Application) {
            return ((Application)desc).isDirty();
        }
        return false;
    }

    public void addNotificationListener(NotificationListener nl) {
        this.standaloneListeners.addElement(nl);
        this.notify(LISTENER_ADDED, null, null);
    }

    public void removeNotificationListener(NotificationListener nl) {
        this.standaloneListeners.removeElement(nl);
    }

    public void notification(NotificationEvent ne) {
        this.notify(ne.getType(), NotificationEvent.OBJECT_THAT_CHANGED, ne.getObjectThatChanged());
    }

    public void notify(String type, String name, Object value) {
        NotificationEvent ne = name == null ? new NotificationEvent(this, type) : new NotificationEvent(this, type, name, value);
        Vector listenersClone = null;
        Vector vector = this.standaloneListeners;
        synchronized (vector) {
            listenersClone = (Vector)this.standaloneListeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(ne);
        }
    }

    protected String getConfigFileName() {
        return this.configFileName;
    }

    public String toString() {
        return "Stand-Alone Manager";
    }
}

