/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class BeanMethodCalculator {
    private static final String[] entityBeanHomeMethodsDisallowed = new String[]{"getEJBMetaData", "getHomeHandle"};
    private static final String[] entityBeanRemoteMethodsDisallowed = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"};
    private static final String[] entityBeanLocalHomeMethodsDisallowed = new String[0];
    private static final String[] entityBeanLocalInterfaceMethodsDisallowed = new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    private static final String[] sessionBeanMethodsDisallowed = new String[]{"*"};
    private static final String[] sessionLocalBeanMethodsDisallowed = new String[]{"*"};
    private static Map disallowedMethodsPerInterface;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;

    public static String getMethodIntfFor(String className, ClassLoader classLoader, EjbDescriptor ejbDescriptor) throws ClassNotFoundException {
        Class<?> beanClass;
        Class<?> intf = classLoader.loadClass(className);
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            Class<?> home = classLoader.loadClass(ejbDescriptor.getHomeClassName());
            Class<?> remote = classLoader.loadClass(ejbDescriptor.getRemoteClassName());
            if (intf.isAssignableFrom(home)) {
                return MethodDescriptor.EJB_HOME;
            }
            if (intf.isAssignableFrom(remote)) {
                return MethodDescriptor.EJB_REMOTE;
            }
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            Class<?> localHome = classLoader.loadClass(ejbDescriptor.getLocalHomeClassName());
            Class<?> local = classLoader.loadClass(ejbDescriptor.getLocalClassName());
            if (intf.isAssignableFrom(localHome)) {
                return MethodDescriptor.EJB_LOCALHOME;
            }
            if (intf.isAssignableFrom(local)) {
                return MethodDescriptor.EJB_LOCAL;
            }
        }
        if (ejbDescriptor instanceof EjbMessageBeanDescriptor && intf.isAssignableFrom(beanClass = classLoader.loadClass(ejbDescriptor.getEjbClassName()))) {
            return MethodDescriptor.EJB_BEAN;
        }
        return null;
    }

    public static Vector getMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector methods = new Vector();
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getHomeClassName()));
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getRemoteClassName()));
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalHomeClassName()));
            BeanMethodCalculator.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalClassName()));
        }
        return methods;
    }

    private static void addAllInterfaceMethodsIn(Collection methods, Class c10) {
        methods.addAll(Arrays.asList(c10.getMethods()));
    }

    public static Collection getTransactionalMethodsFor(EjbDescriptor ejbDescriptor, ClassLoader loader) throws ClassNotFoundException {
        Vector methods = new Vector();
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            Collection disallowedMethods;
            if (ejbDescriptor.getHomeClassName() != null) {
                disallowedMethods = BeanMethodCalculator.extractDisallowedMethodsFor(class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = BeanMethodCalculator.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject, sessionBeanMethodsDisallowed);
                methods.addAll(BeanMethodCalculator.getTransactionMethodsFor(loader, ejbDescriptor.getRemoteClassName(), disallowedMethods));
            }
            if (ejbDescriptor.getLocalHomeClassName() != null) {
                disallowedMethods = BeanMethodCalculator.extractDisallowedMethodsFor(class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = BeanMethodCalculator.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject, sessionLocalBeanMethodsDisallowed);
                methods.addAll(BeanMethodCalculator.getTransactionMethodsFor(loader, ejbDescriptor.getLocalClassName(), disallowedMethods));
            }
        } else {
            String localHomeIntf;
            String homeIntf = ejbDescriptor.getHomeClassName();
            if (homeIntf != null) {
                Class<?> home = loader.loadClass(homeIntf);
                methods.addAll(BeanMethodCalculator.getTransactionMethodsFor(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = BeanMethodCalculator.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome, home));
                String remoteIntf = ejbDescriptor.getRemoteClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                methods.addAll(BeanMethodCalculator.getTransactionMethodsFor(class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = BeanMethodCalculator.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject, remote));
            }
            if ((localHomeIntf = ejbDescriptor.getLocalHomeClassName()) != null) {
                Class<?> home = loader.loadClass(localHomeIntf);
                methods.addAll(BeanMethodCalculator.getTransactionMethodsFor(class$javax$ejb$EJBLocalHome == null ? (class$javax$ejb$EJBLocalHome = BeanMethodCalculator.class$("javax.ejb.EJBLocalHome")) : class$javax$ejb$EJBLocalHome, home));
                String remoteIntf = ejbDescriptor.getLocalClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                methods.addAll(BeanMethodCalculator.getTransactionMethodsFor(class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = BeanMethodCalculator.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject, remote));
            }
        }
        return methods;
    }

    private static Collection getTransactionMethodsFor(ClassLoader loader, String className, Collection disallowedMethods) throws ClassNotFoundException {
        Class<?> clazz = loader.loadClass(className);
        return BeanMethodCalculator.getTransactionMethodsFor(clazz, disallowedMethods);
    }

    private static Collection getTransactionMethodsFor(Class interfaceImpl, Collection disallowedMethods) {
        Vector<Method> v2 = new Vector<Method>(Arrays.asList(interfaceImpl.getMethods()));
        v2.removeAll(disallowedMethods);
        return v2;
    }

    private static Collection getTransactionMethodsFor(Class interfaceType, Class interfaceImpl) {
        Collection disallowedTransactionMethods = BeanMethodCalculator.getDisallowedTransactionMethodsFor(interfaceType);
        return BeanMethodCalculator.getTransactionMethodsFor(interfaceImpl, disallowedTransactionMethods);
    }

    private static Collection getDisallowedTransactionMethodsFor(Class interfaceType) {
        return BeanMethodCalculator.extractDisallowedMethodsFor(interfaceType, BeanMethodCalculator.getDisallowedMethodsNamesFor(interfaceType));
    }

    private static Collection extractDisallowedMethodsFor(Class interfaceType, String[] methodNames) {
        Vector<Method> v2 = new Vector<Method>();
        if (methodNames.length == 0) {
            return v2;
        }
        Method[] methods = interfaceType.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            if (methodNames[0].equals("*")) {
                v2.addElement(methods[i2]);
            } else if (Arrays.binarySearch(methodNames, methods[i2].getName()) >= 0) {
                v2.addElement(methods[i2]);
            }
            ++i2;
        }
        return v2;
    }

    private static String[] getDisallowedMethodsNamesFor(Class interfaceType) {
        return (String[])BeanMethodCalculator.getDisallowedMethodsNames().get(interfaceType);
    }

    protected static Map getDisallowedMethodsNames() {
        if (disallowedMethodsPerInterface == null) {
            disallowedMethodsPerInterface = new Hashtable();
            disallowedMethodsPerInterface.put(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = BeanMethodCalculator.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome, entityBeanHomeMethodsDisallowed);
            disallowedMethodsPerInterface.put(class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = BeanMethodCalculator.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject, entityBeanRemoteMethodsDisallowed);
            disallowedMethodsPerInterface.put(class$javax$ejb$EJBLocalHome == null ? (class$javax$ejb$EJBLocalHome = BeanMethodCalculator.class$("javax.ejb.EJBLocalHome")) : class$javax$ejb$EJBLocalHome, entityBeanLocalHomeMethodsDisallowed);
            disallowedMethodsPerInterface.put(class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = BeanMethodCalculator.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject, entityBeanLocalInterfaceMethodsDisallowed);
        }
        return disallowedMethodsPerInterface;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

