/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.SimpleFilenameFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileUtil {
    private static final boolean debug = false;
    private static final String JAR_FILE_NAME = "j2ee.jar";
    private static final String HOME_DIR_PROP = "com.sun.enterprise.home";
    private static final String DEFAULT_HOME_DIR = System.getProperty("user.dir");
    public static final char JAR_SEPARATOR_CHAR = '/';
    private static final long JAR_ENTRY_UNKNOWN_VALUE = -1L;
    private static final int BYTE_READ_ERROR = -1;
    private static String basedir = null;

    public static String getAbsolutePath(String relativePath) {
        if (FileUtil.isAbsolute(relativePath)) {
            return relativePath;
        }
        String rpath = relativePath.replace('/', File.separatorChar);
        if (basedir == null) {
            FileUtil.setBaseDir();
        }
        String path = basedir + File.separator + relativePath;
        return new File(path).getAbsolutePath();
    }

    private static void setBaseDir() {
        basedir = System.getProperty(HOME_DIR_PROP);
        if (basedir != null) {
            return;
        }
        basedir = DEFAULT_HOME_DIR;
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            if (!filename.endsWith(JAR_FILE_NAME)) continue;
            try {
                String parent = new File(filename).getAbsoluteFile().getParentFile().getParent();
                if (parent != null) {
                    basedir = parent;
                }
                return;
            }
            catch (NullPointerException ex2) {
                return;
            }
        }
    }

    private static boolean isAbsolute(String fpath) {
        return new File(fpath).isAbsolute();
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        FileUtil.recursiveGetFilesUnder(directory, directory, filenameFilter, allFiles, false);
        return allFiles;
    }

    public static Set getAllFilesAndDirectoriesUnder(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        FileUtil.recursiveGetFilesUnder(directory, directory, null, allFiles, true);
        return allFiles;
    }

    private static void recursiveGetFilesUnder(File relativizingRoot, File directory, FilenameFilter filenameFilter, Set set, boolean returnDirectories) {
        File[] files = directory.listFiles(filenameFilter);
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2].isDirectory()) {
                FileUtil.recursiveGetFilesUnder(relativizingRoot, files[i2], filenameFilter, set, returnDirectories);
                if (returnDirectories) {
                    set.add(FileUtil.relativize(relativizingRoot, files[i2]));
                }
            } else {
                set.add(FileUtil.relativize(relativizingRoot, files[i2]));
            }
            ++i2;
        }
    }

    public static File relativize(File parent, File child) {
        String baseDir = parent.getAbsolutePath();
        String baseDirAndChild = child.getAbsolutePath();
        String relative = baseDirAndChild.substring(baseDir.length(), baseDirAndChild.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return new File(relative);
    }

    public static String classNameFromEntryName(String entryName) {
        String className = entryName;
        if (entryName.endsWith(".class")) {
            int dotClassIndex = entryName.indexOf(".class");
            className = entryName.substring(0, dotClassIndex);
            className = className.replace('/', '.');
        }
        return className;
    }

    public static String classNameFromFile(File file) {
        String className = file.toString();
        if (className.endsWith(".class")) {
            String contentFileStr = className.replace(File.separatorChar, '.');
            int cutOffPoint = contentFileStr.lastIndexOf(".class");
            className = contentFileStr.substring(0, cutOffPoint);
        }
        return className;
    }

    public static File getTempDirectory() {
        String temp = System.getProperty("java.io.tmpdir");
        String home = System.getProperty("user.name");
        if (home == null) {
            home = "";
        }
        File tmp = null;
        tmp = temp == null ? new File(home, "tmp") : new File(temp, "j2ee-ri-" + home);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        return tmp;
    }

    public static String[] parseFileList(String files) {
        Vector<String> fileNames = new Vector<String>();
        boolean checkDriveLetter = !File.pathSeparator.equals(":");
        StringTokenizer st = new StringTokenizer(files, ":");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (checkDriveLetter && name.length() == 1 && st.hasMoreTokens()) {
                name = name + ":" + st.nextToken();
            }
            fileNames.addElement(name);
        }
        int size = fileNames.size();
        String[] result = new String[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = (String)fileNames.elementAt(i2);
            ++i2;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarEntriesEqual(File file1, String entry1Name, File file2, String entry2Name) throws IOException {
        JarFile jarFile2;
        boolean identical;
        block7: {
            identical = false;
            JarFile jarFile1 = null;
            jarFile2 = null;
            try {
                jarFile1 = new JarFile(file1);
                jarFile2 = new JarFile(file2);
                String jarEntry1Name = entry1Name.replace(File.separatorChar, '/');
                String jarEntry2Name = entry2Name.replace(File.separatorChar, '/');
                JarEntry entry1 = jarFile1.getJarEntry(jarEntry1Name);
                JarEntry entry2 = jarFile2.getJarEntry(jarEntry2Name);
                if (entry1 != null && entry2 != null) {
                    identical = FileUtil.jarEntriesEqual(jarFile1, entry1, jarFile2, entry2);
                }
                Object var12_12 = null;
                if (jarFile1 == null) break block7;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (jarFile1 != null) {
                    jarFile1.close();
                }
                if (jarFile2 == null) throw throwable;
                jarFile2.close();
                throw throwable;
            }
            jarFile1.close();
        }
        if (jarFile2 == null) return identical;
        jarFile2.close();
        return identical;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarEntriesEqual(JarFile jarFile1, JarEntry entry1, JarFile jarFile2, JarEntry entry2) throws IOException {
        InputStream inputStream2;
        boolean identical;
        block12: {
            identical = false;
            int entry1Size = (int)entry1.getSize();
            int entry2Size = (int)entry2.getSize();
            if ((long)entry1Size != -1L && (long)entry2Size != -1L) {
                if (entry1Size != entry2Size) return identical;
            }
            if (entry1Size == 0) {
                return true;
            }
            InputStream inputStream1 = null;
            inputStream2 = null;
            try {
                inputStream1 = jarFile1.getInputStream(entry1);
                inputStream2 = jarFile2.getInputStream(entry2);
                byte[] file1Bytes = new byte[entry1Size];
                byte[] file2Bytes = new byte[entry2Size];
                int read = 0;
                int numBytesRead1 = 0;
                while ((read = inputStream1.read(file1Bytes, numBytesRead1, entry1Size - numBytesRead1)) != -1 & (numBytesRead1 += read) != entry1Size) {
                }
                int numBytesRead2 = 0;
                while ((read = inputStream2.read(file2Bytes, numBytesRead2, entry2Size - numBytesRead2)) != -1 & (numBytesRead2 += read) != entry2Size) {
                }
                if (numBytesRead1 == -1) throw new IOException("Byte read error " + numBytesRead1 + " " + numBytesRead2);
                if (numBytesRead2 == -1) {
                    throw new IOException("Byte read error " + numBytesRead1 + " " + numBytesRead2);
                }
                if (Arrays.equals(file1Bytes, file2Bytes)) {
                    identical = true;
                }
                Object var15_15 = null;
                if (inputStream1 == null) break block12;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (inputStream1 != null) {
                    inputStream1.close();
                }
                if (inputStream2 == null) throw throwable;
                inputStream2.close();
                throw throwable;
            }
            inputStream1.close();
        }
        if (inputStream2 == null) return identical;
        inputStream2.close();
        return identical;
    }

    public static void main(String[] args) {
        File file1 = new File(args[0]);
        File file2 = new File(args[1]);
        String entry = args[2];
        try {
            FileUtil.jarEntriesEqual(file1, entry, file2, entry);
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    public static String getClassNameFromFile(File f2) throws IOException, ClassFormatError {
        FileClassLoader fcl = new FileClassLoader(f2.toString());
        return fcl.getClassName(f2);
    }

    public static void countWords() {
        try {
            String[] filter = new String[]{".java"};
            File f2 = new File("/home/dannyc/workspace/j2ee/src/share/com/sun/enterprise/deployment");
            Set s2 = FileUtil.getAllFilesUnder(f2, new SimpleFilenameFilter(filter));
            int i2 = 0;
            System.out.println(s2);
            Iterator itr = s2.iterator();
            while (itr.hasNext()) {
                File next = (File)itr.next();
                File absoluteFile = new File(f2, next.toString());
                System.out.println();
                System.out.println(absoluteFile);
                FileReader fr = new FileReader(absoluteFile);
                int nextChar = 0;
                boolean start = false;
                while (nextChar != -1) {
                    if (nextChar == 34) {
                        boolean bl2 = start = !start;
                        if (!start) {
                            System.out.println("\"");
                            ++i2;
                        } else {
                            System.out.print(next + " \t word = ");
                        }
                    }
                    if (start) {
                        System.out.print((char)nextChar);
                    }
                    nextChar = fr.read();
                }
            }
            System.out.println(i2 + " words in " + s2.size() + " files.");
        }
        catch (Throwable ioe) {
            ioe.printStackTrace();
        }
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        File parent = new File(destFile.getParent());
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            out.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        in.close();
        out.close();
    }
}

