/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;

public class J2EECleanup {
    private static String separator;
    private static String j2eeHome;
    private String hostname;
    private static final String FORCECLEAN = "-f";
    private String[] stopdirArray = new String[]{"logs", "repository", "public_html", "adapters"};
    private static LocalStringManagerImpl localStrings;
    static /* synthetic */ Class class$com$sun$enterprise$util$J2EECleanup;

    public J2EECleanup() {
        j2eeHome = System.getProperty("com.sun.enterprise.home");
        separator = System.getProperty("file.separator");
        this.hostname = Utility.getLocalHost();
    }

    public static void main(String[] args) {
        J2EECleanup mycleanUp;
        String srcFile;
        block5: {
            srcFile = "index.html";
            mycleanUp = new J2EECleanup();
            if (args.length == 0) {
                System.out.println(localStrings.getLocalString("j2eecleanup.msg001", "This will delete all deployed applications and clean all log files"));
                System.out.println(localStrings.getLocalString("j2eecleanup.msg002", "Do you want to proceed (y/n)"));
                try {
                    char ch2 = (char)System.in.read();
                    if (ch2 != 'y') {
                        System.out.println(localStrings.getLocalString("j2eecleanup.msg003", "The cleanup script was not run"));
                        return;
                    }
                    break block5;
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                    return;
                }
            }
            if (!args[0].trim().equals(FORCECLEAN)) {
                mycleanUp.usage();
                System.exit(0);
            }
        }
        String fromDir = j2eeHome + separator + "config" + separator + "public_html";
        String destDir = j2eeHome + separator + "public_html";
        mycleanUp.cleanUp();
        mycleanUp.copyFile(srcFile, fromDir, destDir);
        mycleanUp.copyFile("sun-j2ee-ri_1_3.dtd", fromDir, destDir);
        System.out.println("");
        System.out.println(localStrings.getLocalString("j2eecleanup.msg004", "Cleanup completed.  Please restart j2ee server."));
    }

    private void cleanUp() {
        String logsDir = j2eeHome + separator + "logs" + separator + this.hostname;
        String repositoryDir = j2eeHome + separator + "repository" + separator + this.hostname;
        String connectoradaptersDir = j2eeHome + separator + "connector" + separator + "adapters";
        String publichtmlDir = j2eeHome + separator + "public_html";
        System.out.println(localStrings.getLocalString("j2eecleanup.msg005", "Cleaning directory {0} ...", new Object[]{logsDir}));
        this.cleanOneDirectory(logsDir);
        System.out.println(localStrings.getLocalString("j2eecleanup.msg005", "Cleaning directory {0} ...", new Object[]{repositoryDir}));
        this.cleanOneDirectory(repositoryDir);
        System.out.println(localStrings.getLocalString("j2eecleanup.msg005", "Cleaning directory {0} ...", new Object[]{connectoradaptersDir}));
        this.cleanOneDirectory(connectoradaptersDir);
        this.cleanupResourceAdapterEntries();
        System.out.println(localStrings.getLocalString("j2eecleanup.msg005", "Cleaning directory {0} ...", new Object[]{publichtmlDir}));
        this.cleanOneDirectory(publichtmlDir);
        String tempDir = FileUtil.getTempDirectory().getAbsolutePath();
        System.out.println(localStrings.getLocalString("j2eecleanup.msg005", "Cleaning directory {0} ...", new Object[]{tempDir}));
        this.cleanOneDirectory(tempDir);
    }

    private void cleanupResourceAdapterEntries() {
        try {
            J2EEResourceFactory resFactory = ServerConfiguration.getJ2EEResourceFactory();
            J2EEResourceCollection resourceInfo = resFactory.loadDefaultResourceCollection();
            Set res = resourceInfo.getResourcesByType(7);
            Iterator iter = res.iterator();
            while (iter.hasNext()) {
                J2EEResource ra = (J2EEResource)iter.next();
                resourceInfo.removeResource(ra);
            }
            res = resourceInfo.getResourcesByType(6);
            iter = res.iterator();
            while (iter.hasNext()) {
                J2EEResource cr2 = (J2EEResource)iter.next();
                resourceInfo.removeResource(cr2);
            }
            resFactory.storeDefaultResourceCollection(resourceInfo);
        }
        catch (J2EEResourceException re) {
            System.out.println(localStrings.getLocalString("j2eecleanup.msg006", "Error in removing resource adapters"));
        }
    }

    private void cleanOneDirectory(String cleanthisDir) {
        File newcleanDir = null;
        int numFiles = 0;
        String j2eecleanDir = null;
        String newj2eecleanDir = null;
        boolean checkStopdir = false;
        File cleanDir = new File(cleanthisDir);
        if (!cleanDir.exists()) {
            return;
        }
        File[] listofFiles = cleanDir.listFiles();
        numFiles = listofFiles != null ? listofFiles.length : 0;
        if (numFiles != 0) {
            int countFiles = 0;
            while (countFiles < numFiles) {
                if (listofFiles[countFiles].isFile()) {
                    listofFiles[countFiles].delete();
                } else {
                    j2eecleanDir = cleanDir + separator + listofFiles[countFiles].getName();
                    newcleanDir = new File(j2eecleanDir);
                    newj2eecleanDir = newcleanDir.getAbsolutePath();
                    this.cleanOneDirectory(newj2eecleanDir);
                }
                ++countFiles;
            }
        }
        if (!(checkStopdir = this.isStopDir(cleanDir))) {
            cleanDir.delete();
        }
    }

    private void copyFile(String srcFile, String fromDir, String destDir) {
        String oneLine = null;
        BufferedReader reader = null;
        PrintWriter writer = null;
        String tobeCopied = new String(fromDir + separator + srcFile);
        File sourceFile = new File(tobeCopied);
        if (!sourceFile.exists()) {
            return;
        }
        try {
            reader = new BufferedReader(new FileReader(sourceFile));
            writer = new PrintWriter(new FileWriter(destDir + separator + srcFile));
            while ((oneLine = reader.readLine()) != null) {
                writer.println(oneLine);
            }
            reader.close();
            writer.close();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    private void cleanOneFile(String srcFile) {
        File cleanFile = new File(srcFile);
        if (cleanFile.exists()) {
            cleanFile.delete();
        }
    }

    private boolean isStopDir(File oneDir) {
        int stoparrayLength = this.stopdirArray.length;
        int counter = 0;
        while (counter < stoparrayLength) {
            String dirName = oneDir.getName();
            if (dirName.equals(this.stopdirArray[counter]) || dirName.equals("classes") && oneDir.getParentFile().getName().equals("connector")) {
                return true;
            }
            ++counter;
        }
        return false;
    }

    public void usage() {
        System.err.println("\n" + localStrings.getLocalString(this.getClass().getName() + ".usageLine", "     usage: -f Forceclean"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$J2EECleanup == null ? (class$com$sun$enterprise$util$J2EECleanup = J2EECleanup.class$("com.sun.enterprise.util.J2EECleanup")) : class$com$sun$enterprise$util$J2EECleanup);
    }
}

