/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Properties;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;

public class ORBManager {
    private static final boolean debug = false;
    private static final String poaOrbClass = "com.sun.enterprise.iiop.POAEJBORB";
    private static final String poaOrbSingletonClass = "com.sun.corba.ee.internal.corba.ORBSingleton";
    private static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    private static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    private static final String J2EE_INITIALIZER = "com.sun.enterprise.iiop.J2EEInitializer";
    private static final String PI_ORB_INITIALIZER_CLASS_PREFIX = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private static final String DEFAULT_ORB_INIT_HOST = "localhost";
    private static final String DEFAULT_ORB_INIT_PORT = "1050";
    private static final String CONFIG_DIR = "config";
    private static final String J2EE_ORB_CONFIG_FILE_NAME = "orb.properties";
    private static final String J2EE_ORB_CONFIG_PORT_NAME = "port";
    private static final String J2EE_ORB_CONFIG_HOST_NAME = "host";
    private static final String NATIVE_LIB_DIR = "nativelib";
    private static ORB orb = null;
    private static int orbInitialPort = -1;
    private static boolean librariesLoaded = false;

    public static synchronized void init(String[] args, Properties props) {
        if (orb != null) {
            return;
        }
        orb = ORBManager.createORB(args, props);
    }

    public static ORB getORB() {
        if (orb == null) {
            ORBManager.init(null, null);
        }
        return orb;
    }

    public static int getORBInitialPort() {
        if (orbInitialPort == -1) {
            ORBManager.checkORBInitialPort(new Properties());
        }
        return orbInitialPort;
    }

    private static synchronized ORB createORB(String[] args, Properties props) {
        ORB neworb = null;
        Properties orbInitProperties = new Properties();
        System.setProperty("org.omg.CORBA.ORBClass", poaOrbClass);
        System.setProperty("org.omg.CORBA.ORBSingletonClass", poaOrbSingletonClass);
        System.setProperty("com.sun.CORBA.connection.ORBSocketFactoryClass", "com.sun.enterprise.iiop.IIOPSSLSocketFactory");
        System.setProperty("javax.rmi.CORBA.UtilClass", "com.sun.corba.ee.internal.POA.ShutdownUtilDelegate");
        try {
            if (props == null) {
                ((Hashtable)orbInitProperties).put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
            } else {
                ((Hashtable)orbInitProperties).putAll(props);
            }
            ((Hashtable)orbInitProperties).put("org.omg.PortableInterceptor.ORBInitializerClass.com.sun.enterprise.iiop.J2EEInitializer", "");
            ((Hashtable)orbInitProperties).put("com.sun.CORBA.ORBAllowLocalOptimization", "true");
            ((Hashtable)orbInitProperties).put("org.omg.CORBA.ORBClass", poaOrbClass);
            ((Hashtable)orbInitProperties).put("org.omg.CORBA.ORBSingletonClass", poaOrbSingletonClass);
            String initialPort = ORBManager.checkORBInitialPort(orbInitProperties);
            String orbInitialHost = ORBManager.checkORBInitialHost(orbInitProperties);
            args = ORBManager.addORBInitRef(args, orbInitialHost, initialPort);
            neworb = ORB.init((String[])args, (Properties)orbInitProperties);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
        }
        return neworb;
    }

    private static String checkORBInitialHost(Properties props) {
        String orbInitialHost = System.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        if (orbInitialHost == null) {
            orbInitialHost = props.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        }
        if (orbInitialHost == null) {
            try {
                Properties config = Utility.getPropertiesFromFile(J2EE_ORB_CONFIG_FILE_NAME);
                orbInitialHost = config.getProperty(J2EE_ORB_CONFIG_HOST_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (orbInitialHost == null) {
            orbInitialHost = DEFAULT_ORB_INIT_HOST;
        }
        System.setProperty(OMG_ORB_INIT_HOST_PROPERTY, orbInitialHost);
        return orbInitialHost;
    }

    private static String checkORBInitialPort(Properties props) {
        String initialPort = System.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        if (initialPort == null) {
            initialPort = props.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        }
        if (initialPort == null) {
            try {
                Properties config = Utility.getPropertiesFromFile(J2EE_ORB_CONFIG_FILE_NAME);
                initialPort = config.getProperty(J2EE_ORB_CONFIG_PORT_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (initialPort == null) {
            initialPort = DEFAULT_ORB_INIT_PORT;
        }
        System.setProperty(OMG_ORB_INIT_PORT_PROPERTY, initialPort);
        orbInitialPort = new Integer(initialPort);
        return initialPort;
    }

    private static String[] addORBInitRef(String[] args, String orbInitialHost, String initialPort) {
        String[] newArgs;
        int i2 = 0;
        if (args == null) {
            newArgs = new String[2];
        } else {
            newArgs = new String[args.length + 2];
            while (i2 < args.length) {
                newArgs[i2] = args[i2];
                ++i2;
            }
        }
        newArgs[i2++] = "-ORBInitRef";
        newArgs[i2++] = "NameService=corbaloc:iiop:1.2@" + orbInitialHost + ":" + initialPort + "/NameService";
        return newArgs;
    }

    public static Tie exportObject(Remote remote) throws RemoteException {
        PortableRemoteObject.exportObject((Remote)remote);
        Tie servantsTie = Util.getTie((Remote)remote);
        servantsTie.orb(ORBManager.getORB());
        return servantsTie;
    }

    private static synchronized void loadSharedLibraries() {
        ORBManager.checkDelegateProps();
        String path = FileUtil.getAbsolutePath(NATIVE_LIB_DIR);
        String[] files = new File(path).list();
        if (files == null) {
            return;
        }
        int i2 = 0;
        while (i2 < files.length) {
            try {
                System.load(path + File.separator + files[i2]);
            }
            catch (UnsatisfiedLinkError err) {
                System.err.println("Cannot load library " + files[i2]);
            }
            ++i2;
        }
    }

    private static void checkDelegateProps() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String utilDelegate = System.getProperty("javax.rmi.CORBA.UtilClass");
                if (utilDelegate == null || utilDelegate.equals("")) {
                    System.setProperty("javax.rmi.CORBA.StubClass", "com.sun.corba.ee.internal.javax.rmi.CORBA.StubDelegateImpl");
                    System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "com.sun.corba.ee.internal.javax.rmi.PortableRemoteObject");
                }
                return null;
            }
        });
    }
}

