/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.Pool;
import com.sun.enterprise.util.Semaphore;
import com.sun.enterprise.util.SemaphoreImpl;

public abstract class PoolBase
implements Pool {
    private final Semaphore available_;
    private int numItems_;

    protected PoolBase(int numItems) {
        this.numItems_ = numItems;
        this.available_ = new SemaphoreImpl(numItems);
    }

    public void initialize() throws Exception {
        this.doInitializeItems(this.numItems_);
    }

    public Object getItem() throws InterruptedException {
        this.available_.acquire();
        return this.doGet();
    }

    public void returnItem(Object o2) {
        if (this.doReturn(o2)) {
            this.available_.release();
        }
    }

    protected abstract Object doGet();

    protected abstract boolean doReturn(Object var1);

    protected abstract void doInitializeItems(int var1) throws Exception;
}

