/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbExternalEntityDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.tools.packager.ComponentPackager;
import com.sun.enterprise.util.BeanMethodCalculator;
import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.NiceProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.crimson.tree.XmlDocument;

public class PropsToXmlConverter {
    private Hashtable ejbReferencesToConvert = new Hashtable();
    private static final String MESSAGE_SELECTOR_PROP = "message-selector";
    private static final String MSG_BEAN_DEST_TYPE_PROP = "dest-type";
    private static final String QUEUE_DEST_TYPE = "Queue";
    private static final String TOPIC_DEST_TYPE = "Topic";
    private static final String DURABLE_SUBSCRIPTION_NAME_PROP = "subscription-name";
    private static final String JMS_CLIENT_ID = "jms-client-id";
    private static final String MDB_CONNECTION_FACTORY = "mdb-connection-factory";
    private static final String JMS_ACKNOWLEDGE_MODE_PROP = "acknowledge-mode";
    private static final String AUTO_ACKNOWLEDGE_MODE = "AUTO_ACKNOWLEDGE";
    private static final String DUPS_OK_MODE = "DUPS_OK";
    static /* synthetic */ Class class$javax$jms$Message;

    public static void writeXmlToFiles(Application application, String xmlFilename, String optionalEjbBundleFilename, String optionalRuntimeFilename) throws IOException {
        XmlDocument document = null;
        Object out = null;
        File xmlFile = null;
        xmlFile = "".equals(optionalEjbBundleFilename) ? new File(ComponentPackager.getEjbBundleFilename(xmlFilename)) : new File(optionalEjbBundleFilename);
        EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)application.getEjbBundleDescriptors().iterator().next();
        document = EjbBundleNode.getDocument(ejbBundleDescriptor);
        XMLUtils.writeDocumentToFile(document, xmlFile);
        document = RuntimeDescriptorNode.getDocument(application);
        xmlFile = "".equals(optionalRuntimeFilename) ? new File(ComponentPackager.getRuntimeDescriptorFilename(xmlFilename)) : new File(optionalRuntimeFilename);
        XMLUtils.writeDocumentToFile(document, xmlFile);
        document = ApplicationNode.getDocument(application);
        xmlFile = new File(xmlFilename);
        XMLUtils.writeDocumentToFile(document, xmlFile);
    }

    private void convertEnvironmentProperties(String prefix, Properties p2, EjbDescriptor ejbDescriptor) throws IOException {
        int envCount = Integer.parseInt(p2.getProperty(prefix + "#envProps"));
        HashSet environmentProperties = new HashSet();
        int j2 = 0;
        while (j2 < envCount) {
            String envPrefix = prefix + "envProps" + j2 + ".";
            String propName = p2.getProperty(envPrefix + "name");
            String propType = p2.getProperty(envPrefix + "type");
            String envValue = p2.getProperty(envPrefix + "value");
            if (propName == null) {
                throw new IOException("Bad envProps count or envProps key");
            }
            String isRoleRefKey = envPrefix + "isRoleRef";
            String isEjbRefKey = envPrefix + "isEjbReference";
            String isJmsDestRefKey = envPrefix + "isJmsDestinationReference";
            String isResourceEnvRefKey = envPrefix + "isResourceEnvReference";
            if (p2.getProperty(isRoleRefKey) != null) {
                System.out.println(propName + " is a role ref ");
                RoleReference rr = new RoleReference(propName, "");
                rr.setValue(envValue);
                ejbDescriptor.addRoleReference(rr);
            } else if (p2.getProperty(isEjbRefKey) != null) {
                String ejbReferenceKeyPrefix = envPrefix + "ejbReference.";
                this.ejbReferencesToConvert.put(envPrefix, ejbDescriptor);
            } else if (p2.getProperty(isJmsDestRefKey) != null || p2.getProperty(isResourceEnvRefKey) != null) {
                if (p2.getProperty(isJmsDestRefKey) != null) {
                    System.out.print("Warning : isJmsDestinationReference prop has been deprecated. ");
                    System.out.println("Please use isResourceEnvReference instead.");
                }
                JmsDestinationReferenceDescriptor jmsDestRefDesc = new JmsDestinationReferenceDescriptor(propName, "", propType);
                jmsDestRefDesc.setJndiName(envValue);
                ejbDescriptor.addJmsDestinationReferenceDescriptor(jmsDestRefDesc);
            } else {
                EnvironmentProperty environmentProperty = new EnvironmentProperty(propName, envValue, "");
                if (propType != null) {
                    environmentProperty.setType(propType);
                }
                ejbDescriptor.addEnvironmentProperty(environmentProperty);
            }
            ++j2;
        }
    }

    private void convertEjbReference(EjbBundleDescriptor ejbBundleDescriptor, Properties p2, String environmentPropertyPrefix, EjbDescriptor ejbDescriptor) {
        System.out.println("");
        String ejbRefPrefix = environmentPropertyPrefix + "ejbReference.";
        String envPropertyKey = p2.getProperty(environmentPropertyPrefix + "name");
        String jndiName = p2.getProperty(environmentPropertyPrefix + "value");
        boolean isEjbLinked = false;
        if ("true".equals(p2.getProperty(ejbRefPrefix + "isEjbLink"))) {
            isEjbLinked = true;
        }
        String ejbReferenceType = p2.getProperty(ejbRefPrefix + "type");
        String homeClassName = p2.getProperty(ejbRefPrefix + "homeInterface");
        String remoteClassName = p2.getProperty(ejbRefPrefix + "remoteInterface");
        boolean isLocal = false;
        if (p2.getProperty(ejbRefPrefix + "isLocal") != null) {
            isLocal = new Boolean(p2.getProperty(ejbRefPrefix + "isLocal"));
        }
        if (isEjbLinked) {
            String ejbLinkName = p2.getProperty(ejbRefPrefix + "ejbLink");
            EjbDescriptor beanBeingReferredTo = null;
            if (ejbBundleDescriptor.hasEjbByName(ejbLinkName)) {
                beanBeingReferredTo = ejbBundleDescriptor.getEjbByName(ejbLinkName);
            }
            if (beanBeingReferredTo == null) {
                EjbExternalDescriptor external = new EjbExternalDescriptor();
                external.setName("name ??");
                if (isLocal) {
                    external.setLocalHomeClassName(homeClassName);
                    external.setLocalClassName(remoteClassName);
                } else {
                    external.setHomeClassName(homeClassName);
                    external.setRemoteClassName(remoteClassName);
                }
                external.setType(ejbReferenceType);
                external.setLinkName(ejbLinkName);
                EjbReferenceDescriptor ejbReference = new EjbReferenceDescriptor(envPropertyKey, "", external, isLocal);
                System.out.println("Adding internal UNRESOLVED reference " + ejbReference);
                ejbDescriptor.addEjbReferenceDescriptor(ejbReference);
            } else {
                EjbReferenceDescriptor ejbReference = new EjbReferenceDescriptor(envPropertyKey, "", beanBeingReferredTo, isLocal);
                System.out.println("Adding internal RESOLVED reference " + ejbReference);
                ejbDescriptor.addEjbReferenceDescriptor(ejbReference);
            }
        } else {
            if (isLocal) {
                throw new RuntimeException("ejbLink must be provided in local reference " + ejbRefPrefix);
            }
            EjbExternalDescriptor external = new EjbExternalDescriptor();
            external.setName("name ??");
            external.setHomeClassName(homeClassName);
            external.setRemoteClassName(remoteClassName);
            external.setType(ejbReferenceType);
            external.setJndiName(jndiName);
            EjbReferenceDescriptor ejbReference = new EjbReferenceDescriptor(envPropertyKey, "", external, isLocal);
            System.out.println("Adding external reference " + ejbReference);
            ejbDescriptor.addEjbReferenceDescriptor(ejbReference);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convertToXml(File propsFile, String codebase, String xmlFilename, String optionalEjbBundleFilename, String optionalRuntimeFilename) throws Throwable {
        EjbDescriptor ejbDescriptor;
        String archiveUri;
        System.out.println("Convert : " + propsFile + " to XML");
        FileInputStream fis = new FileInputStream(propsFile);
        NiceProperties p2 = new NiceProperties();
        p2.load(fis);
        FileClassLoader fcl = new FileClassLoader(codebase);
        String applicationName = ((Properties)p2).getProperty("application.name");
        Application application = new Application(applicationName, new File(applicationName + ".jar"));
        application.getApplicationArchivist().setClassLoader(fcl);
        EjbBundleDescriptor ejbBundleDescriptor = new EjbBundleDescriptor();
        application.addEjbBundleDescriptor(ejbBundleDescriptor);
        String ejbClientJarUri = ((Properties)p2).getProperty("ejbclientjaruri");
        if (ejbClientJarUri != null) {
            ejbBundleDescriptor.setEjbClientJarUri(ejbClientJarUri);
        }
        if ((archiveUri = ((Properties)p2).getProperty("archiveuri")) != null) {
            ejbBundleDescriptor.getArchivist().setArchiveUri(archiveUri);
        } else {
            ejbBundleDescriptor.getArchivist().setArchiveUri("");
        }
        if (((Properties)p2).getProperty("rolecount") != null) {
            System.out.println("This ejb jar has assembly descriptor roles");
            RoleMapper rm = application.getRoleMapper();
            int roleCount = Integer.parseInt(((Properties)p2).getProperty("rolecount"));
            int j2 = 0;
            while (j2 < roleCount) {
                String lookupKey = "role" + j2 + ".name";
                Role nextRole = new Role(((Properties)p2).getProperty(lookupKey));
                System.out.println("-adding role: " + nextRole);
                String usersLookupKey = "role" + j2 + ".users";
                String groupsLookupKey = "role" + j2 + ".groups";
                if (((Properties)p2).getProperty(usersLookupKey) != null) {
                    PropsToXmlConverter.makeUserRoleMapping(rm, nextRole, ((Properties)p2).getProperty(usersLookupKey));
                }
                if (((Properties)p2).getProperty(groupsLookupKey) != null) {
                    PropsToXmlConverter.makeGroupRoleMapping(rm, nextRole, ((Properties)p2).getProperty(groupsLookupKey));
                }
                ejbBundleDescriptor.addRole(nextRole);
                ++j2;
            }
        }
        if (((Properties)p2).getProperty("cmp.DBJndiName") != null) {
            ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor();
            rrd.setJndiName(((Properties)p2).getProperty("cmp.DBJndiName"));
            rrd.setResourcePrincipal(PropsToXmlConverter.parseResourcePrincipalFromString(((Properties)p2).getProperty("cmp.defaultDBAccount")));
            ejbBundleDescriptor.setCMPResourceReference(rrd);
        }
        int ejbcount = Integer.parseInt(((Properties)p2).getProperty("ejbcount"));
        int i2 = 0;
        while (i2 < ejbcount) {
            Collection allMethods;
            String pers;
            String prefix = "ejb" + i2 + ".";
            String type = ((Properties)p2).getProperty(prefix + "type");
            ejbDescriptor = type.equalsIgnoreCase(EjbSessionDescriptor.TYPE) ? new EjbSessionDescriptor() : (type.equalsIgnoreCase(EjbEntityDescriptor.TYPE) ? ((pers = (pers = ((Properties)p2).getProperty(prefix + "entity.persistenceType")) == null ? EjbEntityDescriptor.BEAN_PERSISTENCE : pers.trim()).equals(EjbEntityDescriptor.BEAN_PERSISTENCE) ? new EjbEntityDescriptor() : new EjbCMPEntityDescriptor()) : new EjbMessageBeanDescriptor());
            this.createIORConfigurationDescriptor(ejbDescriptor, prefix, p2);
            this.createIORConfigDescriptors(ejbDescriptor, prefix, p2);
            String logicalName = ((Properties)p2).getProperty(prefix + "logicalName");
            if (logicalName != null) {
                ejbDescriptor.setName(logicalName);
            }
            String ejbClassName = ((Properties)p2).getProperty(prefix + "name");
            ejbDescriptor.setEjbClassName(ejbClassName);
            Class<?> ejbClass = fcl.loadClass(ejbClassName);
            ejbDescriptor.setJndiName(((Properties)p2).getProperty(prefix + "JNDIName"));
            if (type.equalsIgnoreCase("Message-driven")) {
                String destType;
                String mdbConnectionFactory;
                String jmsClientID;
                EjbMessageBeanDescriptor msgBean = (EjbMessageBeanDescriptor)ejbDescriptor;
                String messageSelector = ((Properties)p2).getProperty(prefix + MESSAGE_SELECTOR_PROP);
                if (messageSelector != null) {
                    msgBean.setJmsMessageSelector(messageSelector);
                }
                if ((jmsClientID = ((Properties)p2).getProperty(prefix + JMS_CLIENT_ID)) != null) {
                    System.out.println("Warning : jms-client-id is an obsolete property.  Set client id on a JMS Connection Factory and use the mdb-connection-factory property instead");
                }
                if ((mdbConnectionFactory = ((Properties)p2).getProperty(prefix + MDB_CONNECTION_FACTORY)) != null) {
                    msgBean.setConnectionFactoryName(mdbConnectionFactory);
                }
                if ((destType = ((Properties)p2).getProperty(prefix + MSG_BEAN_DEST_TYPE_PROP)) == null) throw new RuntimeException("Must specify the message bean destination type");
                if (destType.equals(QUEUE_DEST_TYPE)) {
                    msgBean.setHasQueueDest();
                    msgBean.setHasDurableSubscription(false);
                } else {
                    if (!destType.equals(TOPIC_DEST_TYPE)) throw new RuntimeException("Invalid message bean destination type : " + destType);
                    msgBean.setHasTopicDest();
                    String subscriptionName = ((Properties)p2).getProperty(prefix + DURABLE_SUBSCRIPTION_NAME_PROP);
                    if (subscriptionName != null) {
                        msgBean.setHasDurableSubscription(true);
                        msgBean.setDurableSubscriptionName(subscriptionName);
                    } else {
                        msgBean.setHasDurableSubscription(false);
                    }
                }
                String ackMode = ((Properties)p2).getProperty(prefix + JMS_ACKNOWLEDGE_MODE_PROP);
                if (ackMode != null) {
                    String txAttribute = ((Properties)p2).getProperty(prefix + "transactionAttribute");
                    if (txAttribute.equals("TX_BEAN_MANAGED")) {
                        if (ackMode.equals(AUTO_ACKNOWLEDGE_MODE)) {
                            msgBean.setJmsAcknowledgeMode(1);
                        } else {
                            if (!ackMode.equals(DUPS_OK_MODE)) throw new RuntimeException("Invalid ack mode = " + ackMode);
                            msgBean.setJmsAcknowledgeMode(3);
                        }
                    } else {
                        System.out.println("Warning : message-driven beans with container-managed transactions can't have a jms acknowledge mode");
                    }
                }
            } else {
                this.convertInterfaces(prefix, p2, ejbDescriptor);
            }
            this.convertEnvironmentProperties(prefix, p2, ejbDescriptor);
            int mCount = Integer.parseInt(((Properties)p2).getProperty(prefix + "#methodDescriptors"));
            String ejb1TransactionAttribute = ((Properties)p2).getProperty(prefix + "transactionAttribute");
            if (ejb1TransactionAttribute.equals("TX_BEAN_MANAGED")) {
                System.out.println("You have chosen to make this bean manage its own transactions. This is illegal for entity beans, and the (session) bean cannot specifiy any method level container transactions.");
                ejbDescriptor.setTransactionType(EjbDescriptor.BEAN_TRANSACTION_TYPE);
            } else {
                ejbDescriptor.setTransactionType(EjbDescriptor.CONTAINER_TRANSACTION_TYPE);
                String mosconeTransactionAttribute = PropsToXmlConverter.convertTransactionAttribute(ejb1TransactionAttribute);
                System.out.println("You have entered the bean level transaction attribute of " + ejb1TransactionAttribute);
                System.out.println("This is being interpreted as follows:");
                System.out.println("1) The bean level transaction attribute is 'Container'");
                System.out.println("2) The default for all the method level container transactions is " + mosconeTransactionAttribute);
                System.out.println("3) This default for each method is overridden by any method level transaction attribute you specify elsewhere in the props file");
                if (type.equalsIgnoreCase("Message-driven")) {
                    if (!mosconeTransactionAttribute.equals(ContainerTransaction.NOT_SUPPORTED) && !mosconeTransactionAttribute.equals(ContainerTransaction.REQUIRED)) throw new RuntimeException("ERROR : TX ATTRIBUTE '" + mosconeTransactionAttribute + "' is not valid for message-driven beans");
                    ContainerTransaction methodContainerTransaction = new ContainerTransaction(mosconeTransactionAttribute, "");
                    Class[] paramTypes = new Class[]{class$javax$jms$Message == null ? PropsToXmlConverter.class$("javax.jms.Message") : class$javax$jms$Message};
                    Method onMessageMethod = ejbClass.getMethod("onMessage", paramTypes);
                    ejbDescriptor.setContainerTransactionFor(onMessageMethod, methodContainerTransaction);
                } else {
                    allMethods = BeanMethodCalculator.getTransactionalMethodsFor(ejbDescriptor, fcl);
                    Iterator iterator = allMethods.iterator();
                    while (iterator.hasNext()) {
                        Method nextMethod = (Method)iterator.next();
                        MethodDescriptor nextMethodDescriptor = new MethodDescriptor(nextMethod, ejbDescriptor, fcl);
                        ContainerTransaction methodContainerTransaction = new ContainerTransaction(mosconeTransactionAttribute, "");
                        ejbDescriptor.getMethodContainerTransactions().put(nextMethodDescriptor, methodContainerTransaction);
                    }
                }
            }
            Vector<MethodDescriptor> allMethodsDescriptors = new Vector<MethodDescriptor>();
            allMethods = BeanMethodCalculator.getTransactionalMethodsFor(ejbDescriptor, fcl);
            Iterator allMethodsItr = allMethods.iterator();
            while (allMethodsItr.hasNext()) {
                Method m2 = (Method)allMethodsItr.next();
                allMethodsDescriptors.add(new MethodDescriptor(m2, ejbDescriptor, fcl));
            }
            int j3 = 0;
            while (j3 < mCount) {
                String mPrefix = prefix + "mdesc" + j3 + ".";
                MethodDescriptor styledMd = this.convertMethodDescriptor(mPrefix, p2, fcl, ejbDescriptor);
                Vector mds = styledMd.doStyleConversion(ejbDescriptor, allMethodsDescriptors);
                ejb1TransactionAttribute = ((Properties)p2).getProperty(mPrefix + "transactionAttribute");
                String mosconeTransactionAttribute = PropsToXmlConverter.convertTransactionAttribute(ejb1TransactionAttribute);
                ContainerTransaction methodContainerTransaction = new ContainerTransaction(mosconeTransactionAttribute, "");
                Iterator mdsItr = ((AbstractList)mds).iterator();
                while (mdsItr.hasNext()) {
                    MethodDescriptor md = (MethodDescriptor)mdsItr.next();
                    ejbDescriptor.getMethodContainerTransactions().put(md, methodContainerTransaction);
                }
                ++j3;
            }
            if (type.equalsIgnoreCase(EjbSessionDescriptor.TYPE)) {
                EjbSessionDescriptor sessionDescriptor = (EjbSessionDescriptor)ejbDescriptor;
                String sm = ((Properties)p2).getProperty(prefix + "session.state");
                if (sm.equals("STATEFUL_SESSION")) {
                    sessionDescriptor.setStateless(false);
                } else if (sm.equals("STATELESS_SESSION")) {
                    sessionDescriptor.setStateless(true);
                }
            } else if (type.equalsIgnoreCase(EjbEntityDescriptor.TYPE)) {
                EjbEntityDescriptor entityDescriptor = (EjbEntityDescriptor)ejbDescriptor;
                String ePrefix = prefix + "entity.";
                String name = ((Properties)p2).getProperty(ePrefix + "primaryKey");
                entityDescriptor.setPrimaryKeyClassName(name);
                String reentrant = ((Properties)p2).getProperty(prefix + "isReentrant");
                if (reentrant != null && "true".equals(reentrant)) {
                    entityDescriptor.setReentrant(true);
                }
                if (entityDescriptor instanceof EjbCMPEntityDescriptor) {
                    EjbCMPEntityDescriptor cmpDescriptor = (EjbCMPEntityDescriptor)entityDescriptor;
                    String cmpVersion = ((Properties)p2).getProperty(ePrefix + "cmpVersion");
                    cmpVersion = cmpVersion == null ? EjbCMPEntityDescriptor.CMP_1_VERSION : cmpVersion.trim();
                    cmpDescriptor.setCMPVersion(cmpVersion);
                    boolean isEJB20 = false;
                    if (cmpVersion.equals(EjbCMPEntityDescriptor.CMP_2_VERSION)) {
                        isEJB20 = true;
                    }
                    if (isEJB20) {
                        String schema = ((Properties)p2).getProperty(ePrefix + "abstractSchemaName");
                        if (schema == null) {
                            throw new IOException("Need entity.abstractSchemaName for EJB2.0 CMP EntityBean");
                        }
                        schema = schema.trim();
                        cmpDescriptor.setAbstractSchemaName(schema);
                    }
                    PersistenceDescriptor pers2 = this.loadPersistenceDescriptor(ePrefix, p2, fcl, isEJB20);
                    cmpDescriptor.setPersistenceDescriptor(pers2);
                    String primaryKeyFieldName = ((Properties)p2).getProperty(ePrefix + "primaryKeyField");
                    if (primaryKeyFieldName != null) {
                        cmpDescriptor.setPrimaryKeyFieldDesc(new FieldDescriptor(primaryKeyFieldName, ""));
                    }
                    if (((Properties)p2).getProperty(prefix + "entity.DBJndiName") != null) {
                        ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor();
                        rrd.setJndiName(((Properties)p2).getProperty(prefix + "entity.DBJndiName"));
                        rrd.setResourcePrincipal(PropsToXmlConverter.parseResourcePrincipalFromString(((Properties)p2).getProperty(prefix + "entity.defaultDBAccount")));
                        ejbBundleDescriptor.setCMPResourceReference(rrd);
                    }
                }
            }
            this.convertResourceReferences(prefix, p2, ejbDescriptor);
            System.out.println("Adding an XML EJB descriptor to the application...");
            ejbBundleDescriptor.addEjb(ejbDescriptor);
            this.convertMethodPermissions(prefix, p2, ejbDescriptor, fcl);
            String runAsRole = ((Properties)p2).getProperty(prefix + "runAsRole");
            String runAsPrincipal = ((Properties)p2).getProperty(prefix + "runAsPrincipal");
            if (runAsRole != null) {
                RunAsIdentityDescriptor raid = new RunAsIdentityDescriptor();
                raid.setRoleName(runAsRole);
                raid.setPrincipal(runAsPrincipal);
                ejbDescriptor.setUsesCallerIdentity(false);
                ejbDescriptor.setRunAsIdentity(raid);
            } else if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                ejbDescriptor.setUsesCallerIdentity(false);
            }
            ++i2;
        }
        if (!ejbBundleDescriptor.areResourceReferencesValid()) {
            throw new RuntimeException("Make sure that if you declare an env prop to be a role reference, the value of the prop must be a declared role");
        }
        Enumeration e10 = this.ejbReferencesToConvert.keys();
        while (e10.hasMoreElements()) {
            String envPrefix = (String)e10.nextElement();
            ejbDescriptor = (EjbDescriptor)this.ejbReferencesToConvert.get(envPrefix);
            this.convertEjbReference(ejbDescriptor.getEjbBundleDescriptor(), p2, envPrefix, ejbDescriptor);
        }
        this.convertRemoteEntityRefs(ejbBundleDescriptor, p2);
        this.convertRelationships(ejbBundleDescriptor, p2);
        PropsToXmlConverter.writeXmlToFiles(application, xmlFilename, optionalEjbBundleFilename, optionalRuntimeFilename);
        System.out.println("Done: XML deployment descriptor for " + application.getName() + " has been written to " + xmlFilename);
    }

    private void convertInterfaces(String prefix, Properties p2, EjbAbstractDescriptor ejbDescriptor) {
        String localHome;
        String home = p2.getProperty(prefix + "homeInterface");
        if (home != null) {
            if (p2.getProperty(prefix + "remoteInterface") == null) {
                throw new RuntimeException("Home interface " + home + " present but not remote interface is defined");
            }
            ejbDescriptor.setHomeClassName(home);
            ejbDescriptor.setRemoteClassName(p2.getProperty(prefix + "remoteInterface"));
        }
        if ((localHome = p2.getProperty(prefix + "localHomeInterface")) != null) {
            if (p2.getProperty(prefix + "localInterface") == null) {
                throw new RuntimeException("Local Home interface " + home + " present but not local interface is defined");
            }
            ejbDescriptor.setLocalHomeClassName(localHome);
            ejbDescriptor.setLocalClassName(p2.getProperty(prefix + "localInterface"));
        }
        if (home == null && localHome == null) {
            throw new RuntimeException("Session or Entity beans should define at least a local or remote interface");
        }
    }

    private PersistenceDescriptor loadPersistenceDescriptor(String prefix, Properties p2, ClassLoader fcl, boolean isEJB20) throws IOException {
        String sql;
        String deleteTable;
        String createTable;
        String countString = p2.getProperty(prefix + "#containerFields");
        HashSet<FieldDescriptor> persistentFields = new HashSet<FieldDescriptor>();
        if (countString != null) {
            int count = Integer.parseInt(countString);
            int j2 = 0;
            while (j2 < count) {
                String str = prefix + "containerField" + j2;
                String fieldName = p2.getProperty(str);
                if (isEJB20) {
                    FieldDescriptor.checkFieldName(fieldName);
                }
                FieldDescriptor fieldDescriptor = new FieldDescriptor(fieldName, "");
                persistentFields.add(fieldDescriptor);
                ++j2;
            }
        }
        PersistenceDescriptor pers = new PersistenceDescriptor();
        pers.setCMPFields(persistentFields);
        String npkFields = p2.getProperty(prefix + "#pkFields");
        if (npkFields != null && !npkFields.equals("")) {
            int count = Integer.parseInt(npkFields);
            HashSet<FieldDescriptor> pkFields = new HashSet<FieldDescriptor>();
            int j3 = 0;
            while (j3 < count) {
                String str = prefix + "pkField" + j3;
                String fieldName = p2.getProperty(str);
                FieldDescriptor fieldDescriptor = new FieldDescriptor(fieldName, "");
                if (fieldName == null) {
                    throw new IOException("Bad pkField count or pkField key");
                }
                pkFields.add(fieldDescriptor);
                ++j3;
            }
            pers.setPkeyFields(pkFields);
        }
        if ((createTable = p2.getProperty(prefix + "createTableOnDeployment")) != null) {
            pers.setCreateTableOnDeployment(new Boolean(createTable));
        }
        if ((deleteTable = p2.getProperty(prefix + "deleteTableOnUndeployment")) != null) {
            pers.setDeleteTableOnUndeployment(new Boolean(deleteTable));
        }
        if (p2.getProperty(prefix + "#sqlStatements") != null) {
            int sqlStatementCount = Integer.parseInt(p2.getProperty(prefix + "#sqlStatements"));
            int index = 0;
            while (index < sqlStatementCount) {
                String sqlPrefix = prefix + "sqlStatement" + index + ".";
                sql = p2.getProperty(sqlPrefix + "sql");
                String op = p2.getProperty(sqlPrefix + "operation");
                if (op != null) {
                    pers.setSqlStatementFor(op.trim(), sql);
                } else {
                    QueryDescriptor query = new QueryDescriptor();
                    query.setSQL(sql);
                    String qMethodPrefix = sqlPrefix + "mdesc.";
                    try {
                        Method m2 = this.convertMethod(qMethodPrefix, p2, fcl);
                        query.setQueryMethod(m2);
                        pers.setQueryFor(m2, query);
                    }
                    catch (Exception ex2) {
                        throw new IOException(ex2.getMessage());
                    }
                }
                ++index;
            }
        }
        if (p2.getProperty(prefix + "#queries") != null) {
            int queryCount = Integer.parseInt(p2.getProperty(prefix + "#queries"));
            int index = 0;
            while (index < queryCount) {
                String qPrefix = prefix + "query" + index + ".";
                sql = p2.getProperty(qPrefix + "sql");
                String description = p2.getProperty(qPrefix + "description");
                String returnTypeMapping = p2.getProperty(qPrefix + "result-type-mapping");
                QueryDescriptor query = new QueryDescriptor();
                query.setSQL(sql);
                String ejbql = p2.getProperty(qPrefix + "ejbql");
                if (ejbql != null) {
                    query.setQuery(ejbql.trim());
                }
                if (description != null) {
                    query.setDescription(description);
                }
                if (returnTypeMapping != null) {
                    if (returnTypeMapping.equalsIgnoreCase("remote")) {
                        query.setHasRemoteReturnTypeMapping();
                    } else if (returnTypeMapping.equalsIgnoreCase("local")) {
                        query.setHasLocalReturnTypeMapping();
                    } else {
                        throw new RuntimeException(qPrefix + "result-type-mapping" + " does not have an acceptable value : " + returnTypeMapping);
                    }
                }
                String qMethodPrefix = qPrefix + "mdesc.";
                try {
                    Method m3 = this.convertMethod(qMethodPrefix, p2, fcl);
                    query.setQueryMethod(m3);
                    pers.setQueryFor(m3, query);
                }
                catch (Exception ex3) {
                    throw new IOException(ex3.getMessage());
                }
                ++index;
            }
        }
        return pers;
    }

    private void createIORConfigurationDescriptor(EjbDescriptor ejbDescriptor, String prefix, Properties p2) {
        String callerPropagation;
        String authRequired;
        String realmName;
        String authMethod;
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        String integrity;
        int mPermissionsCount;
        String methodPermissionsCountKey = prefix + "#methodPermissions";
        String propCountKey = p2.getProperty(methodPermissionsCountKey);
        boolean enableUserNamePassword = false;
        if (propCountKey != null && (mPermissionsCount = Integer.parseInt(propCountKey)) > 0) {
            enableUserNamePassword = true;
        }
        EjbIORConfigurationDescriptor iorDesc = new EjbIORConfigurationDescriptor();
        if (enableUserNamePassword) {
            iorDesc.setAuthMethodRequired(true);
        }
        if ((integrity = p2.getProperty(prefix + "integrity")) != null) {
            iorDesc.setIntegrity(integrity);
        }
        if ((confidentiality = p2.getProperty(prefix + "confidentiality")) != null) {
            iorDesc.setConfidentiality(confidentiality);
        }
        if ((establishTrustInTarget = p2.getProperty(prefix + "establishTrustInTarget")) != null) {
            iorDesc.setEstablishTrustInTarget(establishTrustInTarget);
        }
        if ((establishTrustInClient = p2.getProperty(prefix + "establishTrustInClient")) != null) {
            iorDesc.setEstablishTrustInClient(establishTrustInClient);
        }
        if ((authMethod = p2.getProperty(prefix + "authMethod")) != null) {
            iorDesc.setAuthenticationMethod(authMethod);
        }
        if ((realmName = p2.getProperty(prefix + "realmName")) != null) {
            iorDesc.setRealmName(realmName);
        }
        if ((authRequired = p2.getProperty(prefix + "authRequired")) != null) {
            if (authRequired.equals("true")) {
                iorDesc.setAuthMethodRequired(true);
            } else {
                iorDesc.setAuthMethodRequired(false);
            }
        }
        if ((callerPropagation = p2.getProperty(prefix + "callerPropagation")) != null) {
            iorDesc.setCallerPropagation(callerPropagation);
        }
        ejbDescriptor.addIORConfigurationDescriptor(iorDesc);
    }

    private void createIORConfigDescriptors(EjbDescriptor ejbDescriptor, String prefix, Properties p2) {
        String mprefix = prefix + "interop.";
        int parameterCount = 0;
        if (p2.getProperty(mprefix + "#parameters") != null) {
            parameterCount = Integer.parseInt(p2.getProperty(mprefix + "#parameters"));
            ejbDescriptor.getIORConfigurationDescriptors().clear();
        }
        int i2 = 0;
        while (i2 < parameterCount) {
            String callerPropagation;
            String authRequired;
            String realmName;
            String authMethod;
            String establishTrustInClient;
            String establishTrustInTarget;
            String confidentiality;
            String pfx = prefix + "interop" + i2 + ".";
            EjbIORConfigurationDescriptor iorDesc = new EjbIORConfigurationDescriptor();
            String integrity = p2.getProperty(pfx + "integrity");
            if (integrity != null) {
                iorDesc.setIntegrity(integrity);
            }
            if ((confidentiality = p2.getProperty(pfx + "confidentiality")) != null) {
                iorDesc.setConfidentiality(confidentiality);
            }
            if ((establishTrustInTarget = p2.getProperty(pfx + "establishTrustInTarget")) != null) {
                iorDesc.setEstablishTrustInTarget(establishTrustInTarget);
            }
            if ((establishTrustInClient = p2.getProperty(pfx + "establishTrustInClient")) != null) {
                iorDesc.setEstablishTrustInClient(establishTrustInClient);
            }
            if ((authMethod = p2.getProperty(pfx + "authMethod")) != null) {
                iorDesc.setAuthenticationMethod(authMethod);
            }
            if ((realmName = p2.getProperty(pfx + "realmName")) != null) {
                iorDesc.setRealmName(realmName);
            }
            if ((authRequired = p2.getProperty(pfx + "authRequired")) != null) {
                if (authRequired.equals("true")) {
                    iorDesc.setAuthMethodRequired(true);
                } else {
                    iorDesc.setAuthMethodRequired(false);
                }
            }
            if ((callerPropagation = p2.getProperty(pfx + "callerPropagation")) != null) {
                iorDesc.setCallerPropagation(callerPropagation);
            }
            ejbDescriptor.addIORConfigurationDescriptor(iorDesc);
            ++i2;
        }
    }

    private Method convertMethod(String mPrefix, Properties p2, ClassLoader fcl) throws Exception {
        String className = p2.getProperty(mPrefix + "classname");
        if (className == null) {
            throw new IOException("Bad mdesc count or mdesc key");
        }
        int parameterCount = 0;
        if (p2.getProperty(mPrefix + "#parameters") != null) {
            parameterCount = Integer.parseInt(p2.getProperty(mPrefix + "#parameters"));
        }
        String[] parameters = new String[parameterCount];
        int i2 = 0;
        while (i2 < parameterCount) {
            String parameterType;
            parameters[i2] = parameterType = p2.getProperty(mPrefix + "parameter" + i2);
            ++i2;
        }
        String methodName = p2.getProperty(mPrefix + "methodname");
        if (methodName == null) {
            throw new RuntimeException("no value for " + mPrefix + "methodname is causing a method descriptor parse error");
        }
        Method[] methods = fcl.loadClass(className).getMethods();
        Method method = null;
        int k2 = 0;
        while (k2 < methods.length) {
            if (methods[k2].getName().equals(methodName) && methods[k2].getParameterTypes().length == parameterCount) {
                if (parameterCount > 0) {
                    Class<?>[] paramTypes = methods[k2].getParameterTypes();
                    boolean matches = true;
                    int i3 = 0;
                    while (i3 < parameterCount) {
                        String fixedType = MethodDescriptor.fixParamClassName(paramTypes[i3].getName());
                        if (!fixedType.equals(parameters[i3])) {
                            matches = false;
                            break;
                        }
                        ++i3;
                    }
                    if (matches) {
                        method = methods[k2];
                        break;
                    }
                } else {
                    method = methods[k2];
                    break;
                }
            }
            ++k2;
        }
        if (method == null) {
            throw new RuntimeException("Couldn't locate method for " + methodName);
        }
        return method;
    }

    private MethodDescriptor convertMethodDescriptor(String mPrefix, Properties p2, ClassLoader fcl, EjbDescriptor ejbDescriptor) throws Exception {
        String methodName;
        String className = p2.getProperty(mPrefix + "classname");
        if (className == null) {
            throw new IOException("Bad mdesc count or mdesc key");
        }
        String methodIntf = BeanMethodCalculator.getMethodIntfFor(className, fcl, ejbDescriptor);
        if (methodIntf == null) {
            throw new RuntimeException(className + " is not a valid interface name for the bean " + ejbDescriptor.getName());
        }
        int parameterCount = 0;
        if (p2.getProperty(mPrefix + "#parameters") != null) {
            parameterCount = Integer.parseInt(p2.getProperty(mPrefix + "#parameters"));
        }
        if ((methodName = p2.getProperty(mPrefix + "methodname")) == null) {
            throw new RuntimeException("no value for " + mPrefix + "methodname is causing a method descriptor parse error");
        }
        String[] parameters = null;
        if (parameterCount > 0) {
            parameters = new String[parameterCount];
            int i2 = 0;
            while (i2 < parameterCount) {
                String parameterType;
                parameters[i2] = parameterType = p2.getProperty(mPrefix + "parameter" + i2);
                ++i2;
            }
        }
        return new MethodDescriptor(methodName, "", parameters, methodIntf);
    }

    private void convertMethodPermissions(String prefix, Properties p2, EjbDescriptor ejbDescriptor, ClassLoader fcl) throws Exception {
        String methodPermissionsCountKey = prefix + "#methodPermissions";
        int mPermissionsCount = 0;
        if (p2.getProperty(methodPermissionsCountKey) != null) {
            System.out.println("There are method permissions set");
            mPermissionsCount = Integer.parseInt(p2.getProperty(methodPermissionsCountKey));
            int j2 = 0;
            while (j2 < mPermissionsCount) {
                String methodKey = prefix + "mdesc" + j2 + ".";
                MethodDescriptor styledMd = this.convertMethodDescriptor(methodKey, p2, fcl, ejbDescriptor);
                if (MethodDescriptor.EJB_BEAN.equals(styledMd.getEjbClassSymbol())) {
                    throw new RuntimeException("Method permissions cannot be set on EJB class methods like : " + styledMd);
                }
                boolean isExcluded = false;
                if (p2.getProperty(methodKey + "isExcluded") != null) {
                    isExcluded = new Boolean(p2.getProperty(methodKey + "isExcluded"));
                }
                boolean isChecked = true;
                if (p2.getProperty(methodKey + "isChecked") != null) {
                    isChecked = new Boolean(p2.getProperty(methodKey + "isChecked"));
                }
                String permissionedRoles = p2.getProperty(methodKey + "permissionedRoles");
                Set allMethods = ejbDescriptor.getMethodDescriptors();
                Vector methodDescriptors = styledMd.doStyleConversion(ejbDescriptor, allMethods);
                Iterator itr = ((AbstractList)methodDescriptors).iterator();
                while (itr.hasNext()) {
                    MethodPermission mp;
                    MethodDescriptor md = (MethodDescriptor)itr.next();
                    String className = p2.getProperty(methodKey + "classname");
                    try {
                        Method method = md.getMethod(fcl.loadClass(className));
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new RuntimeException(className + " cannot be loaded");
                    }
                    catch (Exception e10) {
                        throw new RuntimeException("Couldn't localte method for " + md.getName());
                    }
                    if (isExcluded) {
                        mp = MethodPermission.getExcludedMethodPermission();
                        System.out.println(md + " is excluded");
                        ejbDescriptor.addPermissionedMethod(mp, md);
                        continue;
                    }
                    if (permissionedRoles != null) {
                        Enumeration e11 = PropsToXmlConverter.parseRolesFrom(permissionedRoles);
                        while (e11.hasMoreElements()) {
                            Role r2 = (Role)e11.nextElement();
                            System.out.println(r2 + " can call " + md);
                            MethodPermission mp2 = new MethodPermission(r2);
                            ejbDescriptor.addPermissionedMethod(mp2, md);
                        }
                        continue;
                    }
                    mp = MethodPermission.getUncheckedMethodPermission();
                    System.out.println(md + " is unchecked");
                    ejbDescriptor.addPermissionedMethod(mp, md);
                }
                ++j2;
            }
        }
    }

    private void addMethodPermissionsToAllMethods(EjbDescriptor ejbDescriptor, MethodPermission mp, MethodDescriptor md) {
        ejbDescriptor.addPermissionedMethod(mp, md);
    }

    private void convertResourceReferences(String prefix, Properties p2, EjbDescriptor ejbDescriptor) throws IOException {
        String resourceReferencesKey = p2.getProperty(prefix + "#resourceReferences");
        if (resourceReferencesKey != null) {
            int resCount = Integer.parseInt(p2.getProperty(prefix + "#resourceReferences"));
            int j2 = 0;
            while (j2 < resCount) {
                String mainResourceKey = prefix + "resourceReference" + j2;
                String resourceName = p2.getProperty(mainResourceKey + ".name");
                String jndiName = p2.getProperty(mainResourceKey + ".jndiName");
                String resourceType = p2.getProperty(mainResourceKey + ".type");
                String authorization = p2.getProperty(mainResourceKey + ".authorization");
                EnvironmentProperty ep2 = new EnvironmentProperty(resourceName, jndiName, "description");
                ResourceReferenceDescriptor rr = new ResourceReferenceDescriptor(resourceName, "description", resourceType);
                rr.setJndiName(jndiName);
                if (authorization != null) {
                    rr.setAuthorization(authorization);
                }
                ejbDescriptor.addResourceReferenceDescriptor(rr);
                String defaultDBAccountString = p2.getProperty(mainResourceKey + ".defaultDBAccount");
                rr.setResourcePrincipal(PropsToXmlConverter.parseResourcePrincipalFromString(defaultDBAccountString));
                String mailConfigurationString = p2.getProperty(mainResourceKey + ".mailConfiguration");
                System.out.println("--- " + mailConfigurationString);
                rr.setMailConfiguration(PropsToXmlConverter.parseMailConfigurationFromString(mailConfigurationString));
                ++j2;
            }
        }
    }

    private static Enumeration parseRolesFrom(String commaSeparatedRoleNames) {
        Vector<Role> roles = new Vector<Role>();
        if (commaSeparatedRoleNames != null) {
            StringTokenizer st = new StringTokenizer(commaSeparatedRoleNames, ",");
            while (st.hasMoreTokens()) {
                roles.addElement(new Role(st.nextToken()));
            }
        }
        return roles.elements();
    }

    private static void makeUserRoleMapping(RoleMapper rm, Role r2, String commaSeparatedList) {
        StringTokenizer st = new StringTokenizer(commaSeparatedList, ",");
        String sequence = "\"";
        String comma = ",";
        while (st.hasMoreTokens()) {
            String nxt = st.nextToken();
            String next = nxt.trim();
            StringBuffer userString = new StringBuffer(next);
            if (next.startsWith(sequence)) {
                userString = userString.deleteCharAt(0);
                while (st.hasMoreTokens()) {
                    String last = st.nextToken();
                    userString.append(comma);
                    userString.append(last);
                    if (!last.endsWith(sequence)) continue;
                    userString = userString.deleteCharAt(userString.length() - 1);
                    break;
                }
            }
            rm.assignRole(new PrincipalImpl(userString.toString()), r2);
        }
    }

    private static void makeGroupRoleMapping(RoleMapper rm, Role r2, String commaSeparatedList) {
        StringTokenizer st = new StringTokenizer(commaSeparatedList, ",");
        while (st.hasMoreTokens()) {
            rm.assignRole(new Group(st.nextToken()), r2);
        }
    }

    private static ResourcePrincipal parseResourcePrincipalFromString(String s2) {
        if (s2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s2, ",");
        return new ResourcePrincipal(st.nextToken(), st.nextToken());
    }

    static MailConfiguration parseMailConfigurationFromString(String s2) {
        if (s2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s2, ",");
        return new MailConfiguration(st.nextToken(), st.nextToken(), st.nextToken());
    }

    public static void main(String[] args) {
        try {
            if (args[0] != null && args[1] != null && args[2] != null) {
                String optionalEjbBundleFilename = "";
                String optionalRuntimeFilename = "";
                if (args.length == 5) {
                    if (args[3] != null) {
                        optionalEjbBundleFilename = args[3];
                    }
                    if (args[4] != null) {
                        optionalRuntimeFilename = args[4];
                    }
                }
                PropsToXmlConverter converter = new PropsToXmlConverter();
                converter.convertToXml(new File(args[0]), args[1], args[2], optionalEjbBundleFilename, optionalRuntimeFilename);
            } else {
                PropsToXmlConverter.help();
                System.exit(1);
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.out.println(" error converting properties file ");
            System.exit(1);
        }
    }

    public static String convertTransactionAttribute(String ejb1TransactionAttribute) {
        if (ejb1TransactionAttribute.equals("TX_NOT_SUPPORTED")) {
            return ContainerTransaction.NOT_SUPPORTED;
        }
        if (ejb1TransactionAttribute.equals("TX_REQUIRED")) {
            return ContainerTransaction.REQUIRED;
        }
        if (ejb1TransactionAttribute.equals("TX_SUPPORTS")) {
            return ContainerTransaction.SUPPORTS;
        }
        if (ejb1TransactionAttribute.equals("TX_REQUIRES_NEW")) {
            return ContainerTransaction.REQUIRES_NEW;
        }
        if (ejb1TransactionAttribute.equals("TX_MANDATORY")) {
            return ContainerTransaction.MANDATORY;
        }
        if (ejb1TransactionAttribute.equals("TX_NEVER")) {
            return ContainerTransaction.NEVER;
        }
        throw new IllegalArgumentException(ejb1TransactionAttribute + " is not a known transaction attribute in EJB 1.0");
    }

    private void convertRemoteEntityRefs(EjbBundleDescriptor bundleDesc, Properties p2) throws IOException {
        String count = p2.getProperty("remoteBeanCount");
        if (count == null) {
            return;
        }
        int cnt = Integer.parseInt(count);
        int idx = 0;
        while (idx < cnt) {
            String prefix = "remoteBean" + idx + ".";
            String beanName = p2.getProperty(prefix + "remoteEjbName");
            String homeName = p2.getProperty(prefix + "homeInterface");
            String remoteName = p2.getProperty(prefix + "remoteInterface");
            String jndiName = p2.getProperty(prefix + "jndiName");
            String linkName = p2.getProperty(prefix + "linkName");
            EjbExternalEntityDescriptor remoteBean = new EjbExternalEntityDescriptor();
            remoteBean.setName(beanName);
            remoteBean.setHomeClassName(homeName);
            remoteBean.setRemoteClassName(remoteName);
            remoteBean.setJndiName(jndiName);
            if (linkName != null) {
                EjbDescriptor linkedBean = bundleDesc.getEjbByName(linkName);
                remoteBean.setEntityDesc((EjbEntityDescriptor)linkedBean);
                remoteBean.setLinkName(linkName);
            }
            bundleDesc.addRemoteEntity(remoteBean);
            ++idx;
        }
    }

    private void convertRelationships(EjbBundleDescriptor ejbBundleDescriptor, Properties p2) {
        String count = p2.getProperty("relationshipcount");
        if (count == null) {
            return;
        }
        int cnt = Integer.parseInt(count);
        int i2 = 0;
        while (i2 < cnt) {
            String prefix = "relationship" + i2 + ".";
            String sourceName = p2.getProperty(prefix + "source");
            String sourceRoleName = p2.getProperty(prefix + "sourceRoleName");
            String sinkName = p2.getProperty(prefix + "sink");
            String sinkRoleName = p2.getProperty(prefix + "sinkRoleName");
            String sourceField = p2.getProperty(prefix + "sourceField");
            String sourceFieldType = p2.getProperty(prefix + "sourceFieldType");
            String sinkField = p2.getProperty(prefix + "sinkField");
            String sinkFieldType = p2.getProperty(prefix + "sinkFieldType");
            String sourceCascade = p2.getProperty(prefix + "sourceCascadeDelete");
            String sinkCascade = p2.getProperty(prefix + "sinkCascadeDelete");
            String multiplicity = p2.getProperty(prefix + "multiplicity");
            String isBidir = p2.getProperty(prefix + "isBidirectional");
            String name = p2.getProperty(prefix + "name");
            RelationshipDescriptor rd = new RelationshipDescriptor();
            if (name != null) {
                rd.setName(name);
            }
            Descriptor source = ejbBundleDescriptor.getDescriptorByName(sourceName.trim());
            Descriptor sink = ejbBundleDescriptor.getDescriptorByName(sinkName.trim());
            if (source == null || sink == null) {
                throw new RuntimeException("Unable to find source/sink object");
            }
            RelationRoleDescriptor sourceRole = new RelationRoleDescriptor();
            rd.setSource(sourceRole);
            sourceRole.setRelationshipDescriptor(rd);
            if (sourceRoleName == null) {
                sourceRoleName = sourceName + "-" + sinkName;
            }
            sourceRole.setName(sourceRoleName);
            RelationRoleDescriptor sinkRole = new RelationRoleDescriptor();
            rd.setSink(sinkRole);
            sinkRole.setRelationshipDescriptor(rd);
            if (sinkRoleName == null) {
                sinkRoleName = sinkName + "-" + sourceName;
            }
            sinkRole.setName(sinkRoleName);
            sourceRole.setPersistenceDescriptor(((EjbCMPEntityDescriptor)source).getPersistenceDescriptor());
            sourceRole.setPartner(sinkRole);
            FieldDescriptor.checkFieldName(sourceField.trim());
            sourceRole.setCMRField(sourceField.trim());
            if (sourceFieldType != null) {
                sourceRole.setCMRFieldType(sourceFieldType.trim());
            }
            sinkRole.setPersistenceDescriptor(((EjbCMPEntityDescriptor)sink).getPersistenceDescriptor());
            sinkRole.setPartner(sourceRole);
            if (sinkField != null) {
                FieldDescriptor.checkFieldName(sinkField.trim());
                sinkRole.setCMRField(sinkField.trim());
            }
            if (sinkFieldType != null) {
                sinkRole.setCMRFieldType(sinkFieldType.trim());
            }
            if (sourceCascade != null && sourceCascade.equals("true")) {
                sourceRole.setCascadeDelete(true);
            }
            if (sinkCascade != null && sinkCascade.equals("true")) {
                sinkRole.setCascadeDelete(true);
            }
            if (multiplicity.equals("ONE-ONE")) {
                sourceRole.setIsMany(false);
                sinkRole.setIsMany(false);
            } else if (multiplicity.equals("ONE-MANY")) {
                sourceRole.setIsMany(false);
                sinkRole.setIsMany(true);
            } else if (multiplicity.equals("MANY-ONE")) {
                sourceRole.setIsMany(true);
                sinkRole.setIsMany(false);
            } else if (multiplicity.equals("MANY-MANY")) {
                sourceRole.setIsMany(true);
                sinkRole.setIsMany(true);
            }
            if (isBidir.equals("true")) {
                rd.setIsBidirectional(true);
            }
            ejbBundleDescriptor.addRelationship(rd);
            ++i2;
        }
    }

    private static void help() {
        System.out.println("Usage:- ");
        System.out.println("<propsfilename> <codebase> <applicationxmlfilenameForOutput> optional-ejb-bundle-xml-filename optional-runtime-filename");
        System.out.println("NB: The bean classes MUST be findable from the codebase. ");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

