/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.Resource;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ResourceCache {
    private Hashtable resources = new Hashtable();
    private int count;

    public ResourceCache(int count) {
        this.count = count;
    }

    public Object getResource(Object name) throws Exception {
        Object resource = null;
        Vector<Resource> list = null;
        Resource r2 = null;
        Hashtable hashtable = this.resources;
        synchronized (hashtable) {
            list = (Vector<Resource>)this.resources.get(name);
            if (list == null) {
                list = new Vector<Resource>(this.count);
                this.resources.put(name, list);
            }
        }
        boolean newR = false;
        Vector<Resource> vector = list;
        synchronized (vector) {
            while (resource == null) {
                int i2 = 0;
                while (i2 < list.size()) {
                    r2 = (Resource)list.elementAt(i2);
                    if (r2.isAvailable()) {
                        r2.markInUse();
                        resource = r2.getResource();
                        break;
                    }
                    ++i2;
                }
                if (resource != null) continue;
                if (list.size() < this.count) {
                    r2 = new Resource();
                    list.addElement(r2);
                    newR = true;
                    break;
                }
                if (newR) continue;
                list.wait();
            }
        }
        if (newR) {
            try {
                resource = this.createResource(name);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
            Vector<Resource> vector2 = list;
            synchronized (vector2) {
                r2.setResource(resource);
                r2.markInUse();
            }
        }
        return resource;
    }

    public void returnResource(Object name, Object oldResource, Object newResource) {
        Resource r2 = null;
        Vector list = (Vector)this.resources.get(name);
        if (list != null) {
            Vector vector = list;
            synchronized (vector) {
                int i2 = 0;
                while (i2 < list.size()) {
                    r2 = (Resource)list.elementAt(i2);
                    if (r2.getResource() == oldResource) {
                        r2.setResource(newResource);
                        r2.markAvailable();
                        list.notifyAll();
                        break;
                    }
                    ++i2;
                }
            }
        }
    }

    public abstract Object createResource(Object var1) throws Exception;
}

