/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.Semaphore;

public class SemaphoreImpl
implements Semaphore {
    private long numPermits_;

    public SemaphoreImpl(long initialPermits) {
        this.numPermits_ = initialPermits;
    }

    public synchronized void release() {
        ++this.numPermits_;
        this.notify();
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        SemaphoreImpl semaphoreImpl = this;
        synchronized (semaphoreImpl) {
            try {
                while (this.numPermits_ <= 0L) {
                    this.wait();
                }
                --this.numPermits_;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }
}

