/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.JMSClient;
import com.sun.jms.JMSConstants;
import com.sun.jms.JMSService;
import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.client.InitialClientContext;
import com.sun.jms.client.JMSClientImpl;
import com.sun.jms.client.JMSXAQueueConnectionImpl;
import com.sun.jms.client.JMSXATopicConnectionImpl;
import com.sun.jms.client.QueueConnectionImpl;
import com.sun.jms.client.TopicConnectionImpl;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class ConnectionFactoryImpl
implements ConnectionFactory,
Serializable,
JMSConstants {
    public static Logger logger = Log.getLogger(0);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    private String serverURL;
    private boolean useRMIIIOP = true;
    private String defaultClientId;
    protected final transient String USERNAME;
    protected final transient String PASSWORD;
    protected transient JMSService service = null;
    protected transient JMSClient client = null;
    protected transient String factoryID;
    private transient InitialClientContext initialClientCtx = null;
    private transient HashMap connectionHashMap = null;
    static /* synthetic */ Class class$com$sun$jms$JMSService;

    public ConnectionFactoryImpl(String url) {
        this.USERNAME = null;
        this.PASSWORD = null;
        this.serverURL = url;
        JMSProperties props = JMSProperties.getInstance();
        String transportPref = props.getProperty("com.sun.jms.client.transport_preference");
        if (transportPref != null && transportPref.equalsIgnoreCase("JRMP")) {
            this.useRMIIIOP = false;
            logger.finest("\tConnectionFactoryImpl: using JRMP transport");
        } else {
            this.useRMIIIOP = true;
            logger.finest("\tConnectionFactoryImpl: using IIOP transport");
        }
    }

    public ConnectionFactoryImpl() {
        this.USERNAME = null;
        this.PASSWORD = null;
        this.useRMIIIOP = true;
        this.setServerURL("localhost");
    }

    public boolean matches(ConnectionFactoryImpl other) {
        return other.getClientID().equals(this.getClientID()) && other.getServerURL().equals(this.getServerURL());
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String url) {
        if (url == null || url.equals("localhost")) {
            try {
                this.serverURL = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e10) {
                logger.warning(resource.getString("connectionfactoryimpl.defaulting_to_localhost"));
                this.serverURL = "localhost";
            }
        } else {
            this.serverURL = url;
        }
    }

    public void setTransport(String transport) throws JMSException {
        this.useRMIIIOP = transport == null || transport.equalsIgnoreCase("rmiiiop");
    }

    public String getTransport() {
        return this.useRMIIIOP ? "rmiiiop" : "rmijrmp";
    }

    public void setClientID(String clientId) {
        this.defaultClientId = clientId;
    }

    public String getClientID() {
        return this.defaultClientId;
    }

    private boolean isRemoteReferenceStale() {
        boolean retValue = false;
        if (this.service == null) {
            retValue = true;
        } else {
            try {
                this.service.ping();
            }
            catch (RemoteException re) {
                retValue = true;
            }
        }
        return retValue;
    }

    public synchronized void establishRemoteReferences() {
        try {
            this.service = this.lookupService();
            this.client = new JMSClientImpl(this.service, this, this.useRMIIIOP);
            String appname = JMSProperties.getInstance().getProperty("com.sun.jms.client.AppName", "");
            this.factoryID = this.service.registerClient(appname, this.client);
        }
        catch (Exception e10) {
            logger.severe(MessageFormat.format(resource.getString("connectionfactoryimpl.failed_to_connect"), e10.toString()));
        }
    }

    private JMSService lookupService() throws Exception {
        JMSService service = null;
        String serviceName = this.serverURL + ".com.sun.jms.service.JMSService";
        if (this.useRMIIIOP) {
            InitialContext initialNamingContext = InitialClientContext.getInstance().getInternalContext();
            String iiopServiceName = serviceName + "." + "IIOP";
            service = (JMSService)PortableRemoteObject.narrow((Object)initialNamingContext.lookup(iiopServiceName), (Class)(class$com$sun$jms$JMSService == null ? (class$com$sun$jms$JMSService = ConnectionFactoryImpl.class$("com.sun.jms.JMSService")) : class$com$sun$jms$JMSService));
        } else {
            String jrmpServiceName = serviceName + "." + "JRMP";
            InitialContext initialNamingContext = InitialClientContext.getInstance().getExternalContext();
            service = (JMSService)initialNamingContext.lookup(jrmpServiceName);
        }
        return service;
    }

    public JMSService getJMSService() {
        if (this.service == null || this.isRemoteReferenceStale()) {
            this.establishRemoteReferences();
        }
        return this.service;
    }

    public String getFactoryID() {
        return this.factoryID;
    }

    protected ConnectionImpl createConnection(int connectionType, String username, String password) throws JMSException {
        if (this.initialClientCtx == null) {
            this.initialClientCtx = InitialClientContext.getInstance();
        }
        if (this.connectionHashMap == null) {
            this.connectionHashMap = new HashMap(11);
        }
        if (this.isRemoteReferenceStale()) {
            this.establishRemoteReferences();
        }
        ConnectionImpl c10 = null;
        if (connectionType == 0) {
            c10 = new QueueConnectionImpl(username, password, this);
        } else if (connectionType == 1) {
            c10 = new TopicConnectionImpl(username, password, this);
        } else if (connectionType == 2) {
            c10 = new JMSXAQueueConnectionImpl(username, password, this);
        } else if (connectionType == 3) {
            c10 = new JMSXATopicConnectionImpl(username, password, this);
        }
        this.addConnection(c10.getConnectionID(), c10);
        c10.invokeRemoteCreateConnection(this.defaultClientId);
        return c10;
    }

    public void addConnection(int id, ConnectionImpl connection) {
        HashMap hashMap = this.connectionHashMap;
        synchronized (hashMap) {
            this.connectionHashMap.put(new Integer(id), connection);
        }
    }

    public ConnectionImpl getConnection(int id) {
        HashMap hashMap = this.connectionHashMap;
        synchronized (hashMap) {
            ConnectionImpl connectionImpl = (ConnectionImpl)this.connectionHashMap.get(new Integer(id));
            return connectionImpl;
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void removeConnection(int id) {
        block13: {
            this.connectionHashMap.remove(new Integer(id));
            if (this.connectionHashMap.isEmpty()) {
                if (logger.isLogging(7)) {
                    logger.finest("-- service.deregisterClient() with factoryID = " + this.factoryID);
                }
                this.service.deregisterClient(this.factoryID);
                this.service = null;
                Object var4_2 = null;
                try {
                    if (this.client != null && this.useRMIIIOP) {
                        logger.finest("unexporting client interface...");
                        PortableRemoteObject.unexportObject((Remote)this.client);
                        this.client = null;
                    }
                    break block13;
                }
                catch (NoSuchObjectException nsoe) {
                    logger.finest("-- couldn't find client interface!");
                }
                break block13;
                {
                    catch (Exception e10) {
                        logger.finest(e10);
                        Object var4_3 = null;
                        try {
                            if (this.client != null && this.useRMIIIOP) {
                                logger.finest("unexporting client interface...");
                                PortableRemoteObject.unexportObject((Remote)this.client);
                                this.client = null;
                            }
                            break block13;
                        }
                        catch (NoSuchObjectException nsoe) {
                            logger.finest("-- couldn't find client interface!");
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        if (this.client != null && this.useRMIIIOP) {
                            logger.finest("unexporting client interface...");
                            PortableRemoteObject.unexportObject((Remote)this.client);
                            this.client = null;
                        }
                    }
                    catch (NoSuchObjectException nsoe) {
                        logger.finest("-- couldn't find client interface!");
                    }
                    throw throwable;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

