/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.TopicImpl;
import com.sun.jms.spi.DurableSubscription;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.io.Serializable;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;

public class DurableSubscriptionDescriptor
implements DurableSubscription,
Serializable {
    static Logger logger = Log.getLogger(0);
    private String clientID;
    private String subscriptionName;
    private String selector;
    private String topicName;
    private boolean isActive;
    private TopicConnectionFactory connectionFactory;

    public DurableSubscriptionDescriptor(String clientID, String subscriptionName, String selector, String topicName, boolean isActive, TopicConnectionFactory connectionFactory) {
        this.clientID = clientID;
        this.subscriptionName = subscriptionName;
        this.selector = selector == null ? "" : selector;
        this.topicName = topicName;
        this.isActive = isActive;
        this.connectionFactory = connectionFactory;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean getActive() {
        return this.isActive;
    }

    public String toString() {
        return "DurableSubscription: clientID = '" + this.clientID + "' subscriptionName = '" + this.subscriptionName + "' selector = '" + this.selector + "' topicName = '" + this.topicName + "' isActive = " + this.isActive;
    }

    public boolean equals(DurableSubscriptionDescriptor other) {
        boolean result = true;
        int TRACE_LEVEL = 10;
        if (other == null) {
            if (logger.isLogging(7)) {
                logger.finest("DurableSubscription.equal() == false:  other == null");
            }
            result = false;
        } else if (!this.clientID.equals(other.getClientID())) {
            if (logger.isLogging(7)) {
                logger.finest("DurableSubscription.equal() == false: different clientIDs: this=" + this.clientID + " other=" + other.getClientID());
            }
            result = false;
        } else if (!this.subscriptionName.equals(other.getSubscriptionName())) {
            if (logger.isLogging(7)) {
                logger.finest("DurableSubscription.equal() == false: different subscriptionNames: this=" + this.clientID + " other=" + other.getSubscriptionName());
            }
            result = false;
        } else if (!this.selector.equals(other.getSelector())) {
            if (logger.isLogging(7)) {
                logger.finest("DurableSubscription.equal() == false: different selectors: this=" + this.getSelector() + " other=" + other.getSelector());
            }
            result = false;
        } else if (!this.topicName.equals(other.getTopicName())) {
            if (logger.isLogging(7)) {
                logger.finest("DurableSubscription.equal() == false: different topicName: this=" + this.topicName + " other=" + other.getTopicName());
            }
            result = false;
        }
        return result;
    }

    public Topic getTopic() {
        return new TopicImpl(this.topicName);
    }

    public TopicConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public String getMessageSelector() {
        return this.getSelector();
    }
}

