/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.MessageImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage,
Serializable {
    private static final long serialVersionUID = 1L;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("buf", array$B == null ? (array$B = StreamMessageImpl.class$("[B")) : array$B)};
    public static final byte UNKNOWN_TYPECODE = 0;
    public static final byte BOOLEAN_TYPE = 1;
    public static final byte BYTE_TYPE = 2;
    public static final byte CHAR_TYPE = 3;
    public static final byte DOUBLE_TYPE = 4;
    public static final byte FLOAT_TYPE = 5;
    public static final byte INT_TYPE = 6;
    public static final byte LONG_TYPE = 7;
    public static final byte SHORT_TYPE = 8;
    public static final byte STRING_TYPE = 9;
    public static final byte BYTES_TYPE = 10;
    public static final byte NULL_OBJECT = 11;
    public static final byte OBJECT_TYPE = 12;
    private static final String[] typeCodeStrings = new String[]{"invalid type code", "boolean", "byte", "char", "double", "float", "integer", "long", "short", "String", "byte array", "null object", "object"};
    byte[] buf;
    transient byte[] deliveredBuf;
    transient ByteArrayInputStream bais;
    transient ByteArrayOutputStream baos;
    transient DataInputStream dis;
    transient DataOutputStream dos;
    private transient boolean first_time_readBytes = true;
    private transient int available_bytes = 0;
    private static final int READ_LIMIT = Integer.MAX_VALUE;
    static /* synthetic */ Class array$B;

    private DataInputStream getDis() {
        if (this.dis == null) {
            this.bais = new ByteArrayInputStream(this.buf);
            this.dis = new DataInputStream(this.bais);
        }
        return this.dis;
    }

    public StreamMessageImpl() {
        this.init();
    }

    private void init() {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
        }
        this.buf = new byte[0];
        this.bais = null;
        this.dis = null;
    }

    public StreamMessageImpl(StreamMessage msg) throws JMSException {
        super(msg);
        this.init();
        msg.reset();
        try {
            while (true) {
                Object obj = msg.readObject();
                this.writeObject(obj);
            }
        }
        catch (MessageEOFException messageEOFException) {
            return;
        }
    }

    public MessageImpl getDeliveredMessage() {
        try {
            this.reset();
        }
        catch (JMSException e10) {
            MessageImpl.logger.warning(e10);
        }
        if (this.modifiedAfterDelivery()) {
            StreamMessageImpl sm = (StreamMessageImpl)super.getDeliveredMessage();
            sm.buf = this.deliveredBuf;
            return sm;
        }
        return this;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isBodyModifiable()) {
            if (this.dos != null) {
                this.dos.flush();
            }
            if (this.baos != null) {
                this.buf = this.baos.toByteArray();
            }
        }
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.dis = null;
        this.bais = null;
        if (this.buf == null) {
            this.buf = new byte[0];
        }
        try {
            this.reset();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private byte getType() throws IOException {
        return this.getDis().readByte();
    }

    private int getBytesLength() throws IOException {
        return this.getDis().readInt();
    }

    private void handleNumberFormatException(NumberFormatException e12) throws JMSException {
        try {
            this.getDis().reset();
        }
        catch (IOException e22) {
            throw new JMSException(resource.getString("streammessageimpl.ioexception_occurred_when_resetting_pointer"));
        }
        throw e12;
    }

    private void resetPointer() throws JMSException {
        try {
            this.getDis().reset();
        }
        catch (IOException e10) {
            throw new JMSException(resource.getString("streammessageimpl.ioexception_occurred_when_resetting_pointer"));
        }
    }

    public boolean readBoolean() throws JMSException {
        boolean ret = false;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(1);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 1: {
                    ret = this.getDis().readBoolean();
                    break;
                }
                case 9: {
                    String s2 = this.getDis().readUTF();
                    ret = Boolean.valueOf(s2);
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public byte readByte() throws JMSException {
        byte ret = 0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(2);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 2: {
                    ret = this.getDis().readByte();
                    break;
                }
                case 9: {
                    String s2 = this.getDis().readUTF();
                    try {
                        ret = Byte.valueOf(s2);
                    }
                    catch (NumberFormatException e10) {
                        this.handleNumberFormatException(e10);
                    }
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public short readShort() throws JMSException {
        short ret = 0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(8);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 2: {
                    ret = this.getDis().readByte();
                    break;
                }
                case 8: {
                    ret = this.getDis().readShort();
                    break;
                }
                case 9: {
                    String s2 = this.getDis().readUTF();
                    try {
                        ret = Short.valueOf(s2);
                    }
                    catch (NumberFormatException e10) {
                        this.handleNumberFormatException(e10);
                    }
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public char readChar() throws JMSException {
        char ret = '\u0000';
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(3);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 3: {
                    ret = this.getDis().readChar();
                    break;
                }
                case 11: {
                    throw new NullPointerException(resource.getString("streammessageimpl.attempted_to_read_null_value_as_char"));
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public int readInt() throws JMSException {
        int ret = 0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(6);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 2: {
                    ret = this.getDis().readByte();
                    break;
                }
                case 8: {
                    ret = this.getDis().readShort();
                    break;
                }
                case 6: {
                    ret = this.getDis().readInt();
                    break;
                }
                case 9: {
                    String s2 = this.getDis().readUTF();
                    try {
                        ret = Integer.valueOf(s2);
                    }
                    catch (NumberFormatException e10) {
                        this.handleNumberFormatException(e10);
                    }
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public long readLong() throws JMSException {
        long ret = 0L;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(7);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 2: {
                    ret = this.getDis().readByte();
                    break;
                }
                case 8: {
                    ret = this.getDis().readShort();
                    break;
                }
                case 6: {
                    ret = this.getDis().readInt();
                    break;
                }
                case 7: {
                    ret = this.getDis().readLong();
                    break;
                }
                case 9: {
                    String s2 = this.getDis().readUTF();
                    try {
                        ret = Long.valueOf(s2);
                    }
                    catch (NumberFormatException e10) {
                        this.handleNumberFormatException(e10);
                    }
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public float readFloat() throws JMSException {
        float ret = 0.0f;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(5);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 5: {
                    ret = this.getDis().readFloat();
                    break;
                }
                case 9: {
                    String s2 = this.getDis().readUTF();
                    try {
                        ret = Float.valueOf(s2).floatValue();
                    }
                    catch (NumberFormatException e10) {
                        this.handleNumberFormatException(e10);
                    }
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public double readDouble() throws JMSException {
        double ret = 0.0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(4);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 5: {
                    ret = this.getDis().readFloat();
                    break;
                }
                case 4: {
                    ret = this.getDis().readDouble();
                    break;
                }
                case 9: {
                    String s2 = this.getDis().readUTF();
                    try {
                        ret = Double.valueOf(s2);
                    }
                    catch (NumberFormatException e10) {
                        this.handleNumberFormatException(e10);
                    }
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public String readString() throws JMSException {
        String ret = null;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(9);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 1: {
                    ret = String.valueOf(this.getDis().readBoolean());
                    break;
                }
                case 2: {
                    ret = String.valueOf(this.getDis().readByte());
                    break;
                }
                case 8: {
                    ret = String.valueOf(this.getDis().readShort());
                    break;
                }
                case 3: {
                    ret = String.valueOf(this.getDis().readChar());
                    break;
                }
                case 6: {
                    ret = String.valueOf(this.getDis().readInt());
                    break;
                }
                case 7: {
                    ret = String.valueOf(this.getDis().readLong());
                    break;
                }
                case 5: {
                    ret = String.valueOf(this.getDis().readFloat());
                    break;
                }
                case 4: {
                    ret = String.valueOf(this.getDis().readDouble());
                    break;
                }
                case 9: {
                    ret = this.getDis().readUTF();
                    break;
                }
                case 11: {
                    ret = null;
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    private void checkForOutstandingReadBytes(int type) throws MessageFormatException {
        if (!this.first_time_readBytes && this.available_bytes > 0) {
            throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_during_readbytes"), this.typeCodeToString(type), new Integer(this.available_bytes)));
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        int ret = -1;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            if (this.first_time_readBytes) {
                this.getDis().mark(Integer.MAX_VALUE);
                byte type = this.getType();
                if (type != 10) {
                    if (type == 11) {
                        return -1;
                    }
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
                this.available_bytes = this.getBytesLength();
                if (this.available_bytes == 0) {
                    return 0;
                }
            } else if (this.available_bytes == 0) {
                this.first_time_readBytes = true;
                return -1;
            }
            if (value.length > this.available_bytes) {
                ret = this.getDis().read(value, 0, this.available_bytes);
                this.available_bytes = 0;
                this.first_time_readBytes = true;
            } else {
                ret = this.getDis().read(value, 0, value.length);
                this.available_bytes -= value.length;
                this.first_time_readBytes = false;
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public Object readObject() throws JMSException {
        Object ret = null;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        this.checkForOutstandingReadBytes(12);
        try {
            this.getDis().mark(Integer.MAX_VALUE);
            byte type = this.getType();
            switch (type) {
                case 1: {
                    ret = new Boolean(this.getDis().readBoolean());
                    break;
                }
                case 2: {
                    ret = new Byte(this.getDis().readByte());
                    break;
                }
                case 8: {
                    ret = new Short(this.getDis().readShort());
                    break;
                }
                case 3: {
                    ret = new Character(this.getDis().readChar());
                    break;
                }
                case 6: {
                    ret = new Integer(this.getDis().readInt());
                    break;
                }
                case 7: {
                    ret = new Long(this.getDis().readLong());
                    break;
                }
                case 5: {
                    ret = new Float(this.getDis().readFloat());
                    break;
                }
                case 4: {
                    ret = new Double(this.getDis().readDouble());
                    break;
                }
                case 9: {
                    ret = this.getDis().readUTF();
                    break;
                }
                case 10: {
                    int bytesLength = this.getBytesLength();
                    byte[] ba2 = new byte[bytesLength];
                    ret = ba2;
                    int n2 = this.getDis().read(ba2, 0, bytesLength);
                    if (n2 != bytesLength) {
                        throw new EOFException("");
                    }
                    this.first_time_readBytes = true;
                    this.available_bytes = 0;
                    break;
                }
                case 11: {
                    ret = null;
                    break;
                }
                default: {
                    this.resetPointer();
                    throw new MessageFormatException(MessageFormat.format(resource.getString("streammessageimpl.invalid_type_conversion"), this.typeCodeToString(type)));
                }
            }
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("streammessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(1);
            this.dos.writeBoolean(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(2);
            this.dos.writeByte(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeShort(short value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(8);
            this.dos.writeShort(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeChar(char value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(3);
            this.dos.writeChar(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeInt(int value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(6);
            this.dos.writeInt(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeLong(long value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(7);
            this.dos.writeLong(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(5);
            this.dos.writeFloat(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(4);
            this.dos.writeDouble(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeString(String value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            if (value != null) {
                this.dos.writeByte(9);
                this.dos.writeUTF(value);
            } else {
                this.writeNull();
            }
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(10);
            this.dos.writeInt(length);
            this.dos.write(value, offset, length);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value == null) {
            this.writeNull();
        } else {
            throw new MessageFormatException(resource.getString("streammessageimpl.invalid_type"));
        }
    }

    private void writeNull() throws JMSException {
        try {
            this.dos.writeByte(11);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException(ioe.getMessage());
            jmsEx.setLinkedException(ioe);
            throw jmsEx;
        }
    }

    public void reset() throws JMSException {
        this.dis = null;
        this.bais = null;
        this.first_time_readBytes = true;
        this.setBodyModifiable(false);
    }

    public void setBodyModifiable(boolean state) {
        super.setBodyModifiable(state);
        if (!state) {
            try {
                if (this.dos != null) {
                    this.dos.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.baos != null) {
                this.buf = this.baos.toByteArray();
                this.baos = null;
            }
            if (this.buf == null) {
                this.buf = new byte[0];
            }
        }
    }

    public void clearBody() throws JMSException {
        if (this.hasBeenDelivered() && !this.isBodyModifiable()) {
            this.deliveredBuf = this.buf;
        }
        super.clearBody();
        this.init();
    }

    public Object clone() {
        StreamMessageImpl msg = (StreamMessageImpl)super.clone();
        if (this.isBodyModifiable()) {
            this.buf = new byte[0];
            msg.baos = new ByteArrayOutputStream();
            msg.dos = new DataOutputStream(msg.baos);
            if (this.baos != null) {
                try {
                    msg.dos.write(this.baos.toByteArray());
                }
                catch (IOException iOException) {}
            }
        } else {
            msg.bais = null;
            msg.dis = null;
        }
        return msg;
    }

    public String toString() {
        return super.toString() + ": contains ... ";
    }

    public String typeCodeToString(int typeCode) {
        try {
            return typeCodeStrings[typeCode];
        }
        catch (Throwable t2) {
            return typeCodeStrings[0];
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

