/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.MessageImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public class TextMessageImpl
extends MessageImpl
implements TextMessage,
Serializable {
    private static final long serialVersionUID = 1L;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    String body;
    transient String deliveredBody;

    public TextMessageImpl() {
    }

    public TextMessageImpl(TextMessage msg) throws JMSException {
        super(msg);
        String text = "";
        try {
            text = msg.getText();
        }
        catch (JMSException e10) {
            MessageImpl.logger.warning(e10);
        }
        this.setText(text);
    }

    public MessageImpl getDeliveredMessage() {
        if (this.modifiedAfterDelivery()) {
            TextMessageImpl tm = (TextMessageImpl)super.getDeliveredMessage();
            tm.body = this.deliveredBody;
            return tm;
        }
        return this;
    }

    public void setText(String string) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        this.body = new String(string);
    }

    public String getText() throws JMSException {
        return this.body;
    }

    public void clearBody() throws JMSException {
        if (this.hasBeenDelivered() && !this.isBodyModifiable()) {
            this.deliveredBody = this.body;
        }
        super.clearBody();
        this.body = null;
    }

    public String toString() {
        return super.toString() + ": " + this.body;
    }

    public String getBodyAsString() {
        return this.body;
    }
}

