/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.admin;

import com.sun.jms.ConnectionFactoryImpl;
import com.sun.jms.DestinationImpl;
import com.sun.jms.DurableSubscriptionDescriptor;
import com.sun.jms.JMSConstants;
import com.sun.jms.JMSService;
import com.sun.jms.JMSXAQueueConnectionFactoryImpl;
import com.sun.jms.JMSXATopicConnectionFactoryImpl;
import com.sun.jms.MessageImpl;
import com.sun.jms.QueueConnectionFactoryImpl;
import com.sun.jms.TopicConnectionFactoryImpl;
import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.client.InitialClientContext;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.service.InitialServiceContext;
import com.sun.jms.service.selector.JMSSelector;
import com.sun.jms.spi.DurableSubscription;
import com.sun.jms.spi.JMSAdmin;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class Administrator
implements JMSAdmin,
JMSConstants {
    public static final Logger logger = Log.getLogger(4);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.admin.LocalStrings");
    private static Context jndiContext;
    private TopicConnectionFactory tConnFactory;
    private TopicConnection tConnection;
    private TopicSession tSession;
    private QueueConnectionFactory qConnFactory;
    private QueueConnection qConnection;
    private QueueSession qSession;
    private JMSService service;
    private JMSSelector jmsSelector;
    public static final String JMS_ADMIN_COMMANDLINE = "JMSAdmin";
    static Administrator instance;
    static /* synthetic */ Class class$com$sun$jms$JMSService;

    public static void stop(String url, boolean exitVM) throws JMSException, RemoteException {
        JMSService service = Administrator.lookupService(url);
        service.stop(exitVM);
    }

    public static Administrator getInstance() throws JMSException {
        if (instance == null) {
            instance = new Administrator();
        }
        return instance;
    }

    private Administrator() {
        instance = this;
        this.setClientName(JMS_ADMIN_COMMANDLINE);
    }

    public Administrator(String serverURL, String user, String password) throws JMSException {
        QueueConnectionFactoryImpl qcfi = new QueueConnectionFactoryImpl();
        qcfi.setServerURL(serverURL);
        qcfi.setTransport("rmiiiop");
        this.qConnFactory = qcfi;
        TopicConnectionFactoryImpl tcfi = new TopicConnectionFactoryImpl();
        tcfi.setServerURL(serverURL);
        tcfi.setTransport("rmiiiop");
        this.tConnFactory = tcfi;
    }

    public JMSService getJMSService() {
        if (this.service == null) {
            this.service = Administrator.lookupService("localhost");
        }
        return this.service;
    }

    public TopicSession getTopicSession() {
        if (this.tSession == null) {
            try {
                this.tSession = this.getTopicConnection().createTopicSession(false, 1);
                this.service = ((SessionImpl)((Object)this.tSession)).getJMSService();
            }
            catch (Exception e10) {
                logger.severe(e10);
            }
        }
        return this.tSession;
    }

    public QueueSession getQueueSession() {
        if (this.qSession == null) {
            try {
                this.qSession = this.getQueueConnection().createQueueSession(false, 1);
                this.service = ((SessionImpl)((Object)this.qSession)).getJMSService();
            }
            catch (Exception e10) {
                logger.severe(e10);
            }
        }
        return this.qSession;
    }

    private static Context getJndiContext() {
        InitialContext jndiContext = null;
        try {
            jndiContext = new InitialContext();
            return jndiContext;
        }
        catch (NamingException e10) {
            logger.severe(MessageFormat.format(resource.getString("administrator.failed_to_get_jndi_context"), e10.getMessage()));
            logger.severe(e10);
            System.exit(-1);
            return jndiContext;
        }
    }

    public Queue createQueue(String name, Map properties) throws JMSException {
        ConnectionImpl con = (ConnectionImpl)((Object)this.getQueueConnection());
        return (Queue)con.createServiceDestination(0, name, properties);
    }

    public Topic createTopic(String name, Map properties) throws JMSException {
        ConnectionImpl con = (ConnectionImpl)((Object)this.getTopicConnection());
        return (Topic)con.createServiceDestination(1, name, properties);
    }

    public Queue createQueue(String name) throws JMSException {
        return this.createQueue(name, null);
    }

    public Topic createTopic(String name) throws JMSException {
        return this.createTopic(name, null);
    }

    public void setClientName(String applicationClientName) {
        final String NAME = applicationClientName;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Properties props = new Properties(System.getProperties());
                ((Hashtable)props).put("com.sun.jms.client.AppName", NAME);
                System.setProperties(props);
                return null;
            }
        });
    }

    private static void initService() {
        InitialServiceContext.getInstance();
    }

    public void deleteDestination(String name) throws JMSException, RemoteException {
        ConnectionImpl con = (ConnectionImpl)((Object)this.getQueueConnection());
        this.getJMSService().deleteDestination(((ConnectionImpl)((Object)this.qConnection)).getFactoryID(), ((ConnectionImpl)((Object)this.qConnection)).getConnectionID(), name);
    }

    public Set getDestinations() throws JMSException, RemoteException {
        return new HashSet<Object>(Arrays.asList(this.getJMSService().getDestinations()));
    }

    public void listDestinations() throws JMSException, RemoteException {
        Set dests = this.getDestinations();
        Iterator iter = dests.iterator();
        while (iter.hasNext()) {
            DestinationImpl dest = (DestinationImpl)iter.next();
            System.out.println("Name= " + dest.getName() + " Type=" + dest.getClass().getName());
        }
    }

    public void spyOnDestinations() throws JMSException, RemoteException {
        Set dests = this.getDestinations();
        Iterator iter = dests.iterator();
        boolean hasTopics = false;
        while (iter.hasNext()) {
            DestinationImpl dest = (DestinationImpl)iter.next();
            if (dest instanceof Queue) {
                System.out.println("Name= " + dest.getName() + " Type=" + dest.getClass().getName());
                this.listMessages(dest.getName());
                continue;
            }
            this.getTopicSession().createSubscriber((Topic)((Object)dest)).setMessageListener(new SpyMessageListener((Topic)((Object)dest)));
            hasTopics = true;
        }
        if (hasTopics) {
            try {
                System.out.println("Hit return to stop monitoring msg delivery from topics");
                this.getTopicConnection().start();
                System.in.read();
            }
            catch (IOException io) {
                // empty catch block
            }
        }
    }

    public void listMessages(String queueName) throws JMSException, RemoteException {
        int count = 0;
        try {
            QueueSession session = this.getQueueSession();
            Enumeration msgs = session.createBrowser(session.createQueue(queueName)).getEnumeration();
            while (msgs.hasMoreElements()) {
                System.out.println("#" + String.valueOf(++count));
                this.printMessage((Message)msgs.nextElement());
            }
        }
        catch (Exception e10) {
            logger.warning(e10);
        }
        System.out.println("\n" + (count == 0 ? "NO" : String.valueOf(count)) + " messages were found on queue <" + queueName + ">");
    }

    public void printMessage(Message msg) {
        try {
            System.out.println("Class: " + msg.getClass().getName() + "\nID: " + msg.getJMSMessageID() + "\nPriority: " + msg.getJMSPriority());
            Enumeration props = msg.getPropertyNames();
            if (props.hasMoreElements()) {
                System.out.print("Properties: ");
                while (props.hasMoreElements()) {
                    String propName = String.valueOf(props.nextElement());
                    System.out.print("" + propName + " = " + msg.getStringProperty(propName) + (props.hasMoreElements() ? ", " : "\n"));
                }
            } else {
                System.out.print("Properties:  No Properties Found");
            }
            System.out.println("\nBody: " + msg.toString());
        }
        catch (Exception e10) {
            logger.warning(MessageFormat.format(resource.getString("administrator.error_printing_message"), e10.getMessage()));
        }
    }

    public void deleteAllDestinations() throws JMSException, RemoteException {
        Set dests = this.getDestinations();
        Iterator iter = dests.iterator();
        while (iter.hasNext()) {
            DestinationImpl dest = (DestinationImpl)iter.next();
            System.out.println("Deleting Name= " + dest.getName());
            this.deleteDestination(dest.getName());
        }
    }

    public void pingAllClients() throws JMSException, RemoteException {
        this.getJMSService().pingAllClients();
    }

    public void printDebugInfo() throws JMSException, RemoteException {
        this.getJMSService().printDebugInfo();
    }

    public MessageImpl getMessage(String msgId) throws JMSException {
        MessageImpl msg = null;
        try {
            msg = this.getJMSService().getMessage(msgId);
        }
        catch (RemoteException e10) {
            logger.warning(e10);
        }
        return msg;
    }

    private static void printUsage() {
        System.err.println("Usage: Administrator [-h] ");
        System.err.println("                     [-initService ");
        System.err.println("                     [-createQueue <queueName>] ");
        System.err.println("                     [-createTopic <topicName>] ");
        System.err.println("                     [-deleteDestination <destinationName>]");
        System.err.println("                     [-listDestinations]");
        System.err.println("                     [-spyOnDestinations]");
        System.err.println("                     [-deleteAllDestinations");
        System.err.println("                     [-stopService [<hostName>]]");
        System.err.println("                     [-listMessages [<queueName>]]");
        System.err.println("                     [-pingAllClients]");
        System.err.println("                     [-printDebugInfo]");
    }

    private static JMSService lookupService(String hostName) {
        JMSService service = null;
        try {
            if (hostName == null || hostName.length() == 0 || hostName.equalsIgnoreCase("localhost")) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            InitialContext initialNamingContext = InitialClientContext.getInstance().getInternalContext();
            String serviceName = hostName + ".com.sun.jms.service.JMSService";
            service = (JMSService)PortableRemoteObject.narrow((Object)initialNamingContext.lookup(serviceName + "." + "IIOP"), (Class)(class$com$sun$jms$JMSService == null ? (class$com$sun$jms$JMSService = Administrator.class$("com.sun.jms.JMSService")) : class$com$sun$jms$JMSService));
        }
        catch (Exception e10) {
            logger.severe(MessageFormat.format(resource.getString("administrator.unable_to_locate_service"), e10.getMessage()));
            System.exit(-1);
        }
        return service;
    }

    public static void main(String[] args) throws JMSException {
        Administrator admin = null;
        int exitStatus = 0;
        try {
            if (args.length == 0 || args[0].equals("-h") || args[0].equals("-help")) {
                Administrator.printUsage();
                System.exit(0);
            }
            if (args[0].equals("-initService")) {
                Administrator.initService();
                System.exit(0);
            }
            if (args[0].equals("-stopService")) {
                String hostName = "";
                if (args.length > 1) {
                    hostName = args[1];
                }
                Administrator.stop(hostName, true);
            }
            admin = Administrator.getInstance();
            int i2 = 0;
            while (i2 < args.length) {
                String destName;
                if (args[i2].equals("-createQueue") && i2 + 1 < args.length) {
                    destName = args[i2 + 1];
                    admin.createQueue(destName, null);
                    ++i2;
                } else if (args[i2].equals("-createTopic") && i2 + 1 < args.length) {
                    destName = args[i2 + 1];
                    admin.createTopic(destName, null);
                    ++i2;
                } else if (args[i2].equals("-deleteDestination") && i2 + 1 < args.length) {
                    destName = args[i2 + 1];
                    admin.deleteDestination(destName);
                    ++i2;
                } else if (args[i2].equals("-listDestinations")) {
                    admin.listDestinations();
                } else if (args[i2].equals("-spyOnDestinations")) {
                    admin.spyOnDestinations();
                } else if (args[i2].equals("-deleteAllDestinations")) {
                    admin.deleteAllDestinations();
                } else if (args[i2].equals("-listMessages") && i2 + 1 < args.length) {
                    destName = args[i2 + 1];
                    admin.listMessages(destName);
                    ++i2;
                } else if (args[i2].equals("-pingAllClients")) {
                    admin.pingAllClients();
                } else if (args[i2].equals("-printDebugInfo")) {
                    admin.printDebugInfo();
                } else {
                    System.err.println("ignoring unknown option: " + args[i2]);
                }
                ++i2;
            }
        }
        catch (RemoteException e10) {
            exitStatus = -1;
        }
        catch (JMSException e11) {
            exitStatus = -1;
        }
        if (admin != null) {
            admin.close();
        }
        System.exit(exitStatus);
    }

    public void close() throws JMSException {
        if (this.tConnection != null) {
            this.tConnection.close();
            this.tConnection = null;
        }
        if (this.qConnection != null) {
            this.qConnection.close();
            this.qConnection = null;
        }
    }

    public QueueConnectionFactory getQueueConnectionFactory() {
        if (this.qConnFactory == null) {
            try {
                this.qConnFactory = (QueueConnectionFactory)Administrator.getJndiContext().lookup("QueueConnectionFactory");
            }
            catch (Exception e10) {
                logger.severe(e10);
            }
        }
        return this.qConnFactory;
    }

    public TopicConnectionFactory getTopicConnectionFactory() {
        if (this.tConnFactory == null) {
            try {
                this.tConnFactory = (TopicConnectionFactory)Administrator.getJndiContext().lookup("TopicConnectionFactory");
            }
            catch (Exception e10) {
                logger.severe(e10);
            }
        }
        return this.tConnFactory;
    }

    public QueueConnection getQueueConnection() {
        if (this.qConnection == null) {
            try {
                this.qConnFactory = this.getQueueConnectionFactory();
                this.qConnection = this.qConnFactory.createQueueConnection();
            }
            catch (Exception e10) {
                logger.severe(e10);
            }
        }
        return this.qConnection;
    }

    public TopicConnection getTopicConnection() {
        if (this.tConnection == null) {
            try {
                this.tConnFactory = this.getTopicConnectionFactory();
                this.tConnection = this.tConnFactory.createTopicConnection();
            }
            catch (Exception e10) {
                logger.severe(e10);
            }
        }
        return this.tConnection;
    }

    public Destination createProviderDestination(String destinationName, int destinationType, Map properties) throws JMSException {
        Destination d10 = null;
        switch (destinationType) {
            case 0: {
                d10 = this.createQueue(destinationName, properties);
                break;
            }
            case 1: {
                d10 = this.createTopic(destinationName, properties);
                break;
            }
            default: {
                throw new JMSException(MessageFormat.format(resource.getString("administrator.invalid_destination_type"), new Integer(destinationType)));
            }
        }
        return d10;
    }

    public Set getDestinations(int destinationTypeFilter) throws JMSException {
        TreeSet<Destination> dests = null;
        try {
            dests = this.getDestinations();
        }
        catch (RemoteException re) {
            JMSException je = new JMSException(re.getMessage());
            je.setLinkedException(re);
            throw je;
        }
        Iterator iter = dests.iterator();
        dests = new TreeSet<Destination>();
        while (iter.hasNext()) {
            int currentDestType;
            Destination dest = (Destination)iter.next();
            if (destinationTypeFilter == 2) {
                dests.add(dest);
                continue;
            }
            int n2 = currentDestType = dest instanceof Queue ? 0 : 1;
            if (currentDestType != destinationTypeFilter) continue;
            dests.add(dest);
        }
        return dests;
    }

    public void deleteProviderDestination(String destinationName) throws JMSException {
        try {
            this.deleteDestination(destinationName);
        }
        catch (RemoteException re) {
            JMSException je = new JMSException(re.getMessage());
            je.setLinkedException(re);
            throw je;
        }
    }

    public QueueBrowser createQueueBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.getQueueSession().createBrowser(queue, messageSelector);
    }

    public ConnectionFactory createConnectionFactory(int connectionType, Map properties) throws JMSException {
        String theServerURL;
        ConnectionFactoryImpl cf2 = null;
        cf2 = connectionType == 0 ? new QueueConnectionFactoryImpl() : new TopicConnectionFactoryImpl();
        if (properties == null) {
            properties = new HashMap(0);
        }
        if ((theServerURL = (String)properties.get("url")) == null) {
            theServerURL = ((ConnectionFactoryImpl)((Object)this.tConnFactory)).getServerURL();
        }
        cf2.setServerURL(theServerURL);
        String transport = (String)properties.get("transport");
        if (transport == null) {
            transport = "rmiiiop";
        }
        cf2.setTransport(transport);
        cf2.setClientID(this.findClientID(null, properties));
        return cf2;
    }

    public Object createXAConnectionFactory(int connectionType, Map properties) throws JMSException {
        String theServerURL;
        ConnectionFactoryImpl xacf = null;
        xacf = connectionType == 0 ? new JMSXAQueueConnectionFactoryImpl() : new JMSXATopicConnectionFactoryImpl();
        if (properties == null) {
            properties = new HashMap(0);
        }
        if ((theServerURL = (String)properties.get("url")) == null) {
            theServerURL = ((ConnectionFactoryImpl)((Object)this.tConnFactory)).getServerURL();
        }
        xacf.setServerURL(theServerURL);
        String transport = (String)properties.get("transport");
        if (transport == null) {
            transport = "rmiiiop";
        }
        xacf.setTransport(transport);
        xacf.setClientID(this.findClientID(null, properties));
        return xacf;
    }

    public void validateJMSSelector(String selector) throws JMSException {
        Administrator administrator = this;
        synchronized (administrator) {
            if (this.jmsSelector == null) {
                this.jmsSelector = new JMSSelector(selector, new MessageImpl());
            } else {
                this.jmsSelector.setPattern(selector);
            }
        }
    }

    public Set getDurableSubscriptions() throws JMSException {
        Set set = null;
        try {
            set = this.getJMSService().getDurableSubscriptions(null, null);
        }
        catch (RemoteException e10) {
            logger.warning(e10);
        }
        return set;
    }

    public Set getDurableSubscriptions(Topic topic) throws InvalidDestinationException, JMSException {
        Set set = null;
        try {
            set = this.getJMSService().getDurableSubscriptions(topic, null);
        }
        catch (RemoteException e10) {
            logger.warning(e10);
        }
        return set;
    }

    public Set getDurableSubscriptions(TopicConnectionFactory connFactory) throws JMSException {
        Set set = null;
        try {
            set = this.getJMSService().getDurableSubscriptions(null, connFactory);
        }
        catch (RemoteException e10) {
            logger.warning(e10);
        }
        return set;
    }

    public DurableSubscription createDurableSubscription(String subscriptionName, TopicConnectionFactory connFactory, Topic topic, String messageSelector, Map properties) throws InvalidDestinationException, InvalidSelectorException, JMSException {
        DurableSubscriptionDescriptor dsd = null;
        try {
            TopicConnection tConn;
            String connID;
            boolean overWrite;
            String clientID = this.findClientID((TopicConnectionFactoryImpl)connFactory, properties);
            if (clientID == null || clientID.length() == 0) {
                throw new JMSException(resource.getString("administrator.clientID_must_be_set"));
            }
            Boolean val = null;
            if (properties != null && properties.get("overwrite") != null) {
                val = (Boolean)properties.get("overwrite");
                overWrite = val;
            } else {
                overWrite = false;
            }
            if (!overWrite && this.getJMSService().getDurableSubscription(clientID, subscriptionName) != null) {
                throw new JMSException(resource.getString("administrator.cannot_overwrite"));
            }
            if (connFactory == null) {
                connFactory = (TopicConnectionFactory)this.createConnectionFactory(1, properties);
                ((TopicConnectionFactoryImpl)connFactory).setClientID(clientID);
            }
            if ((connID = (tConn = connFactory.createTopicConnection()).getClientID()) == null) {
                tConn.setClientID(clientID);
            }
            TopicSession tSess = tConn.createTopicSession(false, 1);
            TopicSubscriber tSub = tSess.createDurableSubscriber(topic, subscriptionName, messageSelector, false);
            tSub.close();
            dsd = this.getJMSService().getDurableSubscription(clientID, subscriptionName);
        }
        catch (RemoteException e10) {
            logger.warning(e10);
        }
        return dsd;
    }

    public void deleteDurableSubscription(String subscriptionName, TopicConnectionFactory connFactory, Topic topic) throws InvalidDestinationException, JMSException {
        String clientID = this.findClientID((TopicConnectionFactoryImpl)connFactory, null);
        if (clientID == null) {
            throw new JMSException(resource.getString("administrator.cientID_must_be_set_in_fac"));
        }
        try {
            this.getJMSService().deleteDurableSubscription(clientID, subscriptionName);
        }
        catch (RemoteException e10) {
            logger.warning(e10);
        }
    }

    public void deleteDurableSubscription(DurableSubscription subscription) throws JMSException {
        String clientID = subscription.getClientID();
        String subscriptionName = subscription.getSubscriptionName();
        try {
            this.getJMSService().deleteDurableSubscription(clientID, subscriptionName);
        }
        catch (RemoteException e10) {
            logger.warning(e10);
        }
    }

    private String findClientID(TopicConnectionFactoryImpl factory, Map props) throws JMSException {
        String facID = null;
        String propsID = null;
        if (factory != null && factory.getClientID() != null) {
            facID = factory.getClientID();
        }
        if (props != null && (propsID = (String)props.get("clientId")) == null) {
            propsID = (String)props.get("clientID");
        }
        if (propsID != null && facID != null && !propsID.equals(facID)) {
            throw new JMSException("clientID specified in fac doesn't match id in props");
        }
        if (facID != null) {
            return facID;
        }
        return propsID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        instance = null;
    }

    static class SpyMessageListener
    implements MessageListener {
        final Topic destination;

        SpyMessageListener(Topic dest) {
            this.destination = dest;
            try {
                System.out.println("Creating MessageListener for topic " + this.destination.getTopicName());
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }

        public void onMessage(Message msg) {
            try {
                DateFormat df2 = DateFormat.getDateTimeInstance(3, 2);
                System.out.println(df2.format(new Date(msg.getJMSTimestamp())) + " delivered msg " + msg + " to subscribers of topic " + this.destination.getTopicName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

