/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.DestinationImpl;
import com.sun.jms.JMSService;
import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;

public class ConnectionConsumerImpl
implements ConnectionConsumer {
    private Destination destination = null;
    private String messageSelector;
    private ServerSessionPool sessionPool = null;
    private int maxMessages;
    private String subscriptionName;
    private ConnectionImpl parentConnection = null;
    private JMSService service = null;
    private String factoryID;
    private int myConnectionConsumerID;
    static Logger logger = Log.getLogger(2);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    ConnectionConsumerImpl(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, String subscriptionName, ConnectionImpl conn) {
        this.destination = destination;
        this.messageSelector = messageSelector;
        this.sessionPool = sessionPool;
        this.maxMessages = maxMessages;
        this.subscriptionName = subscriptionName;
        this.parentConnection = conn;
        this.service = this.parentConnection.getJMSService();
        this.factoryID = this.parentConnection.getFactoryID();
        this.myConnectionConsumerID = this.parentConnection.createConsumerID();
    }

    void invokeRemoteCreateConnectionConsumer() throws JMSException {
        try {
            if (logger.isLogging(6)) {
                logger.finer("invoking service.createConnectionConsumer");
            }
            this.service.createConnectionConsumer(this.factoryID, this.parentConnection.getConnectionID(), this.myConnectionConsumerID, ((DestinationImpl)this.destination).getName(), this.messageSelector, this.maxMessages, this.subscriptionName);
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(e10.getMessage());
            jmse.setLinkedException(e10);
            throw jmse;
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.sessionPool;
    }

    public void close() throws JMSException {
        this.close(true);
    }

    void close(boolean callServiceClose) throws JMSException {
        if (callServiceClose) {
            try {
                if (logger.isLogging(7)) {
                    logger.finest("closing: " + this.myConnectionConsumerID);
                }
                this.service.close(this.factoryID, this.parentConnection.getConnectionID(), -1, -1, this.myConnectionConsumerID);
            }
            catch (RemoteException re) {
                if (logger.isLogging(2)) {
                    logger.warning(MessageFormat.format(resource.getString("connectionconsumerimpl.error_closing_connection_consumer"), new Integer(this.myConnectionConsumerID)));
                    logger.warning(re);
                }
            }
            catch (Throwable t2) {
                logger.warning(t2);
            }
        }
    }

    public int getID() {
        return this.myConnectionConsumerID;
    }

    int getSessionForConnectionConsumer() throws JMSException {
        ServerSession serverSession = this.sessionPool.getServerSession();
        SessionImpl session = (SessionImpl)serverSession.getSession();
        session.setServerSession(serverSession);
        return session.getSessionID();
    }
}

