/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.ConnectionFactoryImpl;
import com.sun.jms.DestinationImpl;
import com.sun.jms.JMSConstants;
import com.sun.jms.JMSService;
import com.sun.jms.MessageImpl;
import com.sun.jms.QueueImpl;
import com.sun.jms.TopicImpl;
import com.sun.jms.client.ConnectionConsumerImpl;
import com.sun.jms.client.ConnectionMetaDataImpl;
import com.sun.jms.client.JMSClientImpl;
import com.sun.jms.client.QueueConnectionImpl;
import com.sun.jms.client.QueueSessionImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.client.TopicConnectionImpl;
import com.sun.jms.client.TopicSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import com.sun.jms.util.Waiter;
import com.sun.jms.util.WaiterManager;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

public class ConnectionImpl
implements Connection,
JMSConstants {
    JMSService service;
    private static ConnectionMetaData metaData = new ConnectionMetaDataImpl();
    ConnectionFactoryImpl parentConnectionFactory;
    private ExceptionListener exceptionListener;
    private HashMap sessionHashMap;
    private ArrayList sessionListeners;
    private LinkedList pendingExceptions;
    private boolean isStopped = true;
    private boolean isClosed = false;
    String factoryID;
    String clientID;
    static int connectionNumber = 0;
    int myConnectionID;
    private static int consumerID = 0;
    private LinkedList incomingMessageBuffer = null;
    private Waiter incomingMessageWaiter = null;
    private String username;
    private String password;
    private int connectionType;
    private HashMap connectionConsumerHashMap;
    private boolean allowSetClientID = true;
    static Logger logger = Log.getLogger(2);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    private boolean hadIncomingMessages() {
        return this.incomingMessageWaiter != null;
    }

    ConnectionImpl(String user, String pass, int ct2, ConnectionFactoryImpl parent) throws JMSException {
        this.parentConnectionFactory = parent;
        this.username = user;
        this.password = pass;
        this.connectionType = ct2;
        this.service = this.parentConnectionFactory.getJMSService();
        this.factoryID = this.parentConnectionFactory.getFactoryID();
        this.myConnectionID = ++connectionNumber;
        this.sessionHashMap = new HashMap(11);
        this.connectionConsumerHashMap = new HashMap(3);
    }

    private void initIncomingMessages() {
        this.incomingMessageBuffer = new LinkedList();
        this.incomingMessageWaiter = new Waiter(JMSClientImpl.clientThreadGroup, new WaiterManager(){

            public void activityDetected() {
                ConnectionImpl.this.processIncomingMessageBuffer();
            }
        }, "jms.client Connection.incomingWaiter." + this.getGlobalyUniqueId());
    }

    String getGlobalyUniqueId() {
        return this.factoryID + "." + this.myConnectionID;
    }

    public void invokeRemoteCreateConnection(String defaultClientID) throws JMSException {
        try {
            if (logger.isLogging(6)) {
                logger.finer("Calling service.createConnection()");
            }
            this.service.createConnection(this.factoryID, this.myConnectionID, this.username, this.password, this.connectionType, null, defaultClientID);
            if (defaultClientID != null && defaultClientID.length() > 0) {
                this.setClientIDInternal(defaultClientID);
            }
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(e10.getMessage());
            jmse.setLinkedException(e10);
            throw jmse;
        }
    }

    public Session createSession(int sessionType, boolean transacted, int acknowledgeMode, ConnectionImpl c10) throws JMSException {
        SessionImpl session = null;
        if (sessionType == 0) {
            session = new QueueSessionImpl(transacted, acknowledgeMode, (QueueConnectionImpl)c10);
        } else if (sessionType == 1) {
            session = new TopicSessionImpl(transacted, acknowledgeMode, (TopicConnectionImpl)c10);
        }
        this.addSession(session.getSessionID(), session);
        session.invokeRemoteCreateSession();
        this.allowSetClientID = false;
        return session;
    }

    public void sendMessage(int sessionID, int producerID, Message msg) throws JMSException {
        try {
            if (logger.isLogging(6)) {
                logger.finer("Calling service.sendMessage() with: factoryID = " + this.factoryID + " myConnectionID = " + this.myConnectionID + " sessionID = " + sessionID + " producerID = " + producerID);
            }
            this.service.sendMessage(this.factoryID, this.myConnectionID, sessionID, producerID, msg);
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(e10.getMessage());
            jmse.setLinkedException(e10);
            throw jmse;
        }
    }

    public int getConnectionID() {
        return this.myConnectionID;
    }

    public String getClientID() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("connectionimpl.getclientid_on_closed_connection"));
        }
        return this.clientID;
    }

    void setClientIDInternal(String clientID) throws JMSException {
        if (!this.allowSetClientID) {
            throw new IllegalStateException(resource.getString("connectionimpl.disallow_setclientid"));
        }
        this.clientID = clientID;
        this.allowSetClientID = false;
    }

    public void setClientID(String clientID) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("connectionimpl.setclientid_on_closed_connection"));
        }
        this.setClientIDInternal(clientID);
        try {
            if (logger.isLogging(6)) {
                logger.finer("Calling service.setClientID()");
            }
            this.service.setClientID(this.factoryID, this.myConnectionID, clientID);
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(e10.getMessage());
            if (e10.detail instanceof Exception) {
                jmse.setLinkedException((Exception)e10.detail);
            } else {
                jmse.setLinkedException(e10);
            }
            throw jmse;
        }
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("connectionimpl.getmetadata_on_closed_connection"));
        }
        return metaData;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("connectionimpl.setexceptionlistener_on_closed_connection"));
        }
        this.exceptionListener = listener;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("connectionimpl.getexceptionlistener_on_closed_connection"));
        }
        return this.exceptionListener;
    }

    public void start() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("connectionimpl.start_on_closed_connection"));
        }
        this.isStopped = false;
        ArrayList sessions = null;
        HashMap hashMap = this.sessionHashMap;
        synchronized (hashMap) {
            sessions = new ArrayList(this.sessionHashMap.values());
        }
        Iterator sessionIter = ((AbstractList)sessions).iterator();
        while (sessionIter.hasNext()) {
            SessionImpl session = (SessionImpl)sessionIter.next();
            session.start();
        }
        try {
            if (logger.isLogging(6)) {
                logger.finer("Calling service.setConnectionDeliveryMode()");
            }
            this.service.setMessageDelivery(this.factoryID, this.myConnectionID, -1, true);
        }
        catch (Exception e10) {
            logger.warning(e10);
        }
    }

    public void stop() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("connectionimpl.stop_on_closed_connection"));
        }
        this.isStopped = true;
        try {
            if (logger.isLogging(6)) {
                logger.finer("Calling service.setConnectionDeliveryMode()");
            }
            this.service.setMessageDelivery(this.factoryID, this.myConnectionID, -1, false);
            ArrayList sessions = null;
            HashMap hashMap = this.sessionHashMap;
            synchronized (hashMap) {
                sessions = new ArrayList(this.sessionHashMap.values());
            }
            Iterator sessionIter = ((AbstractList)sessions).iterator();
            while (sessionIter.hasNext()) {
                SessionImpl session = (SessionImpl)sessionIter.next();
                session.stop();
            }
        }
        catch (Exception e10) {
            logger.warning(e10);
        }
    }

    public void close() throws JMSException {
        if (!this.isClosed) {
            block6: {
                this.stop();
                if (this.hadIncomingMessages()) {
                    this.incomingMessageWaiter.stopRunning();
                }
                Collection sessions = this.sessionHashMap.values();
                Iterator sessionIter = sessions.iterator();
                while (sessionIter.hasNext()) {
                    SessionImpl session = (SessionImpl)sessionIter.next();
                    session.close(false);
                    sessionIter.remove();
                }
                Collection consumers = this.connectionConsumerHashMap.values();
                Iterator consumerIter = consumers.iterator();
                while (consumerIter.hasNext()) {
                    ConnectionConsumerImpl consumer = (ConnectionConsumerImpl)consumerIter.next();
                    consumer.close(false);
                    consumerIter.remove();
                }
                try {
                    this.service.close(this.factoryID, this.myConnectionID, -1, -1, -1);
                    this.parentConnectionFactory.removeConnection(this.getConnectionID());
                }
                catch (RemoteException re) {
                    if (!logger.isLogging(2)) break block6;
                    logger.warning(MessageFormat.format(resource.getString("connectionimpl.call_failed_ignoring_exception"), re.getMessage()));
                }
            }
            this.isClosed = true;
        }
    }

    protected void addSession(int sessionID, SessionImpl session) {
        HashMap hashMap = this.sessionHashMap;
        synchronized (hashMap) {
            this.sessionHashMap.put(new Integer(sessionID), session);
        }
    }

    protected SessionImpl getSession(int sessionID) {
        HashMap hashMap = this.sessionHashMap;
        synchronized (hashMap) {
            SessionImpl sessionImpl = (SessionImpl)this.sessionHashMap.get(new Integer(sessionID));
            return sessionImpl;
        }
    }

    public boolean isSessionClosed(int sessionID) {
        if (this.getSession(sessionID) == null) {
            return true;
        }
        return this.parentConnectionFactory.getConnection(this.getConnectionID()) == null;
    }

    protected void removeSession(int sessionID) {
        HashMap hashMap = this.sessionHashMap;
        synchronized (hashMap) {
            this.sessionHashMap.remove(new Integer(sessionID));
        }
    }

    protected void addConnectionConsumer(int connectionConsumerId, ConnectionConsumerImpl connectionConsumer) {
        HashMap hashMap = this.connectionConsumerHashMap;
        synchronized (hashMap) {
            this.connectionConsumerHashMap.put(new Integer(connectionConsumerId), connectionConsumer);
        }
    }

    protected void removeConnectionConsumer(int connectionConsumerId) {
        HashMap hashMap = this.connectionConsumerHashMap;
        synchronized (hashMap) {
            this.connectionConsumerHashMap.remove(new Integer(connectionConsumerId));
        }
    }

    protected ConnectionConsumerImpl getConnectionConsumer(int connectionConsumerId) {
        HashMap hashMap = this.connectionConsumerHashMap;
        synchronized (hashMap) {
            ConnectionConsumerImpl consumer;
            ConnectionConsumerImpl connectionConsumerImpl = consumer = (ConnectionConsumerImpl)this.connectionConsumerHashMap.get(new Integer(connectionConsumerId));
            return connectionConsumerImpl;
        }
    }

    public void deliverMessage(int sessionID, int messageConsumerID, Message msg) throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("Queueing incoming message");
        }
        if (!this.hadIncomingMessages()) {
            this.initIncomingMessages();
        }
        Waiter waiter = this.incomingMessageWaiter;
        synchronized (waiter) {
            this.incomingMessageBuffer.addLast(msg);
            this.incomingMessageWaiter.wakeup();
        }
    }

    void processIncomingMessageBuffer() {
        if (logger.isLogging(7)) {
            logger.finest("called");
        }
        while (!this.incomingMessageBuffer.isEmpty()) {
            MessageImpl msg = (MessageImpl)this.incomingMessageBuffer.removeFirst();
            int consumerID = msg.getConsumerID();
            SessionImpl s2 = (SessionImpl)msg.getSession();
            if (logger.isLogging(6)) {
                logger.finer("processing msg: " + msg);
            }
            try {
                s2.deliverMessage(consumerID, msg);
            }
            catch (Exception e10) {
                if (!logger.isLogging(2)) continue;
                logger.warning(e10);
            }
        }
    }

    public void deliverException(Exception ex2) {
        this.pendingExceptions.addLast(ex2);
    }

    public JMSService getJMSService() {
        return this.parentConnectionFactory.getJMSService();
    }

    public String getFactoryID() {
        return this.parentConnectionFactory.getFactoryID();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.parentConnectionFactory;
    }

    void clearSessionMessages(int clearSessionId) {
        if (this.hadIncomingMessages()) {
            Waiter waiter = this.incomingMessageWaiter;
            synchronized (waiter) {
                ListIterator iter = this.incomingMessageBuffer.listIterator(0);
                while (iter.hasNext()) {
                    MessageImpl msg = (MessageImpl)iter.next();
                    if (clearSessionId != msg.getSessionID()) continue;
                    iter.remove();
                }
            }
        }
    }

    Message receive(int sessionId, int consumerId, long timeout) throws JMSException {
        MessageImpl msg = null;
        try {
            msg = this.service.receive(this.factoryID, this.getConnectionID(), sessionId, consumerId, timeout);
            if (msg != null) {
                msg.setFactoryID(this.factoryID);
                msg.setConnectionID(this.getConnectionID());
                msg.setSessionID(sessionId);
                msg.setConsumerID(consumerId);
                msg.setDeliveryCount(msg.getDeliveryCount() - 1);
            }
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(e10.getMessage());
            jmse.setLinkedException(e10);
            throw jmse;
        }
        return msg;
    }

    boolean setHasMessageListener(int sessionId, int consumerId, boolean hasMessageListener) throws JMSException {
        boolean result = false;
        try {
            result = this.service.setHasMessageListener(this.factoryID, this.getConnectionID(), sessionId, consumerId, hasMessageListener);
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(e10.getMessage());
            jmse.setLinkedException(e10);
            throw jmse;
        }
        return result;
    }

    ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, String subscriptionName) throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("called");
        }
        ConnectionConsumerImpl consumer = null;
        if (sessionPool == null) {
            throw new JMSException(resource.getString("connectionimpl.null_serversessionpool"));
        }
        if (maxMessages < 1) {
            throw new JMSException(resource.getString("connectionimpl.maxmessages_must_be_at_least_1"));
        }
        if (subscriptionName != null && subscriptionName.length() > 0 && this.getClientID() != null && this.getClientID().length() == 0) {
            throw new JMSException(resource.getString("connectionimpl.client_id_must_be_set"));
        }
        consumer = new ConnectionConsumerImpl(destination, messageSelector, sessionPool, maxMessages, subscriptionName, this);
        this.addConnectionConsumer(consumer.getID(), consumer);
        try {
            consumer.invokeRemoteCreateConnectionConsumer();
        }
        catch (JMSException jmse) {
            this.removeConnectionConsumer(consumer.getID());
            throw jmse;
        }
        this.allowSetClientID = false;
        return consumer;
    }

    public int createConsumerID() {
        return ++consumerID;
    }

    public Destination createServiceDestination(int destType, String destName, Map properties) throws JMSException {
        DestinationImpl d10 = null;
        boolean isTemporary = false;
        boolean overwrite = false;
        if (properties != null) {
            Boolean val = (Boolean)properties.get("overwrite");
            if (val != null) {
                overwrite = val;
            }
            if ((val = (Boolean)properties.get("isTemporary")) != null) {
                isTemporary = val;
            }
        }
        try {
            if (destType == 0) {
                this.service.createQueue(this.factoryID, this.getConnectionID(), destName, isTemporary, overwrite);
                d10 = new QueueImpl(destName, isTemporary);
            } else if (destType == 1) {
                this.service.createTopic(this.factoryID, this.getConnectionID(), destName, isTemporary, overwrite);
                d10 = new TopicImpl(destName, isTemporary);
            }
        }
        catch (RemoteException re) {
            if (re.detail instanceof JMSException) {
                throw (JMSException)re.detail;
            }
            JMSException jmse = new JMSException(MessageFormat.format(resource.getString("connectionimpl.unable_to_create_destination"), destName));
            jmse.setLinkedException((Exception)re.detail);
            throw jmse;
        }
        catch (JMSException je) {
            throw je;
        }
        catch (Exception e10) {
            JMSException jmse = new JMSException(MessageFormat.format(resource.getString("connectionimpl.unable_to_create_destination"), destName));
            jmse.setLinkedException(e10);
            throw jmse;
        }
        return d10;
    }

    public void deleteServiceDestination(String destName) throws JMSException {
        try {
            this.service.deleteDestination(this.factoryID, this.getConnectionID(), destName);
        }
        catch (Exception e10) {
            JMSException jmse = new JMSException(MessageFormat.format(resource.getString("connectionimpl.unable_to_create_destination"), destName));
            jmse.setLinkedException(e10);
            throw jmse;
        }
    }

    boolean isStopped() {
        return this.isStopped;
    }

    boolean isClosed() {
        return this.isClosed;
    }
}

