/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.JMSInitialContext;
import com.sun.jms.Version;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.text.MessageFormat;
import javax.naming.NamingException;

public class InitialClientContext
extends JMSInitialContext {
    public static final String CLIENT_LOGFILE_PROPERTY = "com.sun.jms.client.logfile";
    public static final String CLIENT_LOGLEVEL_PROPERTY = "com.sun.jms.client.loglevel";
    private static InitialClientContext instance = null;
    public static JMSProperties props;
    public static final Logger logger;
    static JmsResourceBundle resource;

    private void initializeLog() {
        int logLevel = 10;
        try {
            logLevel = Integer.parseInt(props.getProperty(CLIENT_LOGLEVEL_PROPERTY));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.initialize(props.getProperty(CLIENT_LOGFILE_PROPERTY), logLevel);
        logger.debugInfo("Java(TM) Message Service 1.0.2 Reference Implementation (build " + Version.JMS_FULL_VERSION + ")");
    }

    private InitialClientContext() throws NamingException {
        props = JMSProperties.getInstance();
        try {
            this.initializeLog();
        }
        catch (Exception e10) {
            logger.warning(e10);
        }
    }

    public static InitialClientContext getInstance() {
        if (instance == null) {
            try {
                instance = new InitialClientContext();
            }
            catch (NamingException e10) {
                logger.severe(MessageFormat.format(resource.getString("initialclientcontext.unable_to_create_initialclientcontext"), e10.toString()));
                System.exit(-1);
            }
        }
        return instance;
    }

    static {
        logger = Log.getLogger(2);
        resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");
    }
}

