/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.ConnectionFactoryImpl;
import com.sun.jms.JMSClient;
import com.sun.jms.JMSService;
import com.sun.jms.MessageImpl;
import com.sun.jms.client.ConnectionConsumerImpl;
import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.client.MessageConsumerImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.rmi.PortableRemoteObject;

public class JMSClientImpl
implements JMSClient {
    JMSService service;
    ConnectionFactoryImpl connectionFactory;
    public static final String THREADGROUPNAME = "jms.client";
    public static ThreadGroup clientThreadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ThreadGroup(JMSClientImpl.THREADGROUPNAME);
        }
    });
    static Logger logger = Log.getLogger(2);
    public static final Logger rmilogger = Log.getLogger(6);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    public JMSClientImpl(JMSService s2, ConnectionFactoryImpl cf2, boolean useRMIIIOP) throws JMSException {
        this.service = s2;
        this.connectionFactory = cf2;
        if (useRMIIIOP) {
            try {
                PortableRemoteObject.exportObject((Remote)this);
            }
            catch (RemoteException e10) {
                logger.severe(MessageFormat.format(resource.getString("jmsclientimpl.failed_to_export_iiop"), e10.toString()));
                System.exit(-1);
            }
        } else {
            try {
                UnicastRemoteObject.exportObject(this);
            }
            catch (RemoteException e11) {
                logger.severe(MessageFormat.format(resource.getString("jmsclientimpl.failed_to_export_jrmp"), e11.toString()));
                System.exit(-1);
            }
        }
    }

    public void sendMessage(int connectionID, int sessionID, int consumerID, Message msg) throws JMSException, RemoteException {
        try {
            Object[] params = null;
            if (rmilogger.isLogging(6)) {
                params = new Object[]{"connectionId=" + connectionID, "sessionId=" + sessionID, "consumerId" + consumerID, "msg=" + msg};
                rmilogger.entering(params);
            } else if (logger.isLogging(7)) {
                logger.finest("Client Interface received msg for connectionID=" + connectionID + " sessionID=" + sessionID + " consumerID=" + consumerID + " msg=\"" + msg.toString() + "\"");
            }
            ConnectionImpl c10 = this.connectionFactory.getConnection(connectionID);
            if (c10 == null) {
                throw new JMSException(MessageFormat.format(resource.getString("jmsclientimpl.invalid_connectionid"), new Integer(connectionID)));
            }
            SessionImpl s2 = c10.getSession(sessionID);
            if (s2 == null) {
                throw new JMSException(MessageFormat.format(resource.getString("jmsclientimpl.invalid_sessionid"), new Integer(sessionID)));
            }
            MessageConsumerImpl mc = s2.getMessageConsumer(consumerID);
            ConnectionConsumerImpl cc2 = null;
            if (mc == null && (cc2 = c10.getConnectionConsumer(consumerID)) == null) {
                throw new JMSException(MessageFormat.format(resource.getString("jmsclientimpl.invalid_consumerid"), new Integer(consumerID)));
            }
            ((MessageImpl)msg).setFactoryID(this.connectionFactory.getFactoryID());
            ((MessageImpl)msg).setConnectionID(connectionID);
            ((MessageImpl)msg).setSessionID(sessionID);
            ((MessageImpl)msg).setConsumerID(consumerID);
            ((MessageImpl)msg).setSession(s2);
            if (cc2 != null) {
                s2.deliverMessage(consumerID, msg);
            } else {
                c10.deliverMessage(sessionID, consumerID, msg);
            }
            if (rmilogger.isLogging(6)) {
                rmilogger.exiting(params);
            }
        }
        catch (Exception e10) {
            logger.warning(e10);
            RemoteException re = new RemoteException("JMSClientImpl.sendMessage", e10);
            throw re;
        }
    }

    public void sendException(int connectionID, JMSException ex2) throws JMSException, RemoteException {
        ConnectionImpl c10;
        if (logger.isLogging(7)) {
            logger.finest("Client Interface received exception for connectionID=" + connectionID + "exception=" + ex2.toString());
        }
        if ((c10 = this.connectionFactory.getConnection(connectionID)) == null) {
            throw new JMSException(MessageFormat.format(resource.getString("jmsclientimpl.unable_to_find_connection"), new Integer(connectionID)));
        }
        c10.deliverException(ex2);
    }

    public void ping() throws RemoteException {
    }

    public int getSessionForConnectionConsumer(int connectionID, int consumerID) throws JMSException, RemoteException {
        int result = -1;
        Object[] params = null;
        if (rmilogger.isLogging(6)) {
            params = new Object[]{"connectionId=" + connectionID, "consumerId=" + consumerID};
            rmilogger.entering(params);
        } else if (logger.isLogging(7)) {
            logger.finest("JMSClient.getSessionForConnectionConsumer() connectionID= " + connectionID + " connectionConsumerID= " + consumerID);
        }
        ConnectionImpl connection = this.connectionFactory.getConnection(connectionID);
        if (connection == null) {
            throw new JMSException(MessageFormat.format(resource.getString("jmsclientimpl.unable_to_find_connection"), new Integer(connectionID)));
        }
        ConnectionConsumerImpl connectionConsumer = connection.getConnectionConsumer(consumerID);
        if (connectionConsumer == null) {
            throw new JMSException(MessageFormat.format(resource.getString("jmsclientimpl.unable_to_find_connectionconsumer"), new Integer(consumerID)));
        }
        result = connectionConsumer.getSessionForConnectionConsumer();
        if (rmilogger.isLogging(6)) {
            rmilogger.exiting(params, "sessionId=" + result);
        }
        return result;
    }
}

