/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.client.JMSXAResource;
import com.sun.jms.client.QueueConnectionImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.client.TopicConnectionImpl;
import com.sun.jms.spi.xa.JMSXAConnection;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueSession;
import com.sun.jms.spi.xa.JMSXASession;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicSession;
import com.sun.jms.util.JmsResourceBundle;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.transaction.xa.XAResource;

public abstract class JMSXASessionImpl
implements JMSXASession {
    private boolean transacted;
    private int ackMode;
    private JMSXAConnection xaCon;
    private ConnectionImpl con;
    private boolean isClosed = false;
    private SessionImpl session = null;
    private XAResource xar = null;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    protected JMSXASessionImpl(boolean transacted, int ackMode, JMSXAConnection xaCon) throws JMSException {
        this.transacted = transacted;
        this.ackMode = ackMode;
        this.xaCon = xaCon;
        if (xaCon instanceof JMSXAQueueConnection) {
            this.con = (QueueConnectionImpl)((JMSXAQueueConnection)xaCon).getQueueConnection();
            this.session = (SessionImpl)((Object)((QueueConnection)((Object)this.con)).createQueueSession(transacted, ackMode));
        } else if (xaCon instanceof JMSXATopicConnection) {
            this.con = (TopicConnectionImpl)((JMSXATopicConnection)xaCon).getTopicConnection();
            this.session = (SessionImpl)((Object)((TopicConnection)((Object)this.con)).createTopicSession(transacted, ackMode));
        } else {
            throw new JMSException(resource.getString("jmsxasessionimpl.wrong_connection_type"));
        }
        this.xar = new JMSXAResource(this);
    }

    ConnectionImpl getConnectionImpl() {
        return this.con;
    }

    public XAResource getXAResource() {
        return this.xar;
    }

    public Session getSession() throws JMSException {
        if (this.isClosed) {
            return this.session;
        }
        if (this.session == null || this.session.isClosed()) {
            if (this instanceof JMSXAQueueSession) {
                this.session = (SessionImpl)((Object)((JMSXAQueueSession)((Object)this)).getQueueSession());
            } else if (this instanceof JMSXATopicSession) {
                this.session = (SessionImpl)((Object)((JMSXATopicSession)((Object)this)).getTopicSession());
            } else {
                throw new JMSException(resource.getString("jmsxasessionimpl.wrong_session_type"));
            }
        }
        return this.session;
    }

    public void close() throws JMSException {
        this.isClosed = true;
        if (this.session != null) {
            this.session.close();
        }
        this.xar = null;
    }

    boolean isClosed() {
        return this.isClosed;
    }
}

