/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.DestinationImpl;
import com.sun.jms.JMSService;
import com.sun.jms.MessageImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public abstract class MessageConsumerImpl
implements MessageConsumer {
    protected JMSService service;
    protected String factoryID;
    Destination destination = null;
    LinkedList deliveredMessages = new LinkedList();
    String messageSelector;
    MessageListener messageListener = null;
    static final long INFINITE_TIMEOUT = 0L;
    static final long RCV_SLEEP_PERIOD = 100L;
    SessionImpl parentSession;
    int myConsumerID;
    boolean isClosed = false;
    static Logger logger = Log.getLogger(2);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    boolean isStopped() {
        return this.parentSession.isStopped();
    }

    MessageConsumerImpl(Destination dest, SessionImpl parent, String msgSelector) {
        this.destination = dest;
        this.parentSession = parent;
        this.messageSelector = msgSelector;
        this.myConsumerID = this.parentSession.parentConnection.createConsumerID();
        this.service = this.parentSession.getJMSService();
        this.factoryID = this.parentSession.getFactoryID();
    }

    public void invokeRemoteCreateMessageConsumer() throws JMSException {
        try {
            logger.finer("calling service.createMessageConsumer()");
            this.service.createMessageConsumer(this.factoryID, this.parentSession.getParentConnectionID(), this.parentSession.getSessionID(), this.getConsumerID(), ((DestinationImpl)this.destination).getName(), this.messageSelector, this.getSubscriptionName(), this.getNoLocal());
        }
        catch (RemoteException e10) {
            if (e10.detail instanceof JMSException) {
                throw (JMSException)e10.detail;
            }
            if (e10.detail instanceof RuntimeException) {
                throw (RuntimeException)e10.detail;
            }
            logger.info(e10);
        }
    }

    public String getMessageSelector() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageconsumerimpl.getmessageselector_on_closed_mc"));
        }
        return this.messageSelector;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageconsumerimpl.getmessagelistener_on_closed_mc"));
        }
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageconsumerimpl.setmessagelistener_on_closed_mc"));
        }
        if (this.messageListener == null && listener != null) {
            this.messageListener = listener;
            int n2 = 0;
            LinkedList linkedList = this.deliveredMessages;
            synchronized (linkedList) {
                n2 = this.deliveredMessages.size();
            }
            if (n2 > 0) {
                this.parentSession.addPendingMessageListener(this, n2);
            }
        } else {
            this.messageListener = listener;
        }
    }

    public Message receive() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageconsumerimpl.receive_on_closed_mc"));
        }
        Message msg = this.receive(0L);
        return msg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive(long timeOut) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageconsumerimpl.receive_on_closed_mc"));
        }
        Message msg = null;
        long startTime = System.currentTimeMillis();
        LinkedList linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            while ((msg = this.receiveNoWait()) == null) {
                long waitTime;
                if (this.isClosed()) {
                    return msg;
                }
                if (timeOut != 0L && (waitTime = System.currentTimeMillis() - startTime) > timeOut) {
                    return msg;
                }
                try {
                    this.deliveredMessages.wait(timeOut);
                }
                catch (InterruptedException e10) {
                    // empty catch block
                }
            }
            return msg;
        }
    }

    public Message receiveNoWait() throws JMSException {
        MessageImpl msg = null;
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("messageconsumerimpl.receivenowait_on_closed_mc"));
        }
        LinkedList linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            while (this.deliveredMessages.size() > 0 && !this.isStopped()) {
                msg = (MessageImpl)this.deliveredMessages.removeFirst();
                if (!msg.hasExpired()) break;
                if (logger.isLogging(7)) {
                    logger.finest("Expired msg " + msg.toString());
                }
                msg = null;
            }
        }
        this.acknowledge(msg);
        return msg;
    }

    public void close() throws JMSException {
        if (this.isClosed()) {
            return;
        }
        this.internalClose();
        MessageConsumerImpl messageConsumerImpl = this;
        synchronized (messageConsumerImpl) {
            block8: {
                try {
                    this.service.close(this.factoryID, this.parentSession.getParentConnectionID(), this.parentSession.getSessionID(), -1, this.myConsumerID);
                }
                catch (RemoteException re) {
                    if (logger.isLogging(2)) {
                        logger.warning(MessageFormat.format(resource.getString("messageconsumerimpl.Ignoring_exception"), re.getMessage()));
                    }
                }
                catch (JMSException je) {
                    if (!logger.isLogging(2)) break block8;
                    logger.warning(MessageFormat.format(resource.getString("messageconsumerimpl.Ignoring_exception"), je.getMessage()));
                }
            }
            this.parentSession.removeMessageConsumer(this.myConsumerID);
        }
    }

    public synchronized void internalClose() throws JMSException {
        this.isClosed = true;
        LinkedList linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            this.deliveredMessages.notify();
        }
        if (this.messageListener != null) {
            this.parentSession.removeFromPendingMessageListeners(this.myConsumerID);
        }
    }

    public int getConsumerID() {
        return this.myConsumerID;
    }

    public MessageListener deliverMessage(Message msg) {
        logger.finest(msg.toString());
        int i2 = 0;
        LinkedList linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            block7: {
                try {
                    Comparator comp = MessageImpl.PriorityComparator.getInstance();
                    i2 = 0;
                    while (i2 < this.deliveredMessages.size()) {
                        if (comp.compare(this.deliveredMessages.get(i2), msg) > 0) {
                            ++i2;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e10) {
                    if (!logger.isLogging(2)) break block7;
                    logger.warning(MessageFormat.format(resource.getString("messageconsumerimpl.message_compare_failure"), e10.toString()));
                }
            }
            this.deliveredMessages.add(i2, msg);
            this.deliveredMessages.notify();
        }
        return this.messageListener;
    }

    void processMessageListenerEvent() {
        Message msg = null;
        if (this.messageListener == null) {
            return;
        }
        if (this.isClosed()) {
            return;
        }
        LinkedList linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            block23: {
                try {
                    msg = (Message)this.deliveredMessages.removeFirst();
                }
                catch (NoSuchElementException ex2) {
                    if (!logger.isLogging(2)) break block23;
                    logger.warning(resource.getString("messageconsumerimpl.messagelistener_on_non_existent_message"));
                }
            }
        }
        MessageConsumerImpl messageConsumerImpl = this;
        synchronized (messageConsumerImpl) {
            block24: {
                if (msg != null && !this.isClosed()) {
                    MessageImpl msgImpl = (MessageImpl)msg;
                    if (this.parentSession.ackAfterMessageListener()) {
                        msgImpl.setDeliveredTrue();
                        boolean finished = false;
                        do {
                            try {
                                this.messageListener.onMessage(msgImpl.getDeliveredMessage());
                                finished = true;
                                if (logger.isLogging(7)) {
                                    logger.finest("Acknowledge After Message Listener");
                                }
                                try {
                                    this.acknowledge(msgImpl);
                                }
                                catch (Throwable t2) {
                                    if (!logger.isLogging(2)) continue;
                                    logger.warning(MessageFormat.format(resource.getString("messageconsumerimpl.auto_ack_failed"), msg));
                                    logger.warning(t2);
                                }
                            }
                            catch (Throwable t3) {
                                if (logger.isLogging(2)) {
                                    logger.warning(MessageFormat.format(resource.getString("messageconsumerimpl.messagelistener_threw_exception"), this.destination.toString(), t3.getMessage()));
                                }
                                msgImpl.incrementDeliveryCount();
                                if (!msgImpl.exceedsMaxRedeliveryCount()) continue;
                                finished = true;
                            }
                        } while (!finished);
                    } else {
                        try {
                            if (logger.isLogging(7)) {
                                logger.finest("Acknowledge Before Message Listener");
                            }
                            this.acknowledge(msgImpl);
                            this.messageListener.onMessage(msgImpl);
                        }
                        catch (Throwable t4) {
                            if (!logger.isLogging(2)) break block24;
                            logger.warning(MessageFormat.format(resource.getString("messageconsumerimpl.messagelistener_threw_exception"), this.destination.toString(), t4.getMessage()));
                        }
                    }
                }
            }
        }
    }

    void clearDeliveredMessages() {
        LinkedList linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            this.deliveredMessages.clear();
        }
    }

    public abstract String consumerTypeName();

    public String toString() {
        return this.consumerTypeName() + "." + this.parentSession.parentConnection.getConnectionID() + "." + this.parentSession.getSessionID() + "." + this.myConsumerID;
    }

    public void processDeliveredMessage() {
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getSubscriptionName() {
        return null;
    }

    public boolean getNoLocal() throws JMSException {
        return false;
    }

    protected void acknowledge(MessageImpl msg) throws JMSException {
        if (msg != null) {
            this.parentSession.internalAcknowledge(msg);
        }
    }

    void start() {
        LinkedList linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            this.deliveredMessages.notify();
        }
    }
}

