/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.client.MessageProducerImpl;
import com.sun.jms.client.QueueSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;

public class QueueSenderImpl
extends MessageProducerImpl
implements QueueSender {
    Queue queue = null;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    QueueSenderImpl(Queue queue, QueueSessionImpl qSession) {
        super(queue, qSession);
        this.queue = queue;
    }

    public Queue getQueue() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesenderimpl.getqueue_on_closed_qs"));
        }
        return this.queue;
    }

    public void send(Message message) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesenderimpl.send_on_closed_qs"));
        }
        super.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesenderimpl.send_on_closed_qs"));
        }
        super.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesenderimpl.send_on_closed_qs"));
        }
        super.send(queue, message);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queuesenderimpl.send_on_closed_qs"));
        }
        super.send(queue, message, deliveryMode, priority, timeToLive);
    }

    public void close() throws JMSException {
        super.close();
    }
}

