/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.Acknowledgement;
import com.sun.jms.BytesMessageImpl;
import com.sun.jms.ClientSession;
import com.sun.jms.DestinationImpl;
import com.sun.jms.JMSService;
import com.sun.jms.MapMessageImpl;
import com.sun.jms.MessageImpl;
import com.sun.jms.ObjectMessageImpl;
import com.sun.jms.QueueImpl;
import com.sun.jms.StreamMessageImpl;
import com.sun.jms.TextMessageImpl;
import com.sun.jms.TopicImpl;
import com.sun.jms.XidImpl;
import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.client.JMSClientImpl;
import com.sun.jms.client.MessageConsumerImpl;
import com.sun.jms.client.MessageProducerImpl;
import com.sun.jms.client.QueueReceiverImpl;
import com.sun.jms.client.QueueSessionImpl;
import com.sun.jms.client.TemporaryQueueImpl;
import com.sun.jms.client.TemporaryTopicImpl;
import com.sun.jms.client.TopicSessionImpl;
import com.sun.jms.client.TopicSubscriberImpl;
import com.sun.jms.spi.ServerSession;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import com.sun.jms.util.Waiter;
import com.sun.jms.util.WaiterManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TransactionRolledBackException;
import javax.transaction.xa.XAException;

public abstract class SessionImpl
implements Session,
ClientSession {
    static final int CONSTRUCTION_STATE = 0;
    static final int RUNNING_STATE = 1;
    static final int PENDING_CLOSE_STATE = 2;
    static final int CLOSED_STATE = 3;
    protected JMSService service;
    protected String factoryID;
    ConnectionImpl parentConnection;
    HashMap producerHashMap;
    protected HashMap consumerHashMap;
    MessageListener distinguishedMessageListener = null;
    LinkedList pendingMessageListeners = null;
    Waiter pendingMessageListenersWaiter = null;
    boolean transacted = false;
    boolean pendingLocalTxn = false;
    private boolean globalTransaction = false;
    int acknowledgeMode = 1;
    ActiveMessageListenerThread activeMessageListener = null;
    private LinkedList receivedMsgs = new LinkedList();
    int state = 0;
    static int sessionNumber = 0;
    int mySessionID;
    static int tempDestNumber = 0;
    static int JMSSunMessageID = 0;
    private ServerSession serverSession = null;
    static Logger logger = Log.getLogger(2);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");
    private final int RECEIVED_MSG_IDS = 0;
    private final int RECEIVED_CONSUMER_IDS = 1;

    public ConnectionImpl getConnection() {
        return this.parentConnection;
    }

    SessionImpl(boolean isTransacted, int ackMode, ConnectionImpl parent) {
        this.parentConnection = parent;
        this.service = this.parentConnection.getJMSService();
        this.factoryID = this.parentConnection.getFactoryID();
        this.transacted = isTransacted;
        this.acknowledgeMode = ackMode;
        this.mySessionID = ++sessionNumber;
        this.producerHashMap = new HashMap();
        this.consumerHashMap = new HashMap();
        this.state = 1;
    }

    private boolean hadAsynchronousMessageListeners() {
        return this.pendingMessageListeners != null;
    }

    private void initAsynchronousMessageListeners() {
        this.pendingMessageListeners = new LinkedList();
        this.pendingMessageListenersWaiter = new Waiter(JMSClientImpl.clientThreadGroup, new WaiterManager(){

            public void activityDetected() {
                SessionImpl.this.processPendingMessageListeners();
            }
        }, "jms.client Session.pendingMessageListenersWaiter." + this.mySessionID);
    }

    private int getConnectionID() {
        return this.parentConnection.getConnectionID();
    }

    public int getNextMessageID() {
        return ++JMSSunMessageID;
    }

    public void invokeRemoteCreateSession() throws JMSException {
        try {
            if (logger.isLogging(7)) {
                logger.finest("Calling service.createSession()");
            }
            this.service.createSession(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID, this.transacted, this.acknowledgeMode);
        }
        catch (RemoteException e10) {
            if (e10.detail instanceof JMSException) {
                throw (JMSException)e10.detail;
            }
            if (e10.detail instanceof RuntimeException) {
                throw (RuntimeException)e10.detail;
            }
            logger.info(e10);
        }
    }

    public Destination createDestination(int destType, String destName) throws JMSException {
        DestinationImpl dest = null;
        try {
            if (destType == 0) {
                dest = new QueueImpl(destName);
            } else if (destType == 1) {
                dest = new TopicImpl(destName);
            }
        }
        catch (Exception e10) {
            JMSException jmse = new JMSException(MessageFormat.format(resource.getString("sessionimpl.Unable_to_create_destination"), destName));
            jmse.setLinkedException(e10);
            throw jmse;
        }
        return dest;
    }

    public Destination createTemporaryDestination(int destType) throws JMSException {
        DestinationImpl tempDest = null;
        String destName = null;
        int tempDestID = ++tempDestNumber;
        try {
            if (destType == 0) {
                destName = "tempQueue_" + tempDestID + "_" + this.factoryID;
                tempDest = new TemporaryQueueImpl(destName, this.parentConnection);
                this.service.createQueue(this.factoryID, this.parentConnection.getConnectionID(), destName, true, false);
            } else if (destType == 1) {
                destName = "tempTopic_" + tempDestID + "_" + this.factoryID;
                tempDest = new TemporaryTopicImpl(destName, this.parentConnection);
                this.service.createTopic(this.factoryID, this.parentConnection.getConnectionID(), destName, true, false);
            }
        }
        catch (RemoteException re) {
            if (re.detail instanceof JMSException) {
                throw (JMSException)re.detail;
            }
            if (re.detail instanceof RuntimeException) {
                throw (RuntimeException)re.detail;
            }
            logger.info(re);
        }
        catch (Exception e10) {
            JMSException jmse = new JMSException(MessageFormat.format(resource.getString("sessionimpl.unable_to_create_destination"), destName));
            jmse.setLinkedException(e10);
            throw jmse;
        }
        return tempDest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageConsumer createConsumer(Destination dest, String msgSelector, String subscriptionName, boolean noLocal, SessionImpl s2) throws JMSException {
        if (dest == null) {
            throw new InvalidDestinationException(resource.getString("sessionimpl.destination_is_null"));
        }
        MessageConsumerImpl consumer = null;
        if (dest instanceof TemporaryQueue) {
            if (((TemporaryQueueImpl)dest).getConnectionContext() != this.parentConnection) throw new JMSException(resource.getString("sessionimpl.cant_consume_from_this_tq"));
            consumer = new QueueReceiverImpl((Queue)dest, msgSelector, (QueueSessionImpl)s2);
        } else if (dest instanceof TemporaryTopic) {
            if (((TemporaryTopicImpl)dest).getConnectionContext() != this.parentConnection) throw new JMSException(resource.getString("sessionimpl.cant_consume_from_this_tq"));
            consumer = new TopicSubscriberImpl((Topic)dest, msgSelector, subscriptionName, noLocal, (TopicSessionImpl)s2);
        } else if (dest instanceof Queue) {
            consumer = new QueueReceiverImpl((Queue)dest, msgSelector, (QueueSessionImpl)s2);
        } else if (dest instanceof Topic) {
            consumer = new TopicSubscriberImpl((Topic)dest, msgSelector, subscriptionName, noLocal, (TopicSessionImpl)s2);
        }
        this.addMessageConsumer(consumer.getConsumerID(), consumer);
        try {
            consumer.invokeRemoteCreateMessageConsumer();
            return consumer;
        }
        catch (JMSException e10) {
            this.removeMessageConsumer(consumer.getConsumerID());
            throw e10;
        }
    }

    protected abstract MessageProducerImpl createMessageProducer(Destination var1, SessionImpl var2);

    public MessageProducer createProducer(Destination dest, SessionImpl s2) throws JMSException {
        MessageProducerImpl producer = this.createMessageProducer(dest, s2);
        this.addMessageProducer(producer.getProducerID(), producer);
        producer.invokeRemoteCreateMessageProducer();
        return producer;
    }

    public void sendMessage(int producerID, Message msg) throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("mySessionID = " + this.mySessionID + ", producerID = " + producerID);
        }
        msg = MessageImpl.createNativeMessage(msg);
        ((MessageImpl)msg).setInternalMessageID(JMSSunMessageID);
        this.parentConnection.sendMessage(this.mySessionID, producerID, msg);
        if (this.transacted && !this.isGlobalTxn()) {
            this.pendingLocalTxn = true;
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.createbytesmessage_on_closed_session"));
        }
        BytesMessageImpl message = new BytesMessageImpl();
        return message;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.called_createmapmessage_on_closed_session"));
        }
        MapMessageImpl message = new MapMessageImpl();
        return message;
    }

    public Message createMessage() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.createmessage_on_closed_session"));
        }
        MessageImpl message = new MessageImpl();
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.createobjectmessage_on_closed_session"));
        }
        ObjectMessageImpl message = new ObjectMessageImpl();
        return message;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.createobjectmessage_on_closed_session"));
        }
        ObjectMessageImpl message = new ObjectMessageImpl();
        message.setObject(object);
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.createstreammessage_on_closed_session"));
        }
        StreamMessageImpl message = new StreamMessageImpl();
        return message;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.createtextmessage_on_closed_session"));
        }
        TextMessageImpl message = new TextMessageImpl();
        return message;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.createtextmessage_on_closed_session"));
        }
        TextMessageImpl message = new TextMessageImpl();
        message.setText(text);
        return message;
    }

    public boolean getTransacted() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.gettransacted_on_closed_session"));
        }
        return this.transacted;
    }

    private boolean getTransactedInternal() {
        return this.transacted;
    }

    void addReceivedMsg(Message msg) {
        if (logger.isLogging(7)) {
            logger.finest(msg.toString());
        }
        LinkedList linkedList = this.receivedMsgs;
        synchronized (linkedList) {
            this.receivedMsgs.add(msg);
        }
    }

    void clearReceivedMsg() {
        LinkedList linkedList = this.receivedMsgs;
        synchronized (linkedList) {
            this.receivedMsgs.clear();
        }
    }

    private Acknowledgement[] getAcknowledgements(boolean clearAcks) {
        Acknowledgement[] acks;
        int size = 0;
        LinkedList linkedList = this.receivedMsgs;
        synchronized (linkedList) {
            size = this.receivedMsgs.size();
            acks = new Acknowledgement[size];
            Iterator msgIter = this.receivedMsgs.iterator();
            MessageImpl msg = null;
            int i2 = 0;
            while (msgIter.hasNext()) {
                msg = (MessageImpl)msgIter.next();
                acks[i2] = new Acknowledgement(msg);
                ++i2;
            }
            if (clearAcks) {
                this.receivedMsgs.clear();
            }
        }
        if (logger.isLogging(7)) {
            logger.finest("Received Msgs = " + size);
        }
        return acks;
    }

    private Acknowledgement[] getAcknowledgements() throws JMSException {
        Acknowledgement[] acks = null;
        LinkedList linkedList = this.receivedMsgs;
        synchronized (linkedList) {
            acks = new Acknowledgement[this.receivedMsgs.size()];
            ListIterator msgIter = this.receivedMsgs.listIterator();
            MessageImpl msg = null;
            int i2 = 0;
            while (msgIter.hasNext()) {
                msg = (MessageImpl)msgIter.next();
                acks[i2] = new Acknowledgement(msg);
                msgIter.remove();
                ++i2;
            }
        }
        if (logger.isLogging(7)) {
            logger.finest("CLIENT_ACKNOWLEDGE group ack size = " + this.receivedMsgs.size());
        }
        return acks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws JMSException {
        boolean commitFailedRolledBack = false;
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.commit_on_closed_session"));
        }
        try {
            try {
                this.pendingLocalTxn = false;
                this.service.commit(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID, this.getAcknowledgements(true));
            }
            catch (RemoteException re) {
                if (re.detail instanceof TransactionRolledBackException) {
                    commitFailedRolledBack = true;
                    throw (JMSException)re.detail;
                }
                if (re.detail instanceof JMSException) {
                    throw (JMSException)re.detail;
                }
                if (logger.isLogging(2)) {
                    logger.warning(MessageFormat.format(resource.getString("sessionimpl.commit_failed_ignoring_exception"), re.getMessage()));
                    logger.warning(re.detail);
                }
                Object var5_3 = null;
                if (!commitFailedRolledBack) return;
                this.clearClientBuffers();
                this.startMessageDelivery();
                return;
            }
            catch (TransactionRolledBackException e10) {
                commitFailedRolledBack = true;
                throw e10;
            }
            Object var5_2 = null;
            if (!commitFailedRolledBack) return;
            this.clearClientBuffers();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!commitFailedRolledBack) throw throwable;
            this.clearClientBuffers();
            this.startMessageDelivery();
            throw throwable;
        }
        this.startMessageDelivery();
    }

    private void clearPendingMessageListeners() {
        if (this.hadAsynchronousMessageListeners()) {
            Waiter waiter = this.pendingMessageListenersWaiter;
            synchronized (waiter) {
                this.pendingMessageListeners.clear();
            }
        }
    }

    private void clearMessagesInConsumers() {
        Iterator consumerIter = this.consumerHashMap.values().iterator();
        while (consumerIter.hasNext()) {
            MessageConsumerImpl mc = (MessageConsumerImpl)consumerIter.next();
            mc.clearDeliveredMessages();
        }
    }

    private void clearClientBuffers() {
        this.parentConnection.clearSessionMessages(this.mySessionID);
        this.clearPendingMessageListeners();
        this.clearMessagesInConsumers();
        this.clearReceivedMsg();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.rollback_on_closed_session"));
        }
        try {
            try {
                this.pendingLocalTxn = false;
                this.service.rollback(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID, this.getAcknowledgements(true));
            }
            catch (RemoteException re) {
                if (re.detail instanceof JMSException) {
                    throw (JMSException)re.detail;
                }
                if (logger.isLogging(2)) {
                    logger.warning(MessageFormat.format(resource.getString("sessionimpl.rollback_failed_ignoring_exception"), re.getMessage()));
                    logger.warning(re.detail);
                }
                Object var3_2 = null;
                this.clearClientBuffers();
                this.startMessageDelivery();
                return;
            }
            Object var3_1 = null;
            this.clearClientBuffers();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.clearClientBuffers();
            this.startMessageDelivery();
            throw throwable;
        }
        this.startMessageDelivery();
    }

    private void setGlobalTxnMode(boolean mode) {
        this.globalTransaction = mode;
    }

    private boolean isGlobalTxn() {
        return this.globalTransaction;
    }

    public void xaStart(XidImpl xid, int flags) throws JMSException, XAException {
        block4: {
            if (this.pendingLocalTxn) {
                throw new XAException(resource.getString("sessionimpl.pending_local_transaction"));
            }
            this.setGlobalTxnMode(true);
            try {
                this.service.xaStart(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID, xid, flags);
            }
            catch (RemoteException re) {
                if (re.detail instanceof JMSException) {
                    this.setGlobalTxnMode(false);
                    throw (JMSException)re.detail;
                }
                if (!logger.isLogging(2)) break block4;
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.xastart_failed"), re.getMessage()));
                logger.warning(re.detail);
            }
        }
    }

    public void xaEnd(XidImpl xid, int flags) throws JMSException, XAException {
        try {
            try {
                this.service.xaEnd(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID, xid, flags, this.getAcknowledgements(true));
            }
            catch (RemoteException re) {
                if (re.detail instanceof JMSException) {
                    throw (JMSException)re.detail;
                }
                if (logger.isLogging(2)) {
                    logger.warning(MessageFormat.format(resource.getString("sessionimpl.xaend_failed"), re.getMessage()));
                    logger.warning(re.detail);
                }
                Object var5_4 = null;
                this.setGlobalTxnMode(false);
            }
            Object var5_3 = null;
            this.setGlobalTxnMode(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setGlobalTxnMode(false);
            throw throwable;
        }
    }

    public void startMessageDelivery() throws JMSException {
        block3: {
            try {
                this.service.setMessageDelivery(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID, true);
            }
            catch (RemoteException re) {
                if (re.detail instanceof JMSException) {
                    throw (JMSException)re.detail;
                }
                if (!logger.isLogging(2)) break block3;
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.call_failed"), re.getMessage()));
                logger.warning(re.detail);
            }
        }
    }

    public void stopMessageDelivery() throws JMSException {
        block3: {
            try {
                this.service.setMessageDelivery(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID, false);
            }
            catch (RemoteException re) {
                if (re.detail instanceof JMSException) {
                    throw (JMSException)re.detail;
                }
                if (!logger.isLogging(2)) break block3;
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.call_failed"), re.getMessage()));
                logger.warning(re.detail);
            }
        }
    }

    public void close(boolean callServiceClose) throws JMSException {
        block11: {
            if (this.state == 2 || this.state == 3) {
                return;
            }
            this.state = 2;
            if (this.hadAsynchronousMessageListeners()) {
                Waiter waiter = this.pendingMessageListenersWaiter;
                synchronized (waiter) {
                    this.waitForActiveMessageListenerThreadToComplete();
                    this.pendingMessageListenersWaiter.stopRunning();
                }
            }
            Iterator producerIter = this.producerHashMap.values().iterator();
            while (producerIter.hasNext()) {
                MessageProducerImpl mp = (MessageProducerImpl)producerIter.next();
                mp.internalClose();
                producerIter.remove();
            }
            Iterator consumerIter = this.consumerHashMap.values().iterator();
            while (consumerIter.hasNext()) {
                MessageConsumerImpl mc = (MessageConsumerImpl)consumerIter.next();
                mc.internalClose();
                consumerIter.remove();
            }
            if (callServiceClose) {
                this.parentConnection.removeSession(this.mySessionID);
            }
            this.state = 3;
            if (callServiceClose) {
                try {
                    this.service.close(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID, -1, -1);
                }
                catch (RemoteException re) {
                    if (!logger.isLogging(2)) break block11;
                    logger.warning(MessageFormat.format(resource.getString("sessionimpl.call_failed"), re.getMessage()));
                    logger.warning(re.detail);
                }
            }
        }
    }

    public void close() throws JMSException {
        this.close(true);
    }

    boolean isStopped() {
        return this.parentConnection.isStopped();
    }

    void stop() {
        if (this.hadAsynchronousMessageListeners()) {
            Waiter waiter = this.pendingMessageListenersWaiter;
            synchronized (waiter) {
                this.waitForActiveMessageListenerThreadToComplete();
            }
        }
    }

    void start() {
        if (this.hadAsynchronousMessageListeners()) {
            Waiter waiter = this.pendingMessageListenersWaiter;
            synchronized (waiter) {
                this.pendingMessageListenersWaiter.wakeup();
            }
        }
    }

    public boolean isClosed() {
        return this.state == 3;
    }

    public void recover() throws JMSException {
        block4: {
            if (this.isClosed()) {
                throw new IllegalStateException(resource.getString("sessionimpl.recover_on_closed_session"));
            }
            try {
                this.service.recover(this.factoryID, this.parentConnection.getConnectionID(), this.mySessionID);
                this.clearClientBuffers();
                this.startMessageDelivery();
            }
            catch (RemoteException re) {
                if (re.detail instanceof JMSException) {
                    throw (JMSException)re.detail;
                }
                if (!logger.isLogging(2)) break block4;
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.call_failed"), re.getMessage()));
                logger.warning(re.detail);
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.getmessagelistener_on_closed_session"));
        }
        return this.distinguishedMessageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.distinguishedMessageListener = listener;
    }

    private void onSessionMessageListener(MessageImpl msg) throws JMSException {
        block23: {
            block22: {
                boolean ackAfterMsgListener;
                block21: {
                    ackAfterMsgListener = this.ackAfterMessageListener();
                    if (msg.getCloseMessageForServerSession() == 2) {
                        if (logger.isLogging(7)) {
                            logger.finest("Got close message for ServerSession - calling close....");
                        }
                        ServerSession tempSS = this.serverSession;
                        this.setServerSession(null);
                        tempSS.close();
                        return;
                    }
                    if (this.serverSession != null) {
                        try {
                            this.serverSession.beforeMessageDelivery(msg);
                        }
                        catch (Throwable t2) {
                            if (!logger.isLogging(2)) break block21;
                            logger.warning(MessageFormat.format(resource.getString("sessionimpl.ignoring_exception_thrown_by_serversession.beforemessagedelivery"), t2.getMessage()));
                        }
                    }
                }
                if (ackAfterMsgListener) {
                    msg.setDeliveredTrue();
                    boolean finished = false;
                    do {
                        try {
                            this.distinguishedMessageListener.onMessage(msg.getDeliveredMessage());
                            finished = true;
                            if (logger.isLogging(7)) {
                                logger.finest("Acknowledge After Distinguished Session Message Listener");
                            }
                            this.internalAcknowledge(msg);
                        }
                        catch (Throwable t3) {
                            if (logger.isLogging(2)) {
                                logger.warning(MessageFormat.format(resource.getString("sessionimpl.distinguished_messagelistener_threw"), this.toString(), t3.getMessage()));
                                logger.warning(t3);
                            }
                            if (!finished) {
                                msg.incrementDeliveryCount();
                            }
                            if (!msg.exceedsMaxRedeliveryCount()) continue;
                            finished = true;
                        }
                    } while (!finished);
                } else {
                    if (logger.isLogging(7)) {
                        logger.finest("Acknowledge Before Distinguished Session Message Listener");
                    }
                    this.internalAcknowledge(msg);
                    try {
                        this.distinguishedMessageListener.onMessage(msg);
                    }
                    catch (Throwable t4) {
                        if (!logger.isLogging(2)) break block22;
                        logger.warning(MessageFormat.format(resource.getString("sessionimpl.distinguished_messagelistener_threw"), this.toString(), t4.getMessage()));
                        logger.warning(t4);
                    }
                }
            }
            if (this.serverSession != null) {
                try {
                    this.serverSession.afterMessageDelivery(msg);
                }
                catch (Throwable t5) {
                    if (!logger.isLogging(2)) break block23;
                    logger.warning(MessageFormat.format(resource.getString("sessionimpl.ignoring_exception_thrown_by_serversession.aftermessagedelivery"), t5.getMessage()));
                }
            }
        }
        if (msg.getCloseMessageForServerSession() == 1) {
            if (logger.isLogging(7)) {
                logger.finest("Got close message for ServerSession - calling close....");
            }
            ServerSession tempSS = this.serverSession;
            this.setServerSession(null);
            tempSS.close();
        }
    }

    public void deliverMessage(int consumerID, Message msg) throws JMSException {
        if (this.state == 2 || this.state == 3) {
            return;
        }
        if (this.distinguishedMessageListener != null) {
            if (msg != null) {
                this.onSessionMessageListener((MessageImpl)msg);
            }
        } else {
            MessageConsumerImpl mc = this.getMessageConsumer(consumerID);
            if (mc == null) {
                throw new JMSException(MessageFormat.format(resource.getString("sessionimpl.unable_to_find_messageconsumer"), new Integer(consumerID)));
            }
            if (mc.deliverMessage(msg) != null) {
                if (logger.isLogging(7)) {
                    logger.finest("Queued a message for a MessageListener");
                }
                this.addPendingMessageListener(mc);
            }
        }
    }

    private void addPendingMessageListener(MessageConsumer mc) {
        if (!this.hadAsynchronousMessageListeners()) {
            this.initAsynchronousMessageListeners();
        }
        Waiter waiter = this.pendingMessageListenersWaiter;
        synchronized (waiter) {
            this.pendingMessageListeners.addLast(mc);
            this.pendingMessageListenersWaiter.wakeup();
        }
    }

    void addPendingMessageListener(MessageConsumer mc, int times) {
        if (!this.hadAsynchronousMessageListeners()) {
            this.initAsynchronousMessageListeners();
        }
        Waiter waiter = this.pendingMessageListenersWaiter;
        synchronized (waiter) {
            int i2 = 0;
            while (i2 < times) {
                this.pendingMessageListeners.addLast(mc);
                ++i2;
            }
            this.pendingMessageListenersWaiter.wakeup();
        }
    }

    public int getSessionID() {
        return this.mySessionID;
    }

    public void addMessageProducer(int id, MessageProducerImpl producer) {
        if (logger.isLogging(7)) {
            logger.finest("id=" + id + ", producer=" + producer);
        }
        this.producerHashMap.put(new Integer(id), producer);
    }

    public synchronized void addMessageConsumer(int id, MessageConsumerImpl consumer) {
        if (logger.isLogging(7)) {
            logger.finest("id=" + id + ", consumer=" + consumer);
        }
        this.consumerHashMap.put(new Integer(id), consumer);
    }

    public MessageProducer removeMessageProducer(int id) {
        if (logger.isLogging(7)) {
            logger.finest("id=" + id);
        }
        return (MessageProducer)this.producerHashMap.remove(new Integer(id));
    }

    public synchronized MessageConsumer removeMessageConsumer(int id) {
        if (logger.isLogging(7)) {
            logger.finest("id=" + id);
        }
        return (MessageConsumer)this.consumerHashMap.remove(new Integer(id));
    }

    public synchronized MessageConsumerImpl getMessageConsumer(int id) {
        if (logger.isLogging(7)) {
            logger.finest("id=" + id);
        }
        return (MessageConsumerImpl)this.consumerHashMap.get(new Integer(id));
    }

    public void run() {
    }

    public JMSService getJMSService() {
        return this.parentConnection.getJMSService();
    }

    public String getFactoryID() {
        return this.parentConnection.getFactoryID();
    }

    public int getParentConnectionID() {
        return this.parentConnection.getConnectionID();
    }

    private boolean doAutoAcknowledge() {
        return this.acknowledgeMode == 1 || this.acknowledgeMode == 3;
    }

    boolean ackAfterMessageListener() {
        return !this.getTransactedInternal() && this.doAutoAcknowledge();
    }

    void internalAcknowledge(MessageImpl msg) throws JMSException {
        if (!this.transacted && !this.isGlobalTxn() && this.doAutoAcknowledge()) {
            try {
                this.service.acknowledgeMessage(this.factoryID, this.getConnectionID(), this.mySessionID, new Acknowledgement(msg));
            }
            catch (RemoteException e10) {
                if (e10.detail instanceof JMSException) {
                    throw (JMSException)e10.detail;
                }
                if (e10.detail instanceof RuntimeException) {
                    throw (RuntimeException)e10.detail;
                }
                logger.warning(e10);
            }
        } else {
            if (this.transacted && !this.isGlobalTxn()) {
                this.pendingLocalTxn = true;
            }
            this.addReceivedMsg(msg);
        }
    }

    public void acknowledge(MessageImpl msg) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("sessionimpl.acknowledge_on_closed_session"));
        }
        if (this.transacted || this.isGlobalTxn() || this.doAutoAcknowledge() || msg == null) {
            return;
        }
        try {
            this.service.acknowledgeMessages(this.factoryID, this.getConnectionID(), this.mySessionID, this.getAcknowledgements());
        }
        catch (RemoteException e10) {
            if (e10.detail instanceof JMSException) {
                throw (JMSException)e10.detail;
            }
            if (e10.detail instanceof RuntimeException) {
                throw (RuntimeException)e10.detail;
            }
            logger.warning(e10);
        }
    }

    void removeFromPendingMessageListeners(int id) {
        if (this.hadAsynchronousMessageListeners()) {
            Waiter waiter = this.pendingMessageListenersWaiter;
            synchronized (waiter) {
                ListIterator li = this.pendingMessageListeners.listIterator();
                while (li.hasNext()) {
                    if (((MessageConsumerImpl)li.next()).getConsumerID() != id) continue;
                    li.remove();
                }
            }
        }
    }

    private void processPendingMessageListeners() {
        MessageConsumerImpl mc = null;
        while (this.state == 1 && !this.isStopped()) {
            if (this.pendingMessageListeners.size() == 0) {
                return;
            }
            try {
                mc = (MessageConsumerImpl)this.pendingMessageListeners.removeFirst();
            }
            catch (NoSuchElementException e10) {
                return;
            }
            if (mc == null) continue;
            final MessageConsumerImpl localMC = mc;
            if (logger.isLogging(7)) {
                logger.finest("Thread " + this.toString() + " starting MessageListener " + mc.toString());
            }
            this.activeMessageListener = (ActiveMessageListenerThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ActiveMessageListenerThread(localMC, SessionImpl.this.pendingMessageListenersWaiter);
                }
            });
            this.activeMessageListener.start();
            this.waitForActiveMessageListenerThreadToComplete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForActiveMessageListenerThreadToComplete() {
        Waiter waiter = this.pendingMessageListenersWaiter;
        synchronized (waiter) {
            while (this.activeMessageListener != null && !this.activeMessageListener.finished) {
                try {
                    this.pendingMessageListenersWaiter.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.activeMessageListener = null;
            return;
        }
    }

    Message receive(int consumerID, long timeout) throws JMSException {
        Message msg = this.parentConnection.receive(this.mySessionID, consumerID, timeout);
        if (msg != null) {
            ((MessageImpl)msg).setSession(this);
        }
        return msg;
    }

    boolean setHasMessageListener(int consumerID, boolean hasMsgListener) throws JMSException {
        return this.parentConnection.setHasMessageListener(this.mySessionID, consumerID, hasMsgListener);
    }

    public void setServerSession(javax.jms.ServerSession ss) {
        if (ss != null && this.serverSession != null && logger.isLogging(2)) {
            logger.warning(resource.getString("sessionimpl.serversession_isnt_null"));
        }
        this.serverSession = (ServerSession)ss;
    }

    static class ActiveMessageListenerThread
    extends Thread {
        private MessageConsumerImpl mc;
        private Object finishNotificationListener;
        public volatile boolean finished = false;

        ActiveMessageListenerThread(MessageConsumerImpl mc, Object finishNotificationListener) {
            super(JMSClientImpl.clientThreadGroup, "jms.client SessionImpl.activeMessageListener");
            this.mc = mc;
            this.finishNotificationListener = finishNotificationListener;
        }

        public void run() {
            block5: {
                try {
                    this.mc.processMessageListenerEvent();
                }
                catch (Throwable t2) {
                    if (!logger.isLogging(2)) break block5;
                    logger.warning(MessageFormat.format(resource.getString("sessionimpl.message_listener_threw"), this.mc.toString(), t2.getMessage()));
                    logger.warning(t2);
                }
            }
            Object object = this.finishNotificationListener;
            synchronized (object) {
                this.finished = true;
                this.finishNotificationListener.notifyAll();
            }
        }
    }
}

