/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.JMSService;
import com.sun.jms.QueueImpl;
import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;

public class TemporaryQueueImpl
extends QueueImpl
implements TemporaryQueue {
    private transient ConnectionImpl connectionContext;
    private String name;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    TemporaryQueueImpl(String n2, ConnectionImpl c10) {
        super(n2, true);
        this.name = n2;
        this.connectionContext = c10;
    }

    public void delete() throws JMSException {
        JMSService s2 = this.connectionContext.getJMSService();
        String factoryID = this.connectionContext.getFactoryID();
        int connectionID = this.connectionContext.getConnectionID();
        try {
            s2.deleteDestination(factoryID, connectionID, this.name);
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(MessageFormat.format(resource.getString("temporarydestination.delete_error"), this.name));
            jmse.setLinkedException(e10);
            throw jmse;
        }
    }

    public ConnectionImpl getConnectionContext() {
        return this.connectionContext;
    }
}

