/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.ConnectionFactoryImpl;
import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.client.TopicSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class TopicConnectionImpl
extends ConnectionImpl
implements TopicConnection {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    public TopicConnectionImpl(String user, String password, ConnectionFactoryImpl parent) throws JMSException {
        super(user, password, 1, parent);
    }

    public void sendMessage(int sessionID, int producerID, Message msg) throws JMSException {
        super.sendMessage(sessionID, producerID, msg);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicconnectionimpl.createtopicsession_on_closed_connection"));
        }
        TopicSessionImpl session = (TopicSessionImpl)this.createSession(1, transacted, acknowledgeMode, this);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicconnectionimpl.createconnectionconsumer_on_closed_connection"));
        }
        ConnectionConsumer consumer = this.createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages, null);
        return consumer;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicconnectionimpl.createdurableconnectionconsumer_on_closed_connection"));
        }
        ConnectionConsumer consumer = this.createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages, subscriptionName);
        return consumer;
    }
}

