/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.DurableSubscriptionDescriptor;
import com.sun.jms.TopicImpl;
import com.sun.jms.client.MessageProducerImpl;
import com.sun.jms.client.SessionImpl;
import com.sun.jms.client.TopicConnectionImpl;
import com.sun.jms.client.TopicPublisherImpl;
import com.sun.jms.client.TopicSubscriberImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class TopicSessionImpl
extends SessionImpl
implements TopicSession {
    TopicConnectionImpl tConnection;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    TopicSessionImpl(boolean isTransacted, int acknowledgeMode, TopicConnectionImpl tConnection) {
        super(isTransacted, acknowledgeMode, tConnection);
        this.tConnection = tConnection;
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsessionimpl.createtopic_on_closed_ts"));
        }
        return (Topic)this.createDestination(1, topicName);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsessionimpl.createsubscriber_on_closed_ts"));
        }
        TopicSubscriber subscriber = this.createSubscriber(topic, null, false);
        return subscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsessionimpl.createsubscriber_on_closed_ts"));
        }
        if (SessionImpl.logger.isLogging(7)) {
            SessionImpl.logger.finest("-- creating subscriber on " + topic);
        }
        TopicSubscriber subscriber = (TopicSubscriber)this.createConsumer(topic, messageSelector, null, noLocal, this);
        return subscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsessionimpl.createdurablesubscriber_on_closed_ts"));
        }
        TopicSubscriber subscriber = this.createDurableSubscriber(topic, name, null, false);
        return subscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subscriptionName, String messageSelector, boolean noLocal) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsessionimpl.createdurablesubscriber_on_closed_ts"));
        }
        String clientID = this.tConnection.getClientID();
        if (clientID == null || clientID.length() == 0) {
            throw new JMSException(resource.getString("topicsessionimpl.client_id_is_not_set"));
        }
        if (subscriptionName == null || subscriptionName.length() == 0) {
            throw new JMSException(resource.getString("topicsessionimpl.subscription_name_is_null_or_empty"));
        }
        if (topic instanceof TemporaryTopic) {
            throw new JMSException(resource.getString("topicsessionimpl.topic_is_temporary"));
        }
        if (topic == null) {
            throw new InvalidDestinationException(resource.getString("topicsessionimpl.topic_can_not_be_null"));
        }
        DurableSubscriptionDescriptor subscription = this.getDurableSubscription(subscriptionName);
        if (subscription != null) {
            if (subscription.getActive()) {
                throw new JMSException(resource.getString("topicsessionimpl.subscriber_is_active"));
            }
            String topicName = ((TopicImpl)topic).getName();
            DurableSubscriptionDescriptor newSubscription = new DurableSubscriptionDescriptor(this.parentConnection.getClientID(), subscriptionName, messageSelector, topicName, false, (TopicConnectionFactory)this.parentConnection.getConnectionFactory());
            if (!newSubscription.equals(subscription)) {
                if (SessionImpl.logger.isLogging(7)) {
                    SessionImpl.logger.finest("-- Topic and/or selector has changed. Will perform  implicit unsubscribe/subscribe. ");
                    SessionImpl.logger.finest("-- old:" + subscription + " new:" + newSubscription);
                }
                this.unsubscribe(subscriptionName);
            }
        }
        TopicSubscriberImpl subscriber = (TopicSubscriberImpl)this.createConsumer(topic, messageSelector, subscriptionName, noLocal, this);
        return subscriber;
    }

    public DurableSubscriptionDescriptor getDurableSubscription(String subscriptionName) throws JMSException {
        DurableSubscriptionDescriptor subscription = null;
        try {
            if (SessionImpl.logger.isLogging(6)) {
                SessionImpl.logger.finer("-- calling service.getDurableSubscription: " + subscriptionName);
            }
            subscription = this.service.getDurableSubscription(this.parentConnection.getClientID(), subscriptionName);
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(e10.getMessage());
            SessionImpl.logger.warning(e10);
            jmse.setLinkedException(e10);
            throw jmse;
        }
        return subscription;
    }

    private TopicSubscriberImpl getTopicSubscriber(String subscriptionName) {
        TopicSubscriberImpl subscriber = null;
        HashMap hashMap = this.consumerHashMap;
        synchronized (hashMap) {
            Iterator consumerIter = this.consumerHashMap.values().iterator();
            while (consumerIter.hasNext()) {
                TopicSubscriberImpl consumer = (TopicSubscriberImpl)consumerIter.next();
                if (!consumer.getSubscriptionName().equals(subscriptionName)) continue;
                subscriber = consumer;
                break;
            }
        }
        return subscriber;
    }

    public void unsubscribe(String subscriptionName) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsessionimpl.unsubscribe_on_closed_ts"));
        }
        try {
            DurableSubscriptionDescriptor subscription = this.getDurableSubscription(subscriptionName);
            if (subscription == null) {
                throw new InvalidDestinationException(MessageFormat.format(resource.getString("topicsessionimpl.non_existing_subscription_name"), subscriptionName));
            }
            if (subscription != null) {
                if (subscription.getActive()) {
                    throw new JMSException(resource.getString("topicsessionimpl.subscriber_is_active"));
                }
                if (SessionImpl.logger.isLogging(6)) {
                    SessionImpl.logger.finer("-- calling service.deleteDurableSubscriber: " + subscriptionName);
                }
                this.service.deleteDurableSubscription(this.parentConnection.getClientID(), subscriptionName);
            }
        }
        catch (RemoteException e10) {
            JMSException jmse = new JMSException(e10.getMessage());
            jmse.setLinkedException(e10);
            throw jmse;
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsessionimpl.createpublisher_on_closed_ts"));
        }
        if (SessionImpl.logger.isLogging(7)) {
            SessionImpl.logger.finest("-- creating publisher on " + topic);
        }
        TopicPublisher publisher = (TopicPublisher)this.createProducer(topic, this);
        return publisher;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsessionimpl.createtemporarytopic_on_closed_ts"));
        }
        TemporaryTopic tempTopic = (TemporaryTopic)this.createTemporaryDestination(1);
        return tempTopic;
    }

    protected MessageProducerImpl createMessageProducer(Destination d10, SessionImpl s2) {
        return new TopicPublisherImpl((Topic)d10, (TopicSessionImpl)s2);
    }
}

