/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.JMSClient;
import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionConsumerImpl;
import com.sun.jms.service.ConnectionMetaDataImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.service.QueueImpl;
import com.sun.jms.service.QueueSessionImpl;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.service.TopicImpl;
import com.sun.jms.service.TopicSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import com.sun.jms.util.Statistician;
import com.sun.jms.util.Statistics;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public abstract class ConnectionImpl {
    private String clientID;
    private ExceptionListener exceptionListener;
    private boolean isStopped = true;
    private boolean beingClosed = false;
    private HashMap sessionIdToSessionMap = new HashMap(11);
    private Statistician msgStatistician = new Statistician();
    protected String pclientId;
    protected int connectionId;
    static JMSServiceImpl service = JMSServiceImpl.getInstance();
    private JMSClient client = null;
    private HashMap connectionConsumerHashMap = new HashMap(3);
    Set tempDestinations = null;
    static Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    ConnectionImpl(String pclientId, int connectionId) {
        this.pclientId = pclientId;
        this.connectionId = connectionId;
        try {
            this.client = service.getJMSClient(pclientId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.msgStatistician.start();
    }

    String getGlobalyUniqueId() {
        return this.pclientId + "." + this.connectionId;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        this.clientID = clientID;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return new ConnectionMetaDataImpl();
    }

    public void start() throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("pclientid=" + this.pclientId + ", connectionId=" + this.connectionId);
        }
        this.isStopped = false;
        HashMap hashMap = this.sessionIdToSessionMap;
        synchronized (hashMap) {
            Collection sessions = this.sessionIdToSessionMap.values();
            Iterator sessionIter = sessions.iterator();
            while (sessionIter.hasNext()) {
                SessionImpl session = (SessionImpl)sessionIter.next();
                session.start();
            }
        }
        HashMap hashMap2 = this.connectionConsumerHashMap;
        synchronized (hashMap2) {
            Collection connectionConsumers = this.connectionConsumerHashMap.values();
            Iterator conconIter = connectionConsumers.iterator();
            while (conconIter.hasNext()) {
                ConnectionConsumerImpl connectionConsumer = (ConnectionConsumerImpl)conconIter.next();
                connectionConsumer.start();
            }
        }
    }

    public void stop() throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("pclientid=" + this.pclientId + ", connectionId=" + this.connectionId);
        }
        this.isStopped = true;
        if (logger.isLogging(7)) {
            logger.finest("id " + this.connectionId + " stopping child sessions");
        }
        HashMap hashMap = this.sessionIdToSessionMap;
        synchronized (hashMap) {
            Collection sessions = this.sessionIdToSessionMap.values();
            if (sessions != null) {
                Iterator sessionIter = sessions.iterator();
                while (sessionIter.hasNext()) {
                    SessionImpl session = (SessionImpl)sessionIter.next();
                    session.stop();
                }
            }
        }
    }

    public void close(boolean removeFromParent) throws JMSException {
        this.beingClosed = true;
        if (logger.isLogging(7)) {
            logger.finest("id =" + this.connectionId);
        }
        if (removeFromParent) {
            service.removeConnection(this.pclientId, this.connectionId);
        }
        this.stop();
        if (logger.isLogging(7)) {
            logger.finest("id " + this.connectionId + " closing child sessions");
        }
        HashMap hashMap = this.sessionIdToSessionMap;
        synchronized (hashMap) {
            Collection sessions = this.sessionIdToSessionMap.values();
            if (sessions != null) {
                Iterator sessionIter = sessions.iterator();
                while (sessionIter.hasNext()) {
                    SessionImpl session = (SessionImpl)sessionIter.next();
                    session.close(false);
                    sessionIter.remove();
                    session = null;
                }
            }
        }
        if (logger.isLogging(7)) {
            logger.finest("id " + this.connectionId + " closing child connection consumers");
        }
        HashMap hashMap2 = this.connectionConsumerHashMap;
        synchronized (hashMap2) {
            Collection consumers = this.connectionConsumerHashMap.values();
            if (consumers != null) {
                Iterator consumerIter = consumers.iterator();
                while (consumerIter.hasNext()) {
                    ConnectionConsumerImpl connectionConsumer = (ConnectionConsumerImpl)consumerIter.next();
                    connectionConsumer.close(false);
                    consumerIter.remove();
                    connectionConsumer = null;
                }
            }
        }
        if (logger.isLogging(7)) {
            logger.finest("id " + this.connectionId + " removing temporary destinations");
        }
        if (this.tempDestinations != null) {
            Set set = this.tempDestinations;
            synchronized (set) {
                Iterator iter = this.tempDestinations.iterator();
                while (iter.hasNext()) {
                    DestinationImpl dest = (DestinationImpl)iter.next();
                    dest.delete();
                    service.removeDestination(dest.getName());
                    dest = null;
                }
            }
        }
    }

    public abstract QueueSessionImpl createQueueSession(boolean var1, int var2) throws JMSException;

    public abstract TopicSessionImpl createTopicSession(boolean var1, int var2) throws JMSException;

    abstract int getConnectionType();

    SessionImpl createSession(int sessionId, boolean transacted, int ackMode) throws JMSException {
        if (this.beingClosed) {
            throw new JMSException(resource.getString("connectionimpl.createsession_connection_being_closed"));
        }
        SessionImpl session = null;
        session = this.getConnectionType() == 0 ? this.createQueueSession(transacted, ackMode) : this.createTopicSession(transacted, ackMode);
        session.setId(sessionId);
        this.addSession(sessionId, session);
        return session;
    }

    protected void addSession(int sessionId, SessionImpl session) {
        HashMap hashMap = this.sessionIdToSessionMap;
        synchronized (hashMap) {
            this.sessionIdToSessionMap.put(new Integer(sessionId), session);
        }
    }

    protected void removeSession(int sessionId) {
        HashMap hashMap = this.sessionIdToSessionMap;
        synchronized (hashMap) {
            this.sessionIdToSessionMap.remove(new Integer(sessionId));
        }
    }

    protected SessionImpl getSession(int sessionId) {
        HashMap hashMap = this.sessionIdToSessionMap;
        synchronized (hashMap) {
            SessionImpl session;
            SessionImpl sessionImpl = session = (SessionImpl)this.sessionIdToSessionMap.get(new Integer(sessionId));
            return sessionImpl;
        }
    }

    protected void addConnectionConsumer(ConnectionConsumerImpl connectionConsumer) {
        HashMap hashMap = this.connectionConsumerHashMap;
        synchronized (hashMap) {
            this.connectionConsumerHashMap.put(new Integer(connectionConsumer.getId()), connectionConsumer);
        }
    }

    protected void removeConnectionConsumer(int connectionConsumerID) {
        HashMap hashMap = this.connectionConsumerHashMap;
        synchronized (hashMap) {
            this.connectionConsumerHashMap.remove(new Integer(connectionConsumerID));
        }
    }

    protected ConnectionConsumerImpl getConnectionConsumer(int connectionConsumerID) {
        HashMap hashMap = this.connectionConsumerHashMap;
        synchronized (hashMap) {
            ConnectionConsumerImpl consumer;
            ConnectionConsumerImpl connectionConsumerImpl = consumer = (ConnectionConsumerImpl)this.connectionConsumerHashMap.get(new Integer(connectionConsumerID));
            return connectionConsumerImpl;
        }
    }

    public JMSClient getJMSClient() throws JMSException {
        return this.client;
    }

    public int getId() {
        return this.connectionId;
    }

    public String getPClientId() {
        return this.pclientId;
    }

    public boolean okToSendMessagesToClient() {
        return !this.isStopped && !this.beingClosed;
    }

    void addIncomingMessage(MessageImpl msg) throws JMSException {
        if (this.beingClosed) {
            throw new JMSException(resource.getString("connectionimpl.addincomingmessage_connection_being_closed"));
        }
        logger.finer(msg.toString());
        SessionImpl session = this.getSession(msg.getSessionID());
        session.addIncomingMessage(msg);
    }

    void addMessageToDestination(MessageImpl msg) throws JMSException {
        logger.finer(msg.toString());
        DestinationImpl localDest = service.getDestination(msg);
        localDest.addMessage(msg);
    }

    void sendMessage(MessageImpl msg) throws JMSException, RemoteException {
        JMSClient client = this.getJMSClient();
        logger.finer(msg.toString());
        if (msg.hasExpired()) {
            return;
        }
        int sessionId = msg.getSessionID();
        int consumerId = msg.getConsumerID();
        try {
            this.updateStatistics(msg);
            MessageImpl m2 = (MessageImpl)msg.clone();
            msg.setDeliveryCount(msg.getDeliveryCount() + 1);
            JMSClient jMSClient = client;
            synchronized (jMSClient) {
                client.sendMessage(this.getId(), sessionId, consumerId, m2);
            }
            if (logger.isLogging(6)) {
                logger.finer(msg.toString() + " has been sent");
            }
        }
        catch (RemoteException e10) {
            if (logger.isLogging(2)) {
                logger.warning(MessageFormat.format(resource.getString("connectionimpl.could_not_send_message"), e10.detail.getMessage(), msg.toString()));
            }
            if (!(e10.detail instanceof JMSException) && !this.ping(4)) {
                new DeregisterThread().start();
            }
            logger.warning(e10.detail);
            throw e10;
        }
        catch (JMSException e11) {
            logger.warning(e11);
        }
    }

    void updateStatistics(MessageImpl msg) {
        try {
            if (!msg.getJMSRedelivered()) {
                long latency = msg.getTimeSinceReceivedByServer();
                this.msgStatistician.addSample(latency);
                service.updateStatistics(msg);
                DestinationImpl localDest = service.getDestination(msg);
                localDest.updateStatistics(msg);
            }
        }
        catch (JMSException e10) {
            logger.warning(e10);
        }
    }

    public Statistics getStatistics() {
        Statistics stats = this.msgStatistician.getStatistics();
        return stats;
    }

    abstract void createConnectionConsumer(int var1, String var2, String var3, int var4, String var5) throws JMSException;

    protected void addTemporaryDestination(Destination dest) {
        if (this.tempDestinations == null) {
            this.tempDestinations = new HashSet();
        }
        Set set = this.tempDestinations;
        synchronized (set) {
            this.tempDestinations.add(dest);
        }
    }

    void removeTemporaryDestination(Destination dest) {
        Set set = this.tempDestinations;
        synchronized (set) {
            this.tempDestinations.remove(dest);
        }
    }

    public QueueImpl createQueue(String queueName, boolean isTemporary) throws JMSException {
        QueueImpl queue = new QueueImpl(queueName, isTemporary);
        if (isTemporary) {
            this.addTemporaryDestination(queue);
        }
        return queue;
    }

    TopicImpl createTopic(String name, boolean isTemporary) throws JMSException {
        TopicImpl topic = new TopicImpl(name, isTemporary);
        if (isTemporary) {
            this.addTemporaryDestination(topic);
        }
        return topic;
    }

    boolean isStopped() {
        return this.isStopped;
    }

    private boolean ping(int mode) {
        boolean alive = false;
        try {
            alive = service.pingClient(this.pclientId, this.client, mode);
        }
        catch (Throwable t2) {
            alive = false;
        }
        if (!alive && logger.isLogging(7)) {
            logger.finest("Connection " + this.pclientId + " was found to be unexpectedly inactive and has been cleaned up.");
        }
        return alive;
    }

    public boolean ping() {
        return this.ping(3);
    }

    private class DeregisterThread
    extends Thread {
        public DeregisterThread() {
            super(JMSServiceImpl.serviceThreadGroup, "jms.service Connection.DeregisterThread");
        }

        public void run() {
            try {
                service.deregisterClient(ConnectionImpl.this.pclientId);
            }
            catch (JMSException e10) {
                logger.warning(e10);
            }
        }
    }
}

