/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.DurableSubscriptionDescriptor;
import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.Consumer;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.service.selector.JMSSelector;
import com.sun.jms.service.selector.ParseException;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

abstract class ConsumerImpl
implements Consumer {
    static JMSServiceImpl service = JMSServiceImpl.getInstance();
    DestinationImpl dest = null;
    boolean hasMessageListener = false;
    JMSSelector selector;
    int id;
    static Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    public String toString() {
        return "ConsumerImpl(id=" + this.id + " selector=" + this.selector + " hasMsgListener=" + this.hasMessageListener + ")";
    }

    public ConsumerImpl(DestinationImpl dest, int id, String selectPattern) throws InvalidSelectorException, JMSException {
        this.dest = dest;
        this.id = id;
        MessageImpl msg = new MessageImpl();
        this.selector = new JMSSelector(selectPattern, msg);
        this.setSelectPattern(selectPattern);
    }

    public void preSendProcessing(MessageImpl msg, Connection con) throws JMSException {
    }

    public abstract void sendMessage(MessageImpl var1) throws JMSException;

    public abstract boolean isConnectionConsumer();

    public abstract boolean presendToClient();

    public abstract boolean awaitingSynchronousReceive();

    public abstract void deliverSynchronousMessage(MessageImpl var1);

    public abstract MessageImpl cloneForDeliveryToClient(MessageImpl var1) throws JMSException;

    MessageImpl cloneForDeliveryToClient(SessionImpl session, MessageImpl msg) throws JMSException {
        MessageImpl newMsg = (MessageImpl)msg.clone();
        ConnectionImpl connection = session.getConnection();
        newMsg.setFactoryID(connection.getPClientId());
        newMsg.setConnectionID(connection.getId());
        newMsg.setSessionID(session.getId());
        newMsg.setConsumerID(this.getId());
        return newMsg;
    }

    public synchronized void setSelectPattern(String selectPattern) throws InvalidSelectorException, JMSException {
        if (selectPattern == null) {
            selectPattern = "";
        }
        this.selector.setPattern(selectPattern);
    }

    public synchronized String getSelectPattern() throws JMSException {
        return this.selector.getPattern();
    }

    public boolean selectorMatch(MessageImpl msg) {
        boolean result;
        block4: {
            result = false;
            try {
                result = this.selector.match(msg);
            }
            catch (JMSException je) {
                if (logger.isLogging(3)) {
                    logger.info("Ignoring Exception " + je.toString());
                }
            }
            catch (ParseException pe) {
                if (!logger.isLogging(3)) break block4;
                logger.info("Ignoring Exception " + pe.toString());
            }
        }
        return result;
    }

    public abstract SessionImpl getSession();

    public void deliveredMessage(MessageImpl msg) {
    }

    public void acknowledgeMessage(MessageImpl msg) throws JMSException, SQLException {
    }

    public int getId() {
        return this.id;
    }

    public DestinationImpl getDestination() {
        return this.dest;
    }

    public abstract ConnectionImpl getConnection();

    public boolean isDurableSubscriber() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public boolean matches(String clientID, String subscriptionName) throws IllegalStateException {
        throw new IllegalStateException(resource.getString("consumerimpl.method_not_implemented_by_qr_or_qcc"));
    }

    public void initializeDurableSubscription() throws JMSException, IllegalStateException {
        throw new IllegalStateException(resource.getString("consumerimpl.method_not_implemented_by_qr_or_qcc"));
    }

    public void deleteDurableSubscription() throws JMSException, IllegalStateException {
        throw new IllegalStateException(resource.getString("consumerimpl.method_not_implemented_by_qr_or_qcc"));
    }

    public DurableSubscriptionDescriptor getDurableSubscriptionDescriptor() throws IllegalStateException {
        throw new IllegalStateException(resource.getString("consumerimpl.method_not_implemented_by_qr_or_qcc"));
    }

    public void sendLoggedMessages() throws IllegalStateException {
        throw new IllegalStateException(resource.getString("consumerimpl.method_not_implemented_by_qr_or_qcc"));
    }

    public void sendLoggedMessage(MessageImpl msg) throws JMSException, IllegalStateException {
        throw new IllegalStateException(resource.getString("consumerimpl.method_not_implemented_by_qr_or_qcc"));
    }

    public boolean getNoLocal() throws IllegalStateException {
        throw new IllegalStateException(resource.getString("consumerimpl.method_not_implemented_by_qr_or_qcc"));
    }

    public abstract boolean isStopped();

    public abstract String getClientID();
}

