/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.DestinationImpl;
import com.sun.jms.JMSInitialContext;
import com.sun.jms.JMSXAQueueConnectionFactoryImpl;
import com.sun.jms.JMSXATopicConnectionFactoryImpl;
import com.sun.jms.QueueConnectionFactoryImpl;
import com.sun.jms.TopicConnectionFactoryImpl;
import com.sun.jms.Version;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class InitialServiceContext
extends JMSInitialContext {
    public static final Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    public static final String SERVICE_LOGFILE_PROPERTY = "com.sun.jms.service.logfile";
    public static final String SERVICE_LOGLEVEL_PROPERTY = "com.sun.jms.service.loglevel";
    public static final String SERVICE_BIND_ADMIN_OBJECTS_PROPERTY = "com.sun.jms.service.bindAdministeredObjects";
    public JMSProperties jmsProps = null;
    static String hostName = null;
    private static InitialServiceContext instance = null;
    private boolean serviceBindAdministeredObjects;

    public static InitialServiceContext getInstance() {
        if (instance == null) {
            try {
                instance = new InitialServiceContext();
            }
            catch (NamingException e10) {
                logger.severe(MessageFormat.format(resource.getString("initialservicecontext.unable_to_create_isc"), e10.getMessage()));
                logger.severe(e10);
                System.exit(-1);
            }
        }
        return instance;
    }

    private InitialServiceContext() throws NamingException {
        this(hostName);
    }

    InitialServiceContext(String url) throws NamingException {
        instance = this;
        this.jmsProps = JMSProperties.getInstance();
        this.initializeLog();
        if (Boolean.valueOf(this.jmsProps.getProperty(SERVICE_BIND_ADMIN_OBJECTS_PROPERTY)).booleanValue()) {
            this.serviceBindAdministeredObjects = true;
            this.bindConnectionFactories(url);
        } else {
            this.serviceBindAdministeredObjects = false;
        }
    }

    void bindConnectionFactories(String serverURL) {
        try {
            InitialContext context = this.getExternalContext();
            if (logger.isLogging(5)) {
                logger.fine("Binding Connection Factories to " + context);
            }
            context.rebind("QueueConnectionFactory", (Object)new QueueConnectionFactoryImpl(serverURL));
            context.rebind("TopicConnectionFactory", (Object)new TopicConnectionFactoryImpl(serverURL));
            context.rebind("JMSXAQueueConnectionFactory", (Object)new JMSXAQueueConnectionFactoryImpl(serverURL));
            context.rebind("JMSXATopicConnectionFactory", (Object)new JMSXATopicConnectionFactoryImpl(serverURL));
        }
        catch (Exception e10) {
            logger.severe(MessageFormat.format(resource.getString("initialservicecontext.unable_to_bind_factories"), e10.getMessage()));
            logger.severe(e10);
            System.exit(-1);
        }
    }

    void initializeLog() {
        int logLevel = 10;
        try {
            logLevel = Integer.parseInt(this.jmsProps.getProperty(SERVICE_LOGLEVEL_PROPERTY));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.initialize(this.jmsProps.getProperty(SERVICE_LOGFILE_PROPERTY), logLevel);
        logger.debugInfo("Java(TM) Message Service 1.0.2 Reference Implementation (build " + Version.JMS_FULL_VERSION + ")");
    }

    void bindDestination(DestinationImpl destination) {
        if (this.serviceBindAdministeredObjects) {
            String name = destination.getName();
            try {
                InitialContext context = this.getExternalContext();
                context.rebind(name, (Object)destination);
                logger.info("Bound destination " + name + " into JNDI Namespace");
            }
            catch (NamingException e10) {
                logger.warning(e10);
            }
        }
    }

    void unbindDestination(DestinationImpl destination) {
        if (this.serviceBindAdministeredObjects) {
            String name = destination.getName();
            try {
                InitialContext context = this.getExternalContext();
                context.unbind(name);
                logger.info("Unbound destination " + name + " from JNDI Namespace");
            }
            catch (NamingException e10) {
                logger.warning(e10);
            }
        }
    }

    void purgeAllDestinations() {
        InitialContext context = this.getExternalContext();
        try {
            NamingEnumeration<NameClassPair> ne = context.list("");
            while (ne.hasMore()) {
                NameClassPair ncp;
                Object o2 = ne.nextElement();
                if (!(o2 instanceof NameClassPair) || !(ncp = (NameClassPair)o2).getClassName().equals("com.sun.jms.QueueImpl") && !ncp.getClassName().equals("com.sun.jms.TopicImpl")) continue;
                if (logger.isLogging(5)) {
                    logger.fine("Unbinding: " + ncp.getName());
                }
                context.unbind(ncp.getName());
            }
        }
        catch (Exception e10) {
            logger.warning(e10);
        }
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e10) {
            logger.severe(resource.getString("initialservicecontext.defaulting_to_localhost"));
            hostName = "localhost";
        }
    }
}

