/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.JMSService;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.spi.ExternalManager;
import com.sun.jms.spi.JMSManager;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.text.MessageFormat;
import javax.jms.JMSException;

public class JMSManagerImpl
implements JMSManager {
    public static final Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    private JMSService jmsService = null;
    private ExternalManager externalManager = null;
    private JMSProperties jmsProps = null;

    public void setExternalManager(ExternalManager mgr) {
        this.externalManager = mgr;
    }

    public ExternalManager getExternalManager() {
        return this.externalManager;
    }

    public void startJMSService() throws JMSException {
        if (this.jmsService != null) {
            throw new JMSException(resource.getString("jmsmanagerimpl.service_is_already_started"));
        }
        try {
            this.jmsProps = JMSProperties.getInstance();
            int logLevel = 10;
            try {
                logLevel = Integer.parseInt(this.jmsProps.getProperty("com.sun.jms.service.loglevel"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.externalManager != null) {
                Log.initialize(this.externalManager.getErrorLog(), this.externalManager.getOutputLog(), logLevel);
            } else {
                Log.initialize(this.jmsProps.getProperty("com.sun.jms.service.logfile"), logLevel);
            }
            JMSServiceImpl.setExternalManager(this.externalManager);
            this.jmsService = JMSServiceImpl.getInstance();
        }
        catch (Throwable t2) {
            this.jmsService = null;
            logger.severe(t2);
            throw new JMSException(resource.getString("jmsmanagerimpl.cant_start_service"));
        }
    }

    public void stopJMSService() throws JMSException {
        if (this.jmsService == null) {
            throw new JMSException(resource.getString("jmsmanagerimpl.service_isnt_running"));
        }
        try {
            this.jmsService.stop();
            this.jmsService = null;
        }
        catch (Throwable t2) {
            this.jmsService = null;
            throw new JMSException(MessageFormat.format(resource.getString("jmsmanagerimpl.cant_stop_service"), t2.getMessage()));
        }
    }
}

