/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.service.DBManager;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.InitialServiceContext;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.service.QueueImpl;
import com.sun.jms.service.TopicImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.jms.JMSException;

public class ServiceRecoveryManager {
    private static ServiceRecoveryManager instance = null;
    private DBManager dbManager = DBManager.getInstance();
    static Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    private ServiceRecoveryManager() {
        instance = this;
    }

    public static ServiceRecoveryManager getInstance() {
        if (instance == null) {
            new ServiceRecoveryManager();
        }
        return instance;
    }

    public void recover() {
        block2: {
            try {
                this.recoverDestinations();
            }
            catch (JMSException jmse) {
                if (!logger.isLogging(2)) break block2;
                logger.warning(resource.getString("servicerecoverymanager.error_recoving_destinations_from_db"));
                logger.warning(jmse);
            }
        }
    }

    /*
     * Loose catch block
     */
    void recoverDestinations() throws JMSException {
        Connection con;
        block12: {
            String LOAD_DESTINATIONS_SELECTOR = "SELECT * FROM destination";
            con = null;
            Statement s2 = null;
            ResultSet rs = null;
            InitialServiceContext.getInstance().purgeAllDestinations();
            con = this.dbManager.getDBConnection();
            s2 = con.createStatement();
            rs = DBManager.executeQuery(s2, "SELECT * FROM destination");
            while (rs.next()) {
                DestinationImpl dest = this.createDestinationFromDBRow(rs);
                JMSServiceImpl.getInstance().addDestination(dest.getName(), dest);
            }
            Object var8_7 = null;
            try {
                if (s2 != null) {
                    s2.close();
                }
                if (rs != null) {
                    rs.close();
                }
                break block12;
            }
            catch (SQLException sqle) {
                logger.warning(sqle);
            }
            {
                break block12;
                catch (SQLException sqle) {
                    JMSException jmse = new JMSException(resource.getString("servicerecoverymanager.error_recoving_destinations_from_db"));
                    jmse.setLinkedException(sqle);
                    throw jmse;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (s2 != null) {
                        s2.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    logger.warning(sqle);
                }
                this.dbManager.closeDBConnection(con);
                throw throwable;
            }
        }
        this.dbManager.closeDBConnection(con);
    }

    DestinationImpl createDestinationFromDBRow(ResultSet rs) throws SQLException {
        String name = rs.getString("dest_name");
        int type = rs.getInt("dest_type");
        int maxMsgs = rs.getInt("max_messages");
        int maxBytes = rs.getInt("max_bytes");
        if (logger.isLogging(6)) {
            logger.finer("\trecovering destination: " + name + ":" + type + ":" + maxMsgs + ":" + maxBytes);
        }
        DestinationImpl dest = null;
        if (type == 0) {
            dest = new QueueImpl(name, false, false);
        } else if (type == 1) {
            dest = new TopicImpl(name, false, false);
        } else {
            logger.warning(MessageFormat.format(resource.getString("servicerecoverymanager.unknown_dest_type"), new Integer(type)));
        }
        dest.updateMaxMessages(maxMsgs, false);
        dest.updateMaxBytes(maxBytes, false);
        return dest;
    }
}

