/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.Acknowledgement;
import com.sun.jms.JMSClient;
import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.service.MessageConsumerImpl;
import com.sun.jms.service.SystemMessage;
import com.sun.jms.service.TopicSubscriberImpl;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import com.sun.jms.util.Waiter;
import com.sun.jms.util.WaiterManager;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionRolledBackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public abstract class SessionImpl {
    public static final Logger logger = Log.getLogger(1);
    public static final Logger stoplogger = Log.getLogger(7);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    static final int ALL_MESSAGES = -1;
    static final int ALL_CONSUMERS = -1;
    boolean stopMessageDelivery = true;
    private boolean transacted = false;
    private boolean globalTransaction = false;
    private boolean isCommitting = false;
    private Xid currentXid = null;
    String transactionID = null;
    int acknowledgeMode = 1;
    int id;
    ConnectionImpl parentConnection;
    private boolean beingClosed = false;
    private ArrayList producers = null;
    private ArrayList incomingTxMessages = null;
    private Set destinations = null;
    private HashMap consumers = null;
    private ArrayList outgoingMessages = null;
    private Waiter outgoingMessageWaiter;
    private HashMap awaitingAckMessages;
    private HashMap acknowledgedMsgs = null;
    static JMSServiceImpl service = JMSServiceImpl.getInstance();
    Connection dbConnection;
    Connection saveDbConnection;
    PreparedStatement insertMsgStmt;
    PreparedStatement deleteMsgStmt;
    PreparedStatement saveInsertMsgStmt;
    PreparedStatement saveDeleteMsgStmt;
    static int maxRedeliveryAttempts = SessionImpl.getMaxRedeliveryAttempts();

    SessionImpl(ConnectionImpl parentConnection) {
        this(parentConnection, false, 1);
    }

    SessionImpl(ConnectionImpl parentConnection, boolean isTransacted, int acknowledgeMode) {
        try {
            this.dbConnection = DBManager.getInstance().getDBConnection();
            if (isTransacted) {
                this.prepareJDBCTransaction();
            }
            this.createPreparedStatements();
        }
        catch (SQLException sqle) {
            logger.warning(sqle);
        }
        this.parentConnection = parentConnection;
        this.transacted = isTransacted;
        this.acknowledgeMode = acknowledgeMode;
        this.stopMessageDelivery = parentConnection.isStopped();
    }

    static int getMaxRedeliveryAttempts() {
        int attempts = 8;
        try {
            String attemptsProp = JMSProperties.getInstance().getProperty("com.sun.jms.service.max_redelivery_attempts");
            if (attemptsProp != null) {
                attempts = Integer.valueOf(attemptsProp);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return attempts;
    }

    public Connection getDBConnection() {
        return this.dbConnection;
    }

    void createPreparedStatements() throws SQLException {
        this.insertMsgStmt = this.dbConnection.prepareStatement("INSERT INTO message VALUES ( ?, ?, ?, ? )");
        this.deleteMsgStmt = this.dbConnection.prepareStatement("DELETE FROM message WHERE msg_id = ?");
    }

    void persistMessage(MessageImpl msg) throws JMSException {
        block6: {
            DestinationImpl d10 = service.getDestination(msg);
            if (d10.hasCapacity()) {
                try {
                    Connection connection = this.dbConnection;
                    synchronized (connection) {
                        msg.store(this.dbConnection, this.insertMsgStmt);
                        break block6;
                    }
                }
                catch (SQLException e10) {
                    JMSException jmse = new JMSException(resource.getString("sessionimpl.caught_sqlexception"));
                    jmse.setLinkedException(e10);
                    throw jmse;
                }
            }
            logger.severe(MessageFormat.format(resource.getString("sessionimpl.no_db_capacity"), d10.getName()));
        }
    }

    public boolean getTransacted() throws JMSException {
        return this.transacted;
    }

    String getGlobalyUniqueId() {
        return this.parentConnection.getGlobalyUniqueId() + "." + this.id;
    }

    private void destinationsClear() {
        if (this.destinations != null) {
            this.destinations.clear();
        }
    }

    private void acknowledgedMsgsClear() {
        if (this.acknowledgedMsgs != null) {
            this.acknowledgedMsgs.clear();
        }
    }

    private void initTransactionID() {
        this.transactionID = this.getGlobalyUniqueId() + ".1";
    }

    private String getLastToken(String string) {
        StringTokenizer st = new StringTokenizer(string, ".");
        String lastToken = null;
        while (st.hasMoreTokens()) {
            lastToken = st.nextToken();
        }
        return lastToken;
    }

    private void renewTransactionID() {
        String newID;
        this.transactionID = newID = this.getGlobalyUniqueId() + "." + String.valueOf(Integer.parseInt(this.getLastToken(this.transactionID)) + 1);
    }

    String getTransactionID() {
        return this.globalTransaction ? this.currentXid.toString() : this.transactionID;
    }

    private boolean awaitingAckMessagesContains(Acknowledgement ack) {
        return this.awaitingAckMessages.containsKey(ack);
    }

    public void commit(Collection acks) throws JMSException {
        boolean rolledBack = false;
        if (logger.isLogging(6)) {
            logger.finer("TxID=" + this.getTransactionID() + ", start");
        }
        if (this.isGlobalTxn()) {
            throw new TransactionInProgressException(MessageFormat.format(resource.getString("sessionimpl.in_global_transaction"), this.currentXid));
        }
        if (!this.transacted) {
            throw new IllegalStateException(resource.getString("sessionimpl.cannot_commit_a_non_transacted_session"));
        }
        this.isCommitting = true;
        this.stop();
        try {
            try {
                this.prepareToSend();
                this.receivingCommit(acks);
                this.commitJDBCTransaction();
                this.sendingCommit();
            }
            catch (TransactionRolledBackException trbe) {
                rolledBack = true;
                this.rollback();
                throw trbe;
            }
            catch (Throwable t2) {
                rolledBack = true;
                logger.warning(t2);
                this.rollback();
                throw new TransactionRolledBackException(resource.getString("sessionimpl.internal_failure"));
            }
            Object var6_3 = null;
            this.destinationsClear();
            this.acknowledgedMsgsClear();
            if (logger.isLogging(6)) {
                logger.finer("TxID=" + this.getTransactionID() + ": end");
            }
            this.renewTransactionID();
            this.isCommitting = false;
            if (!rolledBack) {
                this.start();
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.destinationsClear();
            this.acknowledgedMsgsClear();
            if (logger.isLogging(6)) {
                logger.finer("TxID=" + this.getTransactionID() + ": end");
            }
            this.renewTransactionID();
            this.isCommitting = false;
            if (!rolledBack) {
                this.start();
            }
            throw throwable;
        }
    }

    private void prepareJDBCTransaction() throws SQLException {
        this.dbConnection.setAutoCommit(false);
    }

    private void commitJDBCTransaction() throws TransactionRolledBackException {
        try {
            this.dbConnection.commit();
        }
        catch (SQLException sqle) {
            TransactionRolledBackException trbe = new TransactionRolledBackException(resource.getString("sessionimpl.unable_to_commit_transaction"));
            trbe.setLinkedException(sqle);
            logger.warning(trbe);
            throw trbe;
        }
    }

    private void rollbackJDBCTransaction() throws JMSException {
        try {
            this.dbConnection.rollback();
        }
        catch (SQLException sqle) {
            JMSException jmse = new JMSException(resource.getString("sessionimpl.unable_to_rollback_transaction"));
            jmse.setLinkedException(sqle);
            throw jmse;
        }
    }

    private void prepareToSend() throws TransactionRolledBackException {
        if (logger.isLogging(7)) {
            logger.finest("TxID=" + this.getTransactionID() + ", start");
        }
        if (this.hadMsgProducer()) {
            ArrayList arrayList = this.incomingTxMessages;
            synchronized (arrayList) {
                try {
                    Iterator msgIter = ((AbstractList)this.incomingTxMessages).iterator();
                    while (msgIter.hasNext()) {
                        MessageImpl msg = (MessageImpl)msgIter.next();
                        if (service.isPersistentMessage(msg)) {
                            this.persistMessage(msg);
                        }
                        DestinationImpl localDest = service.getDestination(msg);
                        localDest.prepareToSend(this.transactionID, msg);
                        this.destinations.add(localDest);
                        msgIter.remove();
                    }
                }
                catch (Throwable e10) {
                    throw new TransactionRolledBackException(resource.getString("sessionimpl.prepare_to_send_failed"));
                }
            }
        }
    }

    private void receivingCommit(Collection acks) throws TransactionRolledBackException {
        if (this.hadMsgConsumer()) {
            MessageImpl msg = null;
            Waiter waiter = this.outgoingMessageWaiter;
            synchronized (waiter) {
                try {
                    Iterator ackIter = acks.iterator();
                    while (ackIter.hasNext()) {
                        Acknowledgement ack = (Acknowledgement)ackIter.next();
                        msg = this.acknowledgeMessage(ack);
                        this.acknowledgedMsgs.put(ack, msg);
                    }
                }
                catch (Throwable je) {
                    throw new TransactionRolledBackException(resource.getString("sessionimpl.acknowledging_received_messages_failed"));
                }
            }
        }
    }

    private void sendingCommit() {
        if (this.hadMsgProducer()) {
            if (logger.isLogging(6)) {
                logger.finer("TxID=" + this.getTransactionID() + ", destinations.size=" + this.destinations.size());
            }
            ArrayList arrayList = this.incomingTxMessages;
            synchronized (arrayList) {
                Iterator destIter = this.destinations.iterator();
                DestinationImpl dest = null;
                while (destIter.hasNext()) {
                    dest = (DestinationImpl)destIter.next();
                    dest.sendingCommit(this.transactionID);
                }
            }
        }
    }

    public void rollback() throws JMSException {
        this.rollback(null);
    }

    public void rollback(Collection acks) throws JMSException {
        try {
            Object object;
            if (logger.isLogging(6)) {
                logger.finer("TxID=" + this.getTransactionID());
            }
            if (this.isGlobalTxn()) {
                throw new TransactionInProgressException(MessageFormat.format(resource.getString("sessionimpl.in_global_transaction"), this.currentXid));
            }
            if (!this.transacted) {
                throw new IllegalStateException(resource.getString("sessionimpl.cannot_rollback_a_non_transacted_session"));
            }
            this.stop();
            if (this.hadMsgProducer()) {
                object = this.incomingTxMessages;
                synchronized (object) {
                    SessionImpl.clearMessages(this.incomingTxMessages, true);
                    this.undoPrepareToSend();
                }
            }
            if (this.hadMsgConsumer()) {
                object = this.outgoingMessageWaiter;
                synchronized (object) {
                    this.recoverAwaitingAckMessages(this.acknowledgedMsgs);
                }
            }
            this.rollbackJDBCTransaction();
            this.destinationsClear();
            this.acknowledgedMsgsClear();
            this.renewTransactionID();
            if (logger.isLogging(7) && this.hadMsgConsumer()) {
                logger.finest("awaitingAckMessages=" + this.awaitingAckMessages.keySet());
                logger.finest("outgoingMessages=" + this.outgoingMessages);
            }
            this.resendUnAckedMessages();
            if (logger.isLogging(6)) {
                logger.finer("sessionId = " + this.getGlobalyUniqueId() + ", end");
            }
        }
        catch (Throwable t2) {
            logger.warning(t2);
        }
    }

    private synchronized void undoPrepareToSend() {
        if (this.hadMsgProducer() && this.destinations.size() != 0) {
            Iterator destIter = this.destinations.iterator();
            DestinationImpl dest = null;
            while (destIter.hasNext()) {
                dest = (DestinationImpl)destIter.next();
                dest.undoPrepareToSend(this.transactionID);
            }
        }
    }

    static void clearMessages(Collection messages, boolean remove) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        Iterator msgIter = messages.iterator();
        MessageImpl msg = null;
        while (msgIter.hasNext()) {
            msg = (MessageImpl)msgIter.next();
            try {
                if (remove) {
                    service.removeMessage(msg);
                }
            }
            catch (JMSException e10) {
                logger.fine(e10);
            }
            msgIter.remove();
        }
    }

    private void recoverAwaitingAckMessages(HashMap acknowledgedMsgs) {
        if (acknowledgedMsgs.size() == 0) {
            return;
        }
        this.addAwaitingAckMessages(acknowledgedMsgs);
        acknowledgedMsgs.clear();
    }

    private boolean isCommitted() {
        if (this.isCommitting) {
            return true;
        }
        if (this.incomingTxMessages != null && !this.incomingTxMessages.isEmpty()) {
            return false;
        }
        if (this.outgoingMessages != null && !this.outgoingMessages.isEmpty()) {
            return false;
        }
        return this.awaitingAckMessages == null || this.awaitingAckMessages.isEmpty();
    }

    boolean isGlobalTxn() {
        return this.globalTransaction;
    }

    private boolean isIncomingBufferEmpty() {
        if (this.incomingTxMessages == null) {
            return true;
        }
        return this.incomingTxMessages.isEmpty();
    }

    public void xaStart(Xid xid) throws JMSException, XAException {
        this.currentXid = xid;
        this.globalTransaction = true;
    }

    public void xaEndSetup(Connection tmpConnection, ArrayList txnMessages) throws JMSException {
        try {
            this.xaSaveConnection();
            this.dbConnection = tmpConnection;
            this.createPreparedStatements();
        }
        catch (SQLException e10) {
            logger.warning(e10);
        }
        if (this.hadMsgProducer()) {
            ArrayList arrayList = this.incomingTxMessages;
            synchronized (arrayList) {
                txnMessages.addAll(this.incomingTxMessages);
                SessionImpl.clearMessages(this.incomingTxMessages, false);
            }
        }
    }

    public void xaEndCleanup() throws JMSException {
        this.globalTransaction = false;
        this.currentXid = null;
    }

    void xaSaveConnection() {
        this.saveDbConnection = this.dbConnection;
        this.saveInsertMsgStmt = this.insertMsgStmt;
        this.saveDeleteMsgStmt = this.deleteMsgStmt;
    }

    void xaRestoreConnection() {
        try {
            try {
                this.insertMsgStmt.close();
                this.deleteMsgStmt.close();
            }
            catch (Throwable t2) {
                logger.warning(t2);
                Object var3_2 = null;
                this.dbConnection = this.saveDbConnection;
                this.insertMsgStmt = this.saveInsertMsgStmt;
                this.deleteMsgStmt = this.saveDeleteMsgStmt;
            }
            Object var3_1 = null;
            this.dbConnection = this.saveDbConnection;
            this.insertMsgStmt = this.saveInsertMsgStmt;
            this.deleteMsgStmt = this.saveDeleteMsgStmt;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dbConnection = this.saveDbConnection;
            this.insertMsgStmt = this.saveInsertMsgStmt;
            this.deleteMsgStmt = this.saveDeleteMsgStmt;
            throw throwable;
        }
    }

    private void performClose(boolean removeFromParent) {
        Cloneable cloneable;
        if (logger.isLogging(7)) {
            logger.finest("TxID=" + this.getTransactionID() + ",  id " + this.id + " entered");
        }
        if (removeFromParent) {
            this.parentConnection.removeSession(this.id);
        }
        if (this.hadMsgConsumer()) {
            cloneable = this.consumers;
            synchronized (cloneable) {
                Collection _consumers = this.consumers.values();
                if (_consumers != null) {
                    Iterator iter = _consumers.iterator();
                    while (iter.hasNext()) {
                        MessageConsumerImpl consumer = (MessageConsumerImpl)iter.next();
                        try {
                            consumer.close(false);
                        }
                        catch (JMSException e10) {
                            logger.warning(e10);
                        }
                        iter.remove();
                        consumer = null;
                    }
                }
            }
        }
        if ((this.transacted || this.globalTransaction) && this.hadMsgProducer()) {
            cloneable = this.incomingTxMessages;
            synchronized (cloneable) {
                SessionImpl.clearMessages(this.incomingTxMessages, true);
            }
        }
        this.redeliverOutgoingMessages();
        try {
            this.insertMsgStmt.close();
            this.deleteMsgStmt.close();
            this.dbConnection.close();
        }
        catch (Throwable t2) {
            logger.fine(t2);
        }
    }

    public void close(boolean removeFromParent) throws JMSException {
        if (this.beingClosed) {
            if (logger.isLogging(2)) {
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.already_closed"), this.getGlobalyUniqueId(), new Integer(this.id)));
            }
            return;
        }
        this.beingClosed = true;
        if (logger.isLogging(7)) {
            logger.finest("sessionID=" + this.getGlobalyUniqueId() + ", id " + this.id);
        }
        if (this.hadMsgConsumer()) {
            this.suspendProcessingOutgoingMessages();
            this.outgoingMessageWaiter.stopRunning();
        }
        this.performClose(removeFromParent);
        if (logger.isLogging(6)) {
            logger.finer("sessionID=" + this.getGlobalyUniqueId() + ", id " + this.id + " done");
        }
    }

    public void recover() throws JMSException {
        if (logger.isLogging(5)) {
            logger.fine("sessionID=" + this.getGlobalyUniqueId() + ", start");
        }
        if (this.transacted || this.isGlobalTxn()) {
            throw new IllegalStateException(resource.getString("sessionimpl.should_not_recover_a_transacted_session"));
        }
        this.stop();
        this.resendUnAckedMessages();
    }

    int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
        if (this.transacted) {
            this.initTransactionID();
        }
    }

    ConnectionImpl getConnection() {
        return this.parentConnection;
    }

    void createMessageConsumer(int consumerId, String destinationName) throws JMSException {
        if (this.beingClosed) {
            throw new JMSException(resource.getString("sessionimpl.being_closed"));
        }
        this.initConsumerInstances();
    }

    void prepareForConnectionConsumerUse() throws JMSException {
        if (this.beingClosed) {
            throw new JMSException(resource.getString("sessionimpl.being_closed"));
        }
        this.initConsumerInstances();
    }

    private boolean hadMsgConsumer() {
        return this.consumers != null;
    }

    private void initConsumerInstances() {
        if (!this.hadMsgConsumer()) {
            this.consumers = new HashMap(5);
            this.outgoingMessages = new ArrayList();
            this.awaitingAckMessages = new HashMap(11);
            if (this.transacted) {
                this.acknowledgedMsgs = new HashMap(11);
            }
            this.outgoingMessageWaiter = new Waiter(JMSServiceImpl.serviceThreadGroup, new WaiterManager(){

                public void activityDetected() {
                    SessionImpl.this.processOutgoingMessages(null);
                }
            }, "jms.service Session.outgoingWaiter." + this.getGlobalyUniqueId());
        }
    }

    private boolean hadMsgProducer() {
        return this.producers != null;
    }

    private void initProducerInstances() {
        if (!this.hadMsgProducer()) {
            this.producers = new ArrayList();
            this.incomingTxMessages = new ArrayList();
            if (this.transacted) {
                this.destinations = new HashSet();
            }
        }
    }

    void createMessageProducer(int producerId, String destinationName) throws JMSException {
        if (this.beingClosed) {
            throw new JMSException(resource.getString("sessionimpl.being_closed"));
        }
        this.initProducerInstances();
    }

    void addIncomingMessage(MessageImpl msg) throws JMSException {
        if (this.beingClosed) {
            throw new JMSException(resource.getString("sessionimpl.being_closed"));
        }
        if (logger.isLogging(6)) {
            logger.finer("sessionID=" + this.getGlobalyUniqueId() + " \"" + msg + "\"");
        }
        msg.receivedByServer();
        if (!this.transacted && !this.isGlobalTxn()) {
            if (service.isPersistentMessage(msg)) {
                this.persistMessage(msg);
            }
            this.addMessageToDestination(msg);
        }
        if (this.transacted || this.isGlobalTxn()) {
            ArrayList arrayList = this.incomingTxMessages;
            synchronized (arrayList) {
                this.incomingTxMessages.add(msg);
            }
        }
    }

    void addOutgoingMessage(MessageImpl msg) {
        Waiter waiter = this.outgoingMessageWaiter;
        synchronized (waiter) {
            if (logger.isLogging(7)) {
                logger.finest("sessionID=" + this.getGlobalyUniqueId() + ", adding " + msg);
            }
            if (SystemMessage.isStopMessage(msg)) {
                this.outgoingMessages.add(0, msg);
            } else {
                this.outgoingMessages.add(msg);
            }
            this.outgoingMessageWaiter.wakeup();
        }
    }

    void addOutgoingMessages(Collection messages) {
        this.addOutgoingMessages(messages, false);
    }

    void addOutgoingMessages(Collection messages, boolean begin) {
        Waiter waiter = this.outgoingMessageWaiter;
        synchronized (waiter) {
            if (begin) {
                this.outgoingMessages.addAll(0, messages);
            } else {
                this.outgoingMessages.addAll(messages);
            }
            this.outgoingMessageWaiter.wakeup();
        }
    }

    private boolean hasConsumers() {
        if (logger.isLogging(6)) {
            logger.finer("sessionID=" + this.getGlobalyUniqueId() + ", consumers.size=" + this.consumers.size());
        }
        return !this.hadMsgConsumer() || this.consumers.size() != 0;
    }

    private void processOutgoingStopMessage(MessageImpl msg) {
        if (logger.isLogging(7)) {
            logger.finest("TxID=" + this.getTransactionID() + ", sessionID = " + this.getGlobalyUniqueId() + ", calling outgoingMessageWaiter.suspendRunning()");
        }
        this.outgoingMessageWaiter.suspendRunning();
        if (logger.isLogging(7)) {
            logger.finest("TxID=" + this.getTransactionID() + "sessionID = " + this.getGlobalyUniqueId() + ", about to notify");
        }
        MessageImpl messageImpl = msg;
        synchronized (messageImpl) {
            SystemMessage.wakeup(msg);
        }
        if (logger.isLogging(7)) {
            logger.finest("TxID=" + this.getTransactionID() + "sessionID = " + this.getGlobalyUniqueId() + ",  done notify");
        }
    }

    private MessageImpl processOutgoingMessages(MessageConsumerImpl synchronousMessageConsumer) {
        boolean okToSend = this.parentConnection.okToSendMessagesToClient();
        if (logger.isLogging(6)) {
            logger.finer("TxID=" + this.getTransactionID() + "sessionID = " + this.getGlobalyUniqueId() + ",  okayToSend=" + okToSend + "Synchronous Msg Consumer=" + (synchronousMessageConsumer != null));
            if (logger.isLogging(7)) {
                logger.finest("outgoingMessages=" + this.outgoingMessages);
            }
        }
        Iterator msgIter = ((AbstractList)this.outgoingMessages).iterator();
        while (msgIter.hasNext()) {
            MessageImpl msg = (MessageImpl)msgIter.next();
            if (SystemMessage.isStopMessage(msg)) {
                this.processOutgoingStopMessage(msg);
                msgIter.remove();
                continue;
            }
            if (this.isStopped() || !this.parentConnection.okToSendMessagesToClient()) continue;
            try {
                if (msg.hasExpired()) {
                    msgIter.remove();
                    service.removeMessage(msg);
                    continue;
                }
                int consumerId = msg.getConsumerID();
                ConsumerImpl consumer = this.getConsumer(consumerId);
                if (consumer == null) {
                    if (!logger.isLogging(2)) continue;
                    logger.warning(MessageFormat.format(resource.getString("sessionimpl.detected_message_with_no_consumer"), new Integer(consumerId)));
                    continue;
                }
                if (synchronousMessageConsumer == null) {
                    if (consumer.awaitingSynchronousReceive()) {
                        msgIter.remove();
                        consumer.deliverSynchronousMessage(msg);
                        continue;
                    }
                    if (!consumer.presendToClient()) continue;
                    if (msg.getDeliveryCount() >= maxRedeliveryAttempts) {
                        msgIter.remove();
                        service.removeMessage(msg);
                        if (msg.getCloseMessageForServerSession() == 1) {
                            msg.setCloseMessageForServerSession(2);
                            this.parentConnection.sendMessage(msg);
                        }
                        if (!logger.isLogging(2)) continue;
                        logger.warning(MessageFormat.format(resource.getString("sessionimpl.max_redeliveries_exceeded"), new String(msg.toString()), new Integer(maxRedeliveryAttempts)));
                        continue;
                    }
                    msgIter.remove();
                    this.addAwaitingAckMessage(msg);
                    consumer.deliveredMessage(msg);
                    this.parentConnection.sendMessage(msg);
                    continue;
                }
                if (synchronousMessageConsumer != consumer) continue;
                msgIter.remove();
                return msg;
            }
            catch (RemoteException e10) {
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.ignoring_remote_exception"), e10.getMessage()));
                logger.warning(e10);
                break;
            }
            catch (JMSException e11) {
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.ignoring_remote_exception"), e11.getMessage()));
                logger.warning(e11);
            }
            catch (NullPointerException npe) {
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.npe"), msg.toString()));
                logger.warning(npe);
            }
        }
        return null;
    }

    private void addMessageToDestination(MessageImpl msg) throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("sessionID=" + this.getGlobalyUniqueId() + ", \"" + msg + "\" )");
        }
        try {
            DestinationImpl localDest = service.getDestination(msg);
            localDest.addMessage(msg);
        }
        catch (JMSException e10) {
            logger.warning(MessageFormat.format(resource.getString("sessionimpl.could_not_deliver_message"), msg.toString(), msg.getDestinationName(), e10.getMessage()));
        }
    }

    void getUnAckedMessages(List unAckedMessages, int consumerId, boolean clearUnAcked) {
        unAckedMessages.clear();
        HashMap hashMap = this.awaitingAckMessages;
        synchronized (hashMap) {
            Iterator iter = this.awaitingAckMessages.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                MessageImpl msg = (MessageImpl)entry.getValue();
                if (consumerId != -1 && consumerId != msg.getConsumerID()) continue;
                unAckedMessages.add(msg);
                if (!clearUnAcked) continue;
                iter.remove();
            }
        }
        Collections.sort(unAckedMessages, MessageImpl.MessageIDComparator.getInstance());
        if (logger.isLogging(7)) {
            logger.finest("sessionID=" + this.getGlobalyUniqueId() + ", unAckedMessages.size= " + unAckedMessages.size());
            logger.finest("unackedMessages=" + unAckedMessages);
        }
    }

    void getUnAckedMessages(List unAckedMessages, boolean clearUnAcked) {
        this.getUnAckedMessages(unAckedMessages, -1, clearUnAcked);
    }

    void clearUnAckedMessages() {
        HashMap hashMap = this.awaitingAckMessages;
        synchronized (hashMap) {
            this.awaitingAckMessages.clear();
        }
    }

    private void addAwaitingAckMessages(HashMap messages) {
        HashMap hashMap = this.awaitingAckMessages;
        synchronized (hashMap) {
            this.awaitingAckMessages.putAll(messages);
        }
    }

    void addAwaitingAckMessage(MessageImpl msg) throws JMSException {
        Acknowledgement amkey = new Acknowledgement(msg);
        if (logger.isLogging(6)) {
            logger.finer("sessionID=" + this.getGlobalyUniqueId() + ", add " + amkey + ",  msg=" + msg.toString());
        }
        HashMap hashMap = this.awaitingAckMessages;
        synchronized (hashMap) {
            this.awaitingAckMessages.put(amkey, msg);
        }
    }

    void resendUnAckedMessages() throws JMSException {
        if (logger.isLogging(6)) {
            logger.finer("sessionID=" + this.getGlobalyUniqueId());
        }
        if (this.hadMsgConsumer()) {
            HashMap hashMap = this.consumers;
            synchronized (hashMap) {
                ArrayList messagesToRedeliver = new ArrayList();
                this.getUnAckedMessages(messagesToRedeliver, true);
                Iterator iter = ((AbstractList)messagesToRedeliver).iterator();
                while (iter.hasNext()) {
                    MessageImpl msg = (MessageImpl)iter.next();
                    msg.setJMSRedelivered(true);
                }
                this.addOutgoingMessages(messagesToRedeliver, true);
            }
        }
    }

    public JMSClient getJMSClient() throws JMSException {
        JMSClient client = this.parentConnection.getJMSClient();
        return client;
    }

    void sendMessage(MessageImpl msg) throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("sessionID=" + this.getGlobalyUniqueId() + "message= " + "\"" + msg + "\" )");
        }
        this.addOutgoingMessage(msg);
    }

    protected void addConsumer(MessageConsumerImpl consumer) {
        HashMap hashMap = this.consumers;
        synchronized (hashMap) {
            this.consumers.put(new Integer(consumer.getId()), consumer);
        }
    }

    void removeConsumer(int consumerId) {
        if (this.hadMsgConsumer()) {
            HashMap hashMap = this.consumers;
            synchronized (hashMap) {
                this.consumers.remove(new Integer(consumerId));
            }
        }
    }

    protected ConsumerImpl getConsumer(int consumerId) {
        ConsumerImpl consumer = (ConsumerImpl)this.consumers.get(new Integer(consumerId));
        if (consumer == null && (consumer = this.parentConnection.getConnectionConsumer(consumerId)) == null && logger.isLogging(7)) {
            logger.finest("Unable to find ConnectionConsumer: " + consumerId);
        }
        return consumer;
    }

    protected void addProducer(int producerId) {
        ArrayList arrayList = this.producers;
        synchronized (arrayList) {
            this.producers.add(new Integer(producerId));
        }
    }

    protected void removeProducer(int producerId) {
        ArrayList arrayList = this.producers;
        synchronized (arrayList) {
            ((AbstractCollection)this.producers).remove(new Integer(producerId));
        }
    }

    public void acknowledgeMessages(Collection acks) throws JMSException, SQLException {
        if (!this.getTransacted()) {
            Iterator ackIter = acks.iterator();
            try {
                this.dbConnection.setAutoCommit(false);
                while (ackIter.hasNext()) {
                    this.acknowledgeMessage((Acknowledgement)ackIter.next());
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.dbConnection.commit();
                this.dbConnection.setAutoCommit(true);
                throw throwable;
            }
            this.dbConnection.commit();
            this.dbConnection.setAutoCommit(true);
            {
            }
        }
    }

    public MessageImpl acknowledgeMessage(Acknowledgement key) throws JMSException, SQLException {
        MessageImpl ackedMsg = null;
        HashMap hashMap = this.awaitingAckMessages;
        synchronized (hashMap) {
            ackedMsg = (MessageImpl)this.awaitingAckMessages.remove(key);
        }
        if (ackedMsg != null) {
            if (logger.isLogging(6)) {
                logger.finer("TxID=" + this.getTransactionID() + ", receivedAcknowledgement msg= \"" + ackedMsg + "\" ]");
            }
            service.removeMessage(ackedMsg);
            ConsumerImpl consumer = this.getConsumer(key.getConsumerID());
            if (this.globalTransaction) {
                key.setMessage(ackedMsg);
            }
            consumer.acknowledgeMessage(ackedMsg);
            if (service.isPersistentMessage(ackedMsg)) {
                this.removePersistentMessage(ackedMsg);
            }
        } else if (logger.isLogging(2)) {
            logger.warning(MessageFormat.format(resource.getString("sessionimpl.could_not_find_key"), key.toString()));
        }
        return ackedMsg;
    }

    private void removePersistentMessage(MessageImpl msg) {
        block5: {
            try {
                if (!this.acknowledgeByAllConsumers(msg)) break block5;
                Connection connection = this.dbConnection;
                synchronized (connection) {
                    msg.remove(this.dbConnection, this.deleteMsgStmt);
                }
            }
            catch (SQLException sqle) {
                logger.severe(MessageFormat.format(resource.getString("sessionimpl.delete_failed"), msg.toString()));
                logger.severe(sqle);
            }
        }
    }

    private boolean acknowledgeByAllConsumers(MessageImpl msg) {
        boolean ackedByAll;
        block7: {
            ackedByAll = false;
            try {
                Destination dest = msg.getJMSDestination();
                if (dest instanceof Queue) {
                    ackedByAll = true;
                    break block7;
                }
                Connection connection = this.dbConnection;
                synchronized (connection) {
                    if (TopicSubscriberImpl.messageHasBeenAckedByAllSubscribers(this.dbConnection, msg)) {
                        ackedByAll = true;
                    }
                }
            }
            catch (JMSException e10) {
                logger.warning(e10.getMessage());
            }
        }
        return ackedByAll;
    }

    void closeProducer(int producerId) {
    }

    void closeConsumer(int consumerId) throws JMSException {
        MessageConsumerImpl consumer = (MessageConsumerImpl)this.getConsumer(consumerId);
        consumer.close(true);
    }

    private void suspendProcessingOutgoingMessages() throws JMSException {
        if (!this.hadMsgConsumer()) {
            return;
        }
        MessageImpl stopMsg = SystemMessage.createStopRequestMessage();
        if (this.outgoingMessageWaiter.isRunning()) {
            MessageImpl messageImpl = stopMsg;
            synchronized (messageImpl) {
                if (stoplogger.isLogging(7)) {
                    stoplogger.finest("sessionID=" + this.getGlobalyUniqueId() + ": id " + this.id + " quesceing waiter");
                }
                this.addOutgoingMessage(stopMsg);
                if (stoplogger.isLogging(7)) {
                    stoplogger.finest("sessionID=" + this.getGlobalyUniqueId() + ": id " + this.id + " waiting for close notify on waiter");
                }
                SystemMessage.waitForWakeup(stopMsg);
            }
        }
        if (stoplogger.isLogging(7)) {
            stoplogger.finest("sessionID=" + this.getGlobalyUniqueId() + ": id " + this.id + " Done quescing waiter");
        }
    }

    void stop() throws JMSException {
        if (logger.isLogging(7)) {
            logger.finest("sessionID=" + this.getGlobalyUniqueId() + ": id " + this.id + " entered");
        }
        this.stopMessageDelivery = true;
        if (this.hadMsgConsumer()) {
            this.suspendProcessingOutgoingMessages();
        }
        if (logger.isLogging(7)) {
            logger.finest("sessionID=" + this.getGlobalyUniqueId() + ": id " + this.id + " stopped");
        }
    }

    void start() {
        this.stopMessageDelivery = false;
        if (this.hadMsgConsumer()) {
            if (logger.isLogging(7)) {
                logger.finest("TxID=" + this.getTransactionID() + ",  #outgoinMsgs=" + this.outgoingMessages.size());
            }
            this.outgoingMessageWaiter.resumeRunning();
        }
    }

    boolean isStopped() {
        return this.stopMessageDelivery;
    }

    private void redeliverOutgoingMessage(MessageImpl msg) {
        block3: {
            try {
                DestinationImpl dest = service.getDestination(msg);
                if (dest.isQueue()) {
                    dest.redeliverMessage(msg);
                }
            }
            catch (JMSException e10) {
                if (!logger.isLogging(2)) break block3;
                logger.warning(MessageFormat.format(resource.getString("sessionimpl.unable_to_redeliver_message"), msg.toString(), e10.getMessage()));
            }
        }
    }

    private void redeliverOutgoingMessages() {
        if (this.outgoingMessageWaiter != null) {
            Waiter waiter = this.outgoingMessageWaiter;
            synchronized (waiter) {
                if (this.outgoingMessages.size() > 0 && logger.isLogging(6)) {
                    logger.finer("TxID=" + this.getTransactionID() + ", sessionID = " + this.getGlobalyUniqueId() + ", outgoingMessages.size=" + this.outgoingMessages.size());
                    if (logger.isLogging(7)) {
                        logger.finest("outgoingMessages=" + this.outgoingMessages);
                    }
                }
                Iterator msgIter = ((AbstractList)this.outgoingMessages).iterator();
                while (msgIter.hasNext()) {
                    MessageImpl msg = (MessageImpl)msgIter.next();
                    this.redeliverOutgoingMessage(msg);
                    msgIter.remove();
                }
            }
        }
    }

    protected boolean getBeingClosed() {
        return this.beingClosed;
    }

    MessageImpl synchronousReceiveFromOutgoingMessages(MessageConsumerImpl synchronousMsgConsumer) {
        Waiter waiter = this.outgoingMessageWaiter;
        synchronized (waiter) {
            MessageImpl messageImpl = this.processOutgoingMessages(synchronousMsgConsumer);
            return messageImpl;
        }
    }

    MessageImpl receive(int messageConsumerId, long timeout) throws JMSException {
        MessageConsumerImpl consumer = (MessageConsumerImpl)this.getConsumer(messageConsumerId);
        if (consumer == null) {
            throw new JMSException(MessageFormat.format(resource.getString("sessionimpl.unknown_consumer_id"), new Integer(messageConsumerId)));
        }
        MessageImpl msg = null;
        msg = consumer.receive(timeout);
        if (msg != null) {
            this.addAwaitingAckMessage(msg);
            consumer.deliveredMessage(msg);
            this.parentConnection.updateStatistics(msg);
            msg.setDeliveryCount(msg.getDeliveryCount() + 1);
        }
        return msg;
    }

    Iterator getConsumers() {
        Iterator iter = null;
        if (this.hadMsgConsumer()) {
            HashMap hashMap = this.consumers;
            synchronized (hashMap) {
                ArrayList _consumers = new ArrayList(this.consumers.values());
                if (_consumers != null) {
                    iter = ((AbstractList)_consumers).iterator();
                }
            }
        }
        return iter;
    }
}

