/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.Consumer;
import com.sun.jms.service.DBManager;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public abstract class Subscription {
    Consumer parentConsumer = null;
    String subscriptionName = null;
    public static final String DB_CLIENT_ID_FIELD = "client_id";
    public static final String DB_SUBSCRIPTION_NAME_FIELD = "subscription_name";
    public static final String DB_DELIVERY_COUNT_FIELD = "delivery_count";
    public static final String DB_UNACKED_MSG_TABLE_NAME = "unacked_message";
    public static final String DB_CONSUMER_TXID_FIELD = "consumer_txid";
    public static final String CREATE_UNACKED_MSG_TABLE_STMT = "CREATE TABLE unacked_message ( msg_id VARCHAR(256) NOT NULL, client_id VARCHAR(256), subscription_name VARCHAR(256) NOT NULL, delivery_count INTEGER NOT NULL, consumer_txid VARCHAR(256), PRIMARY KEY ( msg_id, client_id, subscription_name )   )";
    public static final String DB_TXN_ID_INDEX = "txn_id_index";
    public static final String DB_MSG_ID_INDEX = "msg_id_index";
    public static final String CREATE_TXN_ID_INDEX_STMT = "CREATE INDEX txn_id_index ON unacked_message ( consumer_txid )";
    public static final String CREATE_MSG_ID_INDEX_STMT = "CREATE INDEX msg_id_index ON unacked_message ( msg_id, client_id, subscription_name )";
    public static final String DEBUG_STMT = "SELECT * FROM unacked_message";
    static Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    public Subscription(Consumer c10) {
        this.parentConsumer = c10;
    }

    public abstract String getSubscriptionName();

    protected abstract Collection loadUnackedMessages() throws IllegalStateException;

    protected abstract String getStatementToDeleteUnackedMessage(String var1);

    protected void deleteUnackedMessage(Connection conn, String msgId) throws SQLException {
        String stmtStr = this.getStatementToDeleteUnackedMessage(msgId);
        logger.finest(stmtStr);
        DBManager.executeUpdate(conn, stmtStr);
    }

    /*
     * Loose catch block
     */
    static void createTable(Connection conn) throws SQLException {
        block11: {
            Statement stmt;
            block10: {
                stmt = conn.createStatement();
                stmt.execute(CREATE_UNACKED_MSG_TABLE_STMT);
                if (logger.isLogging(7)) {
                    logger.finest("Created table: unacked_message");
                }
                stmt.execute(CREATE_TXN_ID_INDEX_STMT);
                if (logger.isLogging(7)) {
                    logger.finest("Created index: txn_id_index");
                }
                stmt.execute(CREATE_MSG_ID_INDEX_STMT);
                if (!logger.isLogging(7)) break block10;
                logger.finest("Created index: msg_id_index");
            }
            Object var4_2 = null;
            try {
                stmt.close();
            }
            catch (SQLException e10) {}
            break block11;
            {
                catch (SQLException e11) {
                    logger.warning(e11);
                    Object var4_3 = null;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e10) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    stmt.close();
                }
                catch (SQLException e10) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public abstract String getStatementToStoreUnackedMessage(MessageImpl var1) throws JMSException;

    public void storeUnackedMessage(Connection conn, MessageImpl msg) throws SQLException, JMSException {
        if (logger.isLogging(7)) {
            logger.finest("DATABASE EVENT: storing unacked_message: " + msg.getJMSMessageID() + "," + this.getSubscriptionName() + " in db");
        }
        String stmtStr = this.getStatementToStoreUnackedMessage(msg);
        DBManager.executeUpdate(conn, stmtStr);
    }

    protected abstract void updateUnackedMessageDeliveryCount(MessageImpl var1);

    public void updateConsumerTXID(Connection con, MessageImpl msg) {
        block9: {
            try {
                int rowCount;
                String txid;
                String msgId = msg.getJMSMessageID();
                String subscriptionName = this.getSubscriptionName();
                if (logger.isLogging(7)) {
                    logger.finest("DATABASE EVENT: attempting update unacked messages for consumer " + msgId + "." + subscriptionName + " in the db");
                }
                try {
                    txid = msg.getStringProperty("JMSXConsumerTXID");
                }
                catch (JMSException je) {
                    txid = "error getting JMSXConsumerTXID";
                    logger.warning(resource.getString("subscription.internal_failure_looking_up_jmsxconsumertxid"));
                }
                String stmtStr = "UPDATE unacked_message SET consumer_txid = '" + txid + "'" + " WHERE " + "msg_id" + " = '" + msgId + "' AND " + DB_CLIENT_ID_FIELD + " = '' AND " + DB_SUBSCRIPTION_NAME_FIELD + " = '" + subscriptionName + "'";
                if (logger.isLogging(7)) {
                    logger.finest(stmtStr);
                }
                if ((rowCount = DBManager.executeUpdate(con, stmtStr)) != 1 && logger.isLogging(2)) {
                    logger.warning(MessageFormat.format(resource.getString("subscription.update_failed"), new Integer(rowCount)));
                }
            }
            catch (SQLException e10) {
                if (logger.isLogging(2)) {
                    logger.warning(MessageFormat.format(resource.getString("subscription.update_failed_because"), e10.getMessage()));
                    logger.warning(e10);
                }
            }
            catch (JMSException e11) {
                if (!logger.isLogging(2)) break block9;
                logger.warning(MessageFormat.format(resource.getString("subscription.update_failed_because"), e11.getMessage()));
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void printDatabaseDebugInfo() {
        block25: {
            SQLException sqle2222;
            ResultSet rs;
            Statement stmt;
            Connection conn;
            block21: {
                conn = null;
                stmt = null;
                rs = null;
                conn = DBManager.getInstance().getDBConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(DEBUG_STMT);
                while (rs.next()) {
                    logger.debugInfo("\tmsg_id: " + rs.getString("msg_id") + "\tclient id: " + rs.getString(DB_CLIENT_ID_FIELD) + "\tsub. name: " + rs.getString(DB_SUBSCRIPTION_NAME_FIELD) + "\tdelivery count: " + rs.getInt(DB_DELIVERY_COUNT_FIELD) + "\tconsumer txid: " + rs.getString(DB_CONSUMER_TXID_FIELD));
                }
                Object var5_3 = null;
                if (rs == null) break block21;
                try {
                    rs.close();
                }
                catch (SQLException sqle2222) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqle2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                DBManager.getInstance().closeDBConnection(conn);
            }
            break block25;
            {
                catch (SQLException sqle) {
                    SQLException sqle2222;
                    logger.debugInfo("Error dumping message table: " + sqle.toString());
                    Object var5_4 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle2222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqle2222) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        DBManager.getInstance().closeDBConnection(conn);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sqle2222;
                Object var5_5 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle2222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqle2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    DBManager.getInstance().closeDBConnection(conn);
                }
                throw throwable;
            }
        }
    }
}

