/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.QueueSessionImpl;
import com.sun.jms.service.TopicConnectionConsumerImpl;
import com.sun.jms.service.TopicImpl;
import com.sun.jms.service.TopicSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.text.MessageFormat;
import javax.jms.JMSException;

public class TopicConnectionImpl
extends ConnectionImpl {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    TopicConnectionImpl(String pclientId, int connectionId) {
        super(pclientId, connectionId);
    }

    public QueueSessionImpl createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        throw new JMSException(resource.getString("topicconnectionimpl.cannot_create_queue_session"));
    }

    public TopicSessionImpl createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        TopicSessionImpl session = new TopicSessionImpl(this, transacted, acknowledgeMode);
        return session;
    }

    int getConnectionType() {
        return 1;
    }

    void createConnectionConsumer(int connectionConsumerID, String destinationName, String messageSelector, int maxMessages, String subscriptionName) throws JMSException {
        DestinationImpl dest = ConnectionImpl.service.getDestination(destinationName);
        if (dest == null || !(dest instanceof TopicImpl)) {
            throw new JMSException(MessageFormat.format(resource.getString("topicconnectionimpl.invalid_destination"), destinationName));
        }
        TopicConnectionConsumerImpl connectionConsumer = null;
        if (subscriptionName == null) {
            connectionConsumer = new TopicConnectionConsumerImpl(connectionConsumerID, dest, messageSelector, maxMessages, subscriptionName, this);
            dest.register(connectionConsumer);
        } else {
            connectionConsumer = new TopicConnectionConsumerImpl(connectionConsumerID, dest, messageSelector, maxMessages, subscriptionName, this);
            connectionConsumer.initializeDurableSubscription();
            boolean returningDurableSubscriber = ((TopicImpl)dest).registerDurableSubscriber(connectionConsumer, this.getClientID(), subscriptionName);
            if (returningDurableSubscriber) {
                ConnectionImpl.logger.finer("<<<<<<<<< replaced DCC, recovering missed messages >>>>>>>>>");
                connectionConsumer.sendLoggedMessages();
            }
        }
    }
}

