/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service.selector;

import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.text.MessageFormat;

public class NumericValue {
    public static final Logger logger = Log.getLogger(5);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.selector.LocalStrings");
    Number value = null;
    String image = null;
    int imageType = 0;
    private static final int ByteValue = 0;
    private static final int ShortValue = 1;
    private static final int IntValue = 2;
    private static final int FloatValue = 3;
    static final int LongValue = 4;
    static final int DoubleValue = 5;
    private static final int[][] returnTypes = new int[][]{{0, 1, 2, 3, 4, 5}, {1, 1, 2, 3, 4, 5}, {2, 2, 2, 3, 4, 5}, {3, 3, 3, 3, 3, 5}, {4, 4, 4, 3, 4, 5}, {5, 5, 5, 5, 5, 5}};
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public NumericValue(Object obj) throws ClassCastException {
        if (this.value != null && !(obj instanceof Number)) {
            throw new ClassCastException(MessageFormat.format(resource.getString("numericvalue.classcastexception"), obj.getClass().getName()));
        }
        if (obj instanceof NumericValue) {
            NumericValue n2 = (NumericValue)obj;
            this.value = n2.value;
            this.image = n2.image;
            this.imageType = n2.imageType;
        } else {
            this.value = (Number)obj;
        }
    }

    public NumericValue(String image, int imageType) {
        this.image = image;
        this.imageType = imageType;
        this.value = null;
    }

    public Number getValue() {
        if (this.value == null && this.image != null) {
            switch (this.imageType) {
                case 5: {
                    this.value = new Double(this.image);
                    break;
                }
                case 4: {
                    this.value = Long.decode(this.image);
                    break;
                }
            }
            this.image = null;
            this.imageType = -1;
        }
        return this.value;
    }

    private int getIndexForType(Number obj) {
        int index = -1;
        Class<?> objClass = obj.getClass();
        if (objClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = NumericValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            index = 0;
        } else if (objClass == (class$java$lang$Short == null ? (class$java$lang$Short = NumericValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            index = 1;
        } else if (objClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = NumericValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            index = 2;
        } else if (objClass == (class$java$lang$Float == null ? (class$java$lang$Float = NumericValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            index = 3;
        } else if (objClass == (class$java$lang$Long == null ? (class$java$lang$Long = NumericValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            index = 4;
        } else if (objClass == (class$java$lang$Double == null ? (class$java$lang$Double = NumericValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            index = 5;
        } else if (logger.isLogging(5)) {
            logger.fine("Unexpected failure in getIndexForType objClass=" + obj.getClass().getName());
        }
        return index;
    }

    int getUnifiedTypeIndex(Number val1, Number val2) {
        int index = -1;
        if (val1 != null && val2 != null) {
            int index1 = this.getIndexForType(val1);
            int index2 = this.getIndexForType(val2);
            index = returnTypes[index1][index2];
        }
        return index;
    }

    private Number convertNumber(Number val, int typeIndex) {
        switch (typeIndex) {
            case 0: {
                return new Byte(val.byteValue());
            }
            case 1: {
                return new Short(val.shortValue());
            }
            case 2: {
                return new Integer(val.intValue());
            }
            case 4: {
                return new Long(val.longValue());
            }
            case 5: {
                return new Double(val.doubleValue());
            }
        }
        return null;
    }

    public Number add(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = new Byte((byte)(val1.byteValue() + val2.byteValue()));
                    break;
                }
                case 1: {
                    result = new Short((short)(val1.shortValue() + val2.shortValue()));
                    break;
                }
                case 2: {
                    result = new Integer(val1.intValue() + val2.intValue());
                    break;
                }
                case 3: {
                    result = new Float(val1.floatValue() + val2.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(val1.longValue() + val2.longValue());
                    break;
                }
                case 5: {
                    result = new Double(val1.doubleValue() + val2.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public Number subtract(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = new Byte((byte)(val1.byteValue() - val2.byteValue()));
                    break;
                }
                case 1: {
                    result = new Short((short)(val1.shortValue() - val2.shortValue()));
                    break;
                }
                case 2: {
                    result = new Integer(val1.intValue() - val2.intValue());
                    break;
                }
                case 3: {
                    result = new Float(val1.floatValue() - val2.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(val1.longValue() - val2.longValue());
                    break;
                }
                case 5: {
                    result = new Double(val1.doubleValue() - val2.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public Number multiply(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = new Byte((byte)(val1.byteValue() * val2.byteValue()));
                    break;
                }
                case 1: {
                    result = new Short((short)(val1.shortValue() * val2.shortValue()));
                    break;
                }
                case 2: {
                    result = new Integer(val1.intValue() * val2.intValue());
                    break;
                }
                case 3: {
                    result = new Float(val1.floatValue() * val2.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(val1.longValue() * val2.longValue());
                    break;
                }
                case 5: {
                    result = new Double(val1.doubleValue() * val2.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public Number divide(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = new Byte((byte)(val1.byteValue() / val2.byteValue()));
                    break;
                }
                case 1: {
                    result = new Short((short)(val1.shortValue() / val2.shortValue()));
                    break;
                }
                case 2: {
                    result = new Integer(val1.intValue() / val2.intValue());
                    break;
                }
                case 3: {
                    result = new Float(val1.floatValue() / val2.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(val1.longValue() / val2.longValue());
                    break;
                }
                case 5: {
                    result = new Double(val1.doubleValue() / val2.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public Number negate() {
        Number result = null;
        if (this.image != null) {
            this.image = "-" + this.image;
            return this.getValue();
        }
        if (this.getValue() != null) {
            int typeIndex = this.getIndexForType(this.value);
            switch (typeIndex) {
                case 0: {
                    result = new Byte(-this.value.byteValue());
                    break;
                }
                case 1: {
                    result = new Short(-this.value.shortValue());
                    break;
                }
                case 2: {
                    result = new Integer(-this.value.intValue());
                    break;
                }
                case 3: {
                    result = new Float(-this.value.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(-this.value.longValue());
                    break;
                }
                case 5: {
                    result = new Double(-this.value.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public String toString() {
        String str = "null";
        if (this.getValue() != null) {
            str = this.value.toString();
        }
        return str;
    }

    public static void main(String[] args) {
        NumericValue num1 = new NumericValue(new Float(3.65));
        NumericValue num2 = new NumericValue(new Long(100L));
        System.err.println(num1 + "+" + num2 + " = " + num1.add(num2));
        System.err.println(num2 + "+" + num1 + " = " + num2.add(num1));
        System.err.println(num1 + "-" + num2 + " = " + num1.subtract(num2));
        System.err.println(num2 + "-" + num1 + " = " + num2.subtract(num1));
        System.err.println(num1 + "*" + num2 + " = " + num1.multiply(num2));
        System.err.println(num2 + "*" + num1 + " = " + num2.multiply(num1));
        System.err.println(num1 + "/" + num2 + " = " + num1.divide(num2));
        System.err.println(num2 + "/" + num1 + " = " + num2.divide(num1));
        System.err.println("-" + num1 + " = " + num1.negate());
        System.err.println("-" + num2 + " = " + num2.negate());
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

