/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.util;

import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.Logger;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;

public class Log {
    private static Log log = null;
    static final int FIRST_LEVEL = 0;
    static final int LAST_LEVEL = 7;
    public static final int LOGGING_OFF = -1;
    public static final int DEBUG_INFO = 0;
    public static final int SEVERE = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int CONFIG = 4;
    public static final int FINE = 5;
    public static final int FINER = 6;
    public static final int FINEST = 7;
    static final String[] LEVEL_LABEL = new String[]{"", "SEVERE ", "WARN   ", "INFO   ", "CONFIG ", "T1     ", "T2     ", "T3     "};
    static final String[] LEVEL_NAME = new String[]{"DEBUG_INFO", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static final String LEVEL_PROP = "loglevel";
    public static final int DEFAULT_LOGGER_ID = -1;
    static final String DEFAULT_LOGGER_NAME = "com.sun.jms.default";
    static final int DEFAULT_LEVEL = 2;
    private PrintWriter[] logWriter = new PrintWriter[8];
    public static final int COMMON_LOGGER = 0;
    public static final int SERVICE_LOGGER = 1;
    public static final int CLIENT_LOGGER = 2;
    public static final int UTIL_LOGGER = 3;
    public static final int ADMIN_LOGGER = 4;
    public static final int SELECTOR_LOGGER = 5;
    public static final int RMI_LOGGER = 6;
    public static final int STOP_LOGGER = 7;
    private static final Logger[] logger = new Logger[]{new Logger(0, "com.sun.jms"), new Logger(1, "com.sun.jms.service"), new Logger(2, "com.sun.jms.client"), new Logger(3, "com.sun.jms.util"), new Logger(4, "com.sun.jms.admin"), new Logger(5, "com.sun.jms.service.selector"), new Logger(6, "com.sun.jms.rmi"), new Logger(7, "com.sun.jms.stop")};

    public static Logger getLogger(int loggerId) {
        return logger[loggerId];
    }

    private Log() {
    }

    private int boundLogLevel(int level) {
        if (level < 0) {
            return -1;
        }
        if (level > 7) {
            return 7;
        }
        return level;
    }

    private void setWriter(int level, PrintWriter out) {
        if (!out.equals(this.logWriter[level])) {
            this.logWriter[level] = out;
            try {
                String host = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable t2) {
                String string = "**Unknown host**";
            }
        }
    }

    public static void log(int proposedLevel, String msg) {
        if (log == null) {
            System.out.println(msg);
            return;
        }
        int level = log.boundLogLevel(proposedLevel);
        Log log = Log.log;
        synchronized (log) {
            Log.log.logWriter[level].println(msg);
        }
    }

    public static void initialize(String errorFileName, String traceFileName, int level, boolean append) {
        PrintWriter traceOut;
        PrintWriter errOut;
        if (log != null) {
            return;
        }
        try {
            errOut = errorFileName != null ? new PrintWriter(new FileOutputStream(errorFileName, append), true) : new PrintWriter(System.err, true);
        }
        catch (Exception e10) {
            System.err.println("Failed error log file: " + errorFileName + " using stderr. Exception " + e10.getMessage());
            errOut = new PrintWriter(System.err, true);
        }
        try {
            traceOut = traceFileName != null ? (traceFileName.equals(errorFileName) ? errOut : new PrintWriter(new FileOutputStream(traceFileName, append))) : new PrintWriter(System.out, true);
        }
        catch (Exception e11) {
            System.err.println("Failed trace log file: " + traceFileName + " using stdout. Exception " + e11.getMessage());
            traceOut = new PrintWriter(System.out, true);
        }
        Log.initialize(errOut, traceOut, level);
    }

    public static void initialize(PrintWriter errorOut, PrintWriter traceOut, int oldLevel) {
        if (log != null) {
            return;
        }
        log = new Log();
        log.setWriter(0, traceOut);
        log.setWriter(1, errorOut);
        log.setWriter(2, errorOut);
        log.setWriter(4, traceOut);
        log.setWriter(3, traceOut);
        log.setWriter(5, traceOut);
        log.setWriter(6, traceOut);
        log.setWriter(7, traceOut);
        JMSProperties props = JMSProperties.getInstance();
        String defaultLevel = props.getProperty("com.sun.jms.default.loglevel", LEVEL_NAME[2]);
        int i2 = 0;
        while (i2 < logger.length) {
            String levelName = props.getProperty(Log.getLoggerName(i2) + "." + LEVEL_PROP, defaultLevel);
            Logger l2 = logger[i2];
            l2.initialize(Log.getLoggerName(i2), i2, Log.convertStringToLevel(levelName));
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int convertStringToLevel(String levelName) {
        level = 2;
        try {
            value = Integer.parseInt(levelName);
            if (value <= 1) {
                return 2;
            }
            if (value <= 3) {
                return 5;
            }
            if (value <= 5) {
                return 6;
            }
            return 7;
        }
        catch (Exception e) {
            j = 0;
            ** while (j <= 7)
        }
lbl-1000:
        // 1 sources

        {
            if (levelName.equalsIgnoreCase(Log.LEVEL_NAME[j])) {
                return j;
            }
            ++j;
            continue;
        }
lbl18:
        // 1 sources

        System.err.println("Unknown level name for logger, using default: " + levelName);
        return 2;
    }

    public static String getLoggerName(int id) {
        return logger[id].getName();
    }

    public static void initialize(String logFileName, int level) {
        Log.initialize(logFileName, logFileName, level, false);
    }
}

