/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.TopCoordinator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationHelper;
import org.omg.CosTransactions.SynchronizationPOA;
import org.omg.PortableServer.POA;

class CoordinatorSynchronizationImpl
extends SynchronizationPOA {
    private static POA poa = null;
    private Synchronization thisRef = null;
    private Long localTID = null;
    private TopCoordinator coordinator = null;

    CoordinatorSynchronizationImpl() {
    }

    CoordinatorSynchronizationImpl(TopCoordinator coord) {
        this.coordinator = coord;
        try {
            this.localTID = new Long(coord.getLocalTID());
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public void finalize() {
        this.coordinator = null;
    }

    public void before_completion() throws SystemException {
        if (this.coordinator == null) {
            INTERNAL exc = new INTERNAL(257, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        this.coordinator.beforeCompletion();
    }

    public void after_completion(Status status) throws SystemException {
        if (this.coordinator == null) {
            INTERNAL exc = new INTERNAL(257, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        this.coordinator.afterCompletion(status);
        this.destroy();
    }

    Synchronization object() {
        if (poa == null) {
            poa = Configuration.getPOA("transient");
        }
        if (this.thisRef == null) {
            if (poa == null) {
                poa = Configuration.getPOA("transient");
            }
            try {
                poa.activate_object(this);
                this.thisRef = SynchronizationHelper.narrow(poa.servant_to_reference(this));
            }
            catch (Exception exc) {
                ErrorLog.error(7, new Object[]{"CoordinatorSynchronization"}, true);
            }
        }
        return this.thisRef;
    }

    void destroy() {
        if (poa != null && this.thisRef != null) {
            try {
                poa.deactivate_object(poa.reference_to_id(this.thisRef));
                this.thisRef = null;
            }
            catch (Exception exc) {
                ErrorLog.error(8, new Object[]{"CoordinatorResource"}, false);
            }
        }
        this.finalize();
    }

    static final synchronized CoordinatorSynchronizationImpl servant(Synchronization sync) {
        CoordinatorSynchronizationImpl result = null;
        if (sync != null && Configuration.getProxyChecker().isProxy(sync)) {
            return result;
        }
        if (sync instanceof CoordinatorSynchronizationImpl) {
            result = (CoordinatorSynchronizationImpl)((Object)sync);
        } else if (poa != null) {
            try {
                result = (CoordinatorSynchronizationImpl)poa.reference_to_servant(sync);
                if (result.thisRef == null) {
                    result.thisRef = sync;
                }
            }
            catch (Exception exc) {
                ErrorLog.error(28, new Object[]{"CoordinatorSynchronization"}, false);
            }
        }
        return result;
    }
}

