/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.LogCursor;
import com.sun.jts.CosTransactions.LogException;
import com.sun.jts.CosTransactions.LogHandle;
import com.sun.jts.CosTransactions.LogLSN;
import java.util.Vector;

class LogFile {
    static final int UNFORCED = 0;
    static final int FORCED = 1;
    static final int NORMAL = 0;
    static final int KEYPOINT_START = 1;
    static final int KEYPOINT_END = 2;
    static final int REWRITE = 3;
    LogHandle handle = null;

    LogFile(LogHandle handle) {
        this.handle = handle;
    }

    synchronized boolean write(int writeType, byte[] record, int recordType, LogLSN recordLSN) {
        boolean result = true;
        try {
            LogLSN resultLSN = this.handle.writeRecord(record, recordType, writeType == 1 ? 1 : 0);
            if (recordLSN != null) {
                recordLSN.copy(resultLSN);
            }
        }
        catch (LogException le) {
            ErrorLog.error(23, new Object[]{le.toString()}, true);
            if (recordLSN != null) {
                recordLSN.copy(LogLSN.NULL_LSN);
            }
            result = false;
        }
        return result;
    }

    synchronized boolean checkpoint(LogLSN firstLSN) {
        boolean result = true;
        LogLSN checkLSN = firstLSN.isNULL() ? new LogLSN(LogLSN.HEAD_LSN) : new LogLSN(firstLSN);
        try {
            this.handle.checkLSN(checkLSN);
            this.handle.truncate(checkLSN, 0);
        }
        catch (LogException le) {
            result = false;
        }
        return result;
    }

    synchronized boolean writeRestart(byte[] record) {
        boolean result = false;
        try {
            this.handle.writeRestart(record);
            result = true;
        }
        catch (LogException le) {
            result = false;
        }
        return result;
    }

    synchronized byte[] readRestart() {
        byte[] result = null;
        try {
            result = this.handle.readRestart();
        }
        catch (LogException logException) {
            // empty catch block
        }
        return result;
    }

    synchronized boolean close(boolean deleteFile) {
        boolean result = true;
        try {
            this.handle.closeFile(deleteFile);
        }
        catch (LogException le) {
            result = false;
        }
        return result;
    }

    synchronized Vector getLogRecords() {
        LogCursor logCursor;
        Vector<byte[]> logRecords = new Vector<byte[]>();
        boolean keypointEndFound = false;
        try {
            logCursor = this.handle.openCursor(LogLSN.HEAD_LSN, LogLSN.TAIL_LSN);
        }
        catch (LogException le) {
            return new Vector();
        }
        try {
            LogLSN lsn = new LogLSN();
            int[] recordType = new int[1];
            block11: while (true) {
                byte[] logRecord = logCursor.readCursor(recordType, lsn);
                switch (recordType[0]) {
                    case 1: {
                        if (!keypointEndFound) break;
                        throw new LogException(null, 21, 2);
                    }
                    case 2: {
                        keypointEndFound = true;
                        break;
                    }
                    case 0: 
                    case 3: {
                        if (recordType[0] != 0 && !keypointEndFound) continue block11;
                        logRecords.addElement(logRecord);
                        break;
                    }
                }
            }
        }
        catch (LogException le) {
            if (le.errorCode != 21) {
                return new Vector();
            }
            try {
                this.handle.closeCursor(logCursor);
            }
            catch (LogException le2) {
                // empty catch block
            }
            return logRecords;
        }
    }

    void dump() {
    }
}

