/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.TimeoutInfo;
import com.sun.jts.CosTransactions.TimeoutThread;
import com.sun.jts.CosTransactions.TopCoordinator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CosTransactions.Status;

class TimeoutManager {
    static final int CANCEL_TIMEOUT = 0;
    static final int NO_TIMEOUT = 0;
    static final int ACTIVE_TIMEOUT = 1;
    static final int IN_DOUBT_TIMEOUT = 2;
    private static boolean initialised = false;
    private static Hashtable pendingTimeouts = new Hashtable();
    private static TimeoutThread timeoutThread = null;
    private static boolean timeoutActive = false;
    private static boolean quiescing = false;

    TimeoutManager() {
    }

    static synchronized void initialise() {
        if (initialised) {
            return;
        }
        initialised = true;
        if (!timeoutActive && timeoutThread == null) {
            timeoutThread = new TimeoutThread();
            timeoutThread.start();
            timeoutActive = true;
        }
    }

    static synchronized boolean setTimeout(Long localTID, int timeoutType, int seconds) {
        boolean result;
        block7: {
            block6: {
                result = true;
                if (!timeoutActive) break block6;
                TimeoutInfo timeoutInfo = (TimeoutInfo)pendingTimeouts.get(localTID);
                switch (timeoutType) {
                    case 1: 
                    case 2: {
                        if (timeoutInfo == null) {
                            timeoutInfo = new TimeoutInfo();
                            pendingTimeouts.put(localTID, timeoutInfo);
                        }
                        timeoutInfo.expireTime = new Date().getTime() + (long)(seconds * 1000);
                        timeoutInfo.localTID = localTID;
                        timeoutInfo.timeoutType = timeoutType;
                        break;
                    }
                    default: {
                        if (timeoutInfo != null) {
                            boolean bl2 = result = pendingTimeouts.remove(localTID) != null;
                            if (quiescing && pendingTimeouts.isEmpty()) {
                                timeoutThread.stop();
                                timeoutActive = false;
                                pendingTimeouts = null;
                                break;
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block7;
            }
            result = false;
        }
        return result;
    }

    static void timeoutCoordinator(Long localTID, int timeoutType) {
        CoordinatorImpl coord = RecoveryManager.getLocalCoordinator(localTID);
        if (coord == null) {
            TimeoutManager.setTimeout(localTID, 0, 0);
        } else {
            CoordinatorImpl coordinatorImpl = coord;
            synchronized (coordinatorImpl) {
                boolean[] isRoot = new boolean[1];
                switch (timeoutType) {
                    case 1: {
                        try {
                            coord.rollback(true);
                        }
                        catch (Throwable exc) {}
                        break;
                    }
                    case 2: {
                        Status state = ((TopCoordinator)coord).recover(isRoot);
                        if (state == Status.StatusUnknown) {
                            ErrorLog.warning(54, new Object[]{localTID});
                            break;
                        }
                        if (state == Status.StatusCommitted) {
                            try {
                                ((TopCoordinator)coord).commit();
                                if (!isRoot[0]) break;
                                ((TopCoordinator)coord).afterCompletion(state);
                            }
                            catch (Throwable exc) {}
                            break;
                        }
                        try {
                            ((TopCoordinator)coord).rollback(true);
                            if (!isRoot[0]) break;
                            ((TopCoordinator)coord).afterCompletion(Status.StatusRolledBack);
                        }
                        catch (Throwable exc) {}
                        break;
                    }
                }
            }
        }
    }

    static synchronized Enumeration checkTimeouts() {
        Enumeration result = null;
        if (timeoutActive && pendingTimeouts != null) {
            Vector<TimeoutInfo> timedOut = null;
            Enumeration timeouts = pendingTimeouts.elements();
            while (timeouts.hasMoreElements()) {
                TimeoutInfo timeoutInfo = (TimeoutInfo)timeouts.nextElement();
                if (new Date().getTime() <= timeoutInfo.expireTime) continue;
                if (timedOut == null) {
                    timedOut = new Vector<TimeoutInfo>();
                }
                timedOut.addElement(timeoutInfo);
            }
            if (timedOut != null) {
                result = timedOut.elements();
            }
        }
        return result;
    }

    static synchronized long timeLeft(Long localTID) {
        TimeoutInfo timeoutInfo = (TimeoutInfo)pendingTimeouts.get(localTID);
        long result = -1L;
        if (timeoutInfo != null && (result = timeoutInfo.expireTime - new Date().getTime()) < 0L) {
            result = 0L;
        }
        return result;
    }

    static void shutdown(boolean immediate) {
        if (immediate || pendingTimeouts == null || pendingTimeouts.isEmpty()) {
            if (timeoutThread != null) {
                timeoutThread.stop();
            }
            if (pendingTimeouts != null) {
                pendingTimeouts.clear();
            }
            pendingTimeouts = null;
            timeoutThread = null;
            timeoutActive = false;
        } else {
            quiescing = true;
        }
    }
}

