/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jta.TransactionState;
import com.sun.jts.otsidl.JControlHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Unavailable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TransactionManagerImpl
implements TransactionManager {
    private static TransactionManagerImpl tm = null;
    private Current current;
    private Hashtable transactionStates;
    private static Hashtable statusMap;
    private static Status[] CosTransactionStatus;
    private static int[] JTAStatus;

    public static synchronized TransactionManagerImpl getTransactionManagerImpl() {
        if (tm == null) {
            tm = new TransactionManagerImpl();
        }
        return tm;
    }

    private TransactionManagerImpl() {
        try {
            ORB orb = Configuration.getORB();
            this.current = CurrentHelper.narrow(orb.resolve_initial_references("TransactionCurrent"));
            this.transactionStates = new Hashtable();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public static void initJTSProperties(Properties props, String logDir, boolean trace, String traceDir) {
        if (traceDir == null) {
            traceDir = ".";
        }
        if (logDir == null) {
            logDir = ".";
        }
        ((Hashtable)props).put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        ((Hashtable)props).put("com.sun.jts.traceDirectory", traceDir);
        ((Hashtable)props).put("com.sun.jts.logDirectory", logDir);
        if (trace) {
            ((Hashtable)props).put("com.sun.jts.trace", "true");
        }
    }

    public static int mapStatus(Status status) {
        Integer result = (Integer)statusMap.get(status);
        if (result == null) {
            TransactionManagerImpl.assert(false);
            return 5;
        }
        return result;
    }

    public void begin() throws NotSupportedException, SystemException {
        try {
            if (this.current.get_control() != null) {
                throw new NotSupportedException();
            }
            this.current.begin();
        }
        catch (TRANSACTION_ROLLEDBACK ex2) {
            throw new NotSupportedException();
        }
        catch (SubtransactionsUnavailable ex3) {
            throw new SystemException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.current.commit(true);
        }
        catch (TRANSACTION_ROLLEDBACK ex2) {
            throw new RollbackException();
        }
        catch (NoTransaction ex3) {
            throw new IllegalStateException();
        }
        catch (NO_PERMISSION ex4) {
            throw new SecurityException();
        }
        catch (HeuristicMixed ex5) {
            throw new HeuristicMixedException();
        }
        catch (HeuristicHazard ex6) {
            throw new HeuristicRollbackException();
        }
        catch (Exception ex7) {
            throw new SystemException(ex7.toString());
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.current.rollback();
        }
        catch (NoTransaction ex2) {
            throw new IllegalStateException();
        }
        catch (NO_PERMISSION ex3) {
            throw new SecurityException();
        }
        catch (Exception ex4) {
            throw new SystemException(ex4.toString());
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        try {
            this.current.rollback_only();
        }
        catch (NoTransaction ex2) {
            throw new IllegalStateException();
        }
        catch (Exception ex3) {
            throw new SystemException(ex3.toString());
        }
    }

    public int getStatus() throws SystemException {
        try {
            Status status = this.current.get_status();
            return TransactionManagerImpl.mapStatus(status);
        }
        catch (Exception ex2) {
            throw new SystemException(ex2.toString());
        }
    }

    public synchronized void setTransactionTimeout(int seconds) throws SystemException {
        try {
            if (seconds < 0) {
                throw new SystemException(ErrorLog.getMessage(66));
            }
            this.current.set_timeout(seconds);
        }
        catch (Exception ex2) {
            throw new SystemException(ex2.toString());
        }
    }

    public Transaction getTransaction() throws SystemException {
        try {
            Control control = this.current.get_control();
            if (control == null) {
                return null;
            }
            return this.createTransactionImpl(control);
        }
        catch (Exception ex2) {
            throw new SystemException(ex2.toString());
        }
    }

    public void resume(Transaction suspended) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this.getTransaction() != null) {
            throw new IllegalStateException();
        }
        if (suspended == null) {
            throw new InvalidTransactionException();
        }
        if (!(suspended instanceof TransactionImpl)) {
            throw new InvalidTransactionException();
        }
        Control control = ((TransactionImpl)suspended).getControl();
        try {
            this.current.resume(control);
        }
        catch (InvalidControl ex2) {
            throw new InvalidTransactionException();
        }
        catch (Exception ex3) {
            throw new SystemException(ex3.toString());
        }
    }

    public Transaction suspend() throws SystemException {
        try {
            Control control = this.current.suspend();
            if (control == null) {
                return null;
            }
            return this.createTransactionImpl(control);
        }
        catch (Exception ex2) {
            throw new SystemException(ex2.toString());
        }
    }

    TransactionState getOrCreateTransactionState(GlobalTID gtid, Transaction tran) throws SystemException {
        Hashtable hashtable = this.transactionStates;
        synchronized (hashtable) {
            TransactionState result = (TransactionState)this.transactionStates.get(gtid);
            if (result == null) {
                result = new TransactionState(gtid);
                this.transactionStates.put(gtid, result);
                try {
                    SynchronizationListener sync = new SynchronizationListener(gtid, result);
                    tran.registerSynchronization(sync);
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                    throw new SystemException();
                }
            }
            TransactionState transactionState = result;
            return transactionState;
        }
    }

    TransactionState getTransactionState(GlobalTID gtid, Transaction tran) throws SystemException {
        Hashtable hashtable = this.transactionStates;
        synchronized (hashtable) {
            TransactionState transactionState = (TransactionState)this.transactionStates.get(gtid);
            return transactionState;
        }
    }

    private Transaction createTransactionImpl(Control control) throws Unavailable, SystemException {
        GlobalTID gtid = null;
        if (Configuration.isLocalFactory()) {
            gtid = ((ControlImpl)control).getGlobalTID();
        } else {
            ControlImpl cntrlImpl = ControlImpl.servant(JControlHelper.narrow(control));
            gtid = cntrlImpl.getGlobalTID();
        }
        return new TransactionImpl(this, control, gtid);
    }

    public static void recover(Enumeration xaResourceList) {
        RecoveryManager.recoverXAResources(xaResourceList);
    }

    private static void assert(boolean value) {
        if (!value) {
            Exception e10 = new Exception();
            e10.printStackTrace();
        }
    }

    void cleanupTransactionState(GlobalTID gtid) {
        this.transactionStates.remove(gtid);
    }

    static {
        CosTransactionStatus = new Status[]{Status.StatusActive, Status.StatusMarkedRollback, Status.StatusPrepared, Status.StatusCommitted, Status.StatusRolledBack, Status.StatusUnknown, Status.StatusNoTransaction, Status.StatusPreparing, Status.StatusCommitting, Status.StatusRollingBack};
        JTAStatus = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        statusMap = new Hashtable();
        int i2 = 0;
        while (i2 < CosTransactionStatus.length) {
            statusMap.put(CosTransactionStatus[i2], new Integer(JTAStatus[i2]));
            ++i2;
        }
    }

    class SynchronizationListener
    implements Synchronization {
        private GlobalTID gtid;
        private TransactionState tranState;

        SynchronizationListener(GlobalTID gtid, TransactionState tranState) {
            this.gtid = gtid;
            this.tranState = tranState;
        }

        public void afterCompletion(int status) {
            this.tranState.cleanupTransactionStateMapping();
        }

        public void beforeCompletion() {
            try {
                this.tranState.beforeCompletion();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
    }
}

