/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import java.util.Vector;

public class Rights
implements Cloneable {
    private boolean[] rights = new boolean[128];

    public Rights() {
    }

    public Rights(Rights rights) {
        System.arraycopy(rights.rights, 0, this.rights, 0, this.rights.length);
    }

    public Rights(String string) {
        int n2 = 0;
        while (n2 < string.length()) {
            this.add(Right.getInstance(string.charAt(n2)));
            ++n2;
        }
    }

    public Rights(Right right) {
        this.rights[right.right] = true;
    }

    public void add(Right right) {
        this.rights[right.right] = true;
    }

    public void add(Rights rights) {
        int n2 = 0;
        while (n2 < rights.rights.length) {
            if (rights.rights[n2]) {
                this.rights[n2] = true;
            }
            ++n2;
        }
    }

    public void remove(Right right) {
        this.rights[right.right] = false;
    }

    public void remove(Rights rights) {
        int n2 = 0;
        while (n2 < rights.rights.length) {
            if (rights.rights[n2]) {
                this.rights[n2] = false;
            }
            ++n2;
        }
    }

    public boolean contains(Right right) {
        return this.rights[right.right];
    }

    public boolean contains(Rights rights) {
        int n2 = 0;
        while (n2 < rights.rights.length) {
            if (rights.rights[n2] && !this.rights[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rights)) {
            return false;
        }
        Rights rights = (Rights)object;
        int n2 = 0;
        while (n2 < rights.rights.length) {
            if (rights.rights[n2] != this.rights[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rights.length) {
            if (this.rights[n3]) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public Right[] getRights() {
        Vector<Right> vector = new Vector<Right>();
        int n2 = 0;
        while (n2 < this.rights.length) {
            if (this.rights[n2]) {
                vector.addElement(Right.getInstance((char)n2));
            }
            ++n2;
        }
        Object[] objectArray = new Right[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object clone() {
        return new Rights(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.rights.length) {
            if (this.rights[n2]) {
                stringBuffer.append((char)n2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final class Right {
        private static Right[] cache = new Right[128];
        public static final Right LOOKUP = Right.getInstance('l');
        public static final Right READ = Right.getInstance('r');
        public static final Right KEEP_SEEN = Right.getInstance('s');
        public static final Right WRITE = Right.getInstance('w');
        public static final Right INSERT = Right.getInstance('i');
        public static final Right POST = Right.getInstance('p');
        public static final Right CREATE = Right.getInstance('c');
        public static final Right DELETE = Right.getInstance('d');
        public static final Right ADMINISTER = Right.getInstance('a');
        char right;

        private Right(char c10) {
            if (c10 >= '\u0080') {
                throw new IllegalArgumentException("Right must be ASCII");
            }
            this.right = c10;
        }

        public static synchronized Right getInstance(char c10) {
            if (c10 >= '\u0080') {
                throw new IllegalArgumentException("Right must be ASCII");
            }
            if (cache[c10] == null) {
                Right.cache[c10] = new Right(c10);
            }
            return cache[c10];
        }

        public String toString() {
            return String.valueOf(this.right);
        }
    }
}

