/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.WebComponentDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.web.security.WebPrincipal;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.catalina.realm.RealmBase;
import sun.security.x509.X500Name;

public class RealmAdapter
extends RealmBase {
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    public static final String CERT = "certificate";
    private static final boolean debug = false;
    private static int MAX_COUNT = 5;
    private static int SLEEP_TIME = 5000;
    private RoleMapper mapper = null;
    private WebBundleDescriptor webDesc = null;
    protected static final String name = "J2EE-RI-RealmAdapter";
    static /* synthetic */ Class class$sun$security$x509$X500Name;

    public RealmAdapter(WebBundleDescriptor descriptor) {
        this.webDesc = descriptor;
        this.mapper = descriptor.getApplication().getRoleMapper();
        LoginConfiguration loginConfiguration = descriptor.getLoginConfiguration();
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webDesc;
    }

    public boolean hasRole(Principal principal, String role) {
        return this.mapper.hasRole(principal, role);
    }

    public void logout() {
        this.setSecurityContext(null);
    }

    public Principal authenticate(String username, byte[] authData) {
        return this.authenticate(username, new String(authData));
    }

    public Principal authenticate(String username, String password) {
        if (this.authenticate(username, password, null)) {
            return new WebPrincipal(username, password);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (this.authenticate(null, null, certs)) {
            return new WebPrincipal(certs);
        }
        return null;
    }

    public boolean authenticate(WebPrincipal prin) {
        if (prin.isUsingCertificate()) {
            return this.authenticate(null, null, prin.getCertificates());
        }
        return this.authenticate(prin.getName(), prin.getPassword(), null);
    }

    protected boolean authenticate(String username, String password, X509Certificate[] certs) {
        SecurityContext.setCurrent(null);
        try {
            if (certs != null) {
                Subject subject = new Subject();
                X509Certificate certificate = certs[0];
                X500Name x500Name = (X500Name)certificate.getSubjectDN();
                subject.getPublicCredentials().add(x500Name);
                LoginContextDriver.login(subject, class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = RealmAdapter.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name);
            } else {
                LoginContextDriver.login(username, password);
            }
        }
        catch (Exception le) {
            Log.err.println(le);
            return false;
        }
        return true;
    }

    public void preSetRunAsIdentity(ComponentInvocation inv) {
        SecurityContext old = null;
        String runAs = this.getRunAsPrincipal(this.webDesc);
        if (runAs != null) {
            old = this.getSecurityContext();
            inv.setOldSecurityContext(old);
            this.loginForRunAs(runAs);
        }
    }

    public void postSetRunAsIdentity(ComponentInvocation inv) {
        String runAs = this.getRunAsPrincipal(this.webDesc);
        if (runAs != null) {
            this.setSecurityContext(inv.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String principal) {
        LoginContextDriver.loginPrincipal(principal);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    protected String getPassword(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    public String getRunAsPrincipal(WebBundleDescriptor wbd) {
        String prin = null;
        Set s2 = wbd.getWebComponentDescriptorsSet();
        Iterator itr = s2.iterator();
        while (itr.hasNext()) {
            WebComponentDescriptor wcd = (WebComponentDescriptor)itr.next();
            RunAsIdentityDescriptor raid = wcd.getRunAsIdentity();
            if (raid == null) continue;
            prin = raid.getPrincipal();
            return prin;
        }
        return prin;
    }

    protected String getName() {
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

