/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.log.Log;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.WebPrincipal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;

public final class J2EEInstanceListener
implements InstanceListener {
    private InvocationManager im = Switch.getSwitch().getInvocationManager();
    private J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
    private static boolean debug = false;

    public void instanceEvent(InstanceEvent event) {
        String eventType = event.getType();
        if (debug) {
            System.err.println("*** InstanceEvent: " + eventType);
        }
        if (eventType.equals("beforeService") || eventType.equals("beforeFilter") || eventType.equals("beforeInit") || eventType.equals("beforeDestroy") || eventType.equals("beforeDispatch")) {
            this.handleBeforeEvent(event, eventType);
        } else if (eventType.equals("afterService") || eventType.equals("afterFilter") || eventType.equals("afterInit") || eventType.equals("afterDestroy") || eventType.equals("afterDispatch")) {
            this.handleAfterEvent(event, eventType);
        }
    }

    private void handleBeforeEvent(InstanceEvent event, String eventType) {
        Object instance = null;
        instance = eventType.equals("beforeFilter") ? event.getFilter() : event.getServlet();
        Context context = (Context)event.getWrapper().getParent();
        final ClassLoader cl2 = context.getLoader().getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl2);
                return null;
            }
        });
        try {
            HttpServletRequest request;
            RealmAdapter ra = (RealmAdapter)context.getRealm();
            if (ra != null && (request = (HttpServletRequest)event.getRequest()) != null && request.getUserPrincipal() != null) {
                WebPrincipal prin = (WebPrincipal)request.getUserPrincipal();
                ra.authenticate(prin);
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        ComponentInvocation inv = new ComponentInvocation(instance, context);
        try {
            this.im.preInvoke(inv);
            if (eventType.equals("beforeService")) {
                this.tm.enlistComponentResources();
            }
        }
        catch (Exception ex3) {
            Log.err.println(ex3);
            ex3.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    private void handleAfterEvent(InstanceEvent event, String eventType) {
        block27: {
            if (AppVerification.doInstrument() && (eventType.equals("afterService") || eventType.equals("afterDispatch"))) {
                AppVerification.getInstrumentLogger().doInstrumentForWeb(event);
            }
            Object instance = null;
            instance = eventType.equals("afterFilter") ? event.getFilter() : event.getServlet();
            Context context = (Context)event.getWrapper().getParent();
            ComponentInvocation inv = new ComponentInvocation(instance, context);
            this.im.postInvoke(inv);
            Object var8_6 = null;
            if (eventType.equals("afterDestroy")) {
                this.tm.componentDestroyed(instance);
            }
            if (!eventType.equals("afterFilter") && !eventType.equals("afterService")) break block27;
            try {
                this.im.getCurrentInvocation();
            }
            catch (InvocationException iex) {
                try {
                    RealmAdapter ra = (RealmAdapter)context.getRealm();
                    if (ra != null) {
                        ra.logout();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                try {
                    if (this.tm.getTransaction() != null) {
                        this.tm.rollback();
                    }
                    break block27;
                }
                catch (Exception ex2) {}
            }
            break block27;
            {
                catch (Exception ex3) {
                    Log.err.println(ex3);
                    ex3.printStackTrace();
                    Object var8_7 = null;
                    if (eventType.equals("afterDestroy")) {
                        this.tm.componentDestroyed(instance);
                    }
                    if (!eventType.equals("afterFilter") && !eventType.equals("afterService")) break block27;
                    try {
                        this.im.getCurrentInvocation();
                    }
                    catch (InvocationException iex) {
                        try {
                            RealmAdapter ra = (RealmAdapter)context.getRealm();
                            if (ra != null) {
                                ra.logout();
                            }
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                        try {
                            if (this.tm.getTransaction() != null) {
                                this.tm.rollback();
                            }
                            break block27;
                        }
                        catch (Exception ex2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (eventType.equals("afterDestroy")) {
                    this.tm.componentDestroyed(instance);
                }
                if (eventType.equals("afterFilter") || eventType.equals("afterService")) {
                    try {
                        this.im.getCurrentInvocation();
                    }
                    catch (InvocationException iex) {
                        try {
                            RealmAdapter ra = (RealmAdapter)context.getRealm();
                            if (ra != null) {
                                ra.logout();
                            }
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                        try {
                            if (this.tm.getTransaction() != null) {
                                this.tm.rollback();
                            }
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                }
                throw throwable;
            }
        }
    }
}

