/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private Vector transportListeners = null;

    public Transport(Session session, URLName uRLName) {
        super(session, uRLName);
    }

    public static void send(Message message) throws MessagingException {
        message.saveChanges();
        Transport.send0(message, message.getAllRecipients());
    }

    public static void send(Message message, Address[] addressArray) throws MessagingException {
        message.saveChanges();
        Transport.send0(message, addressArray);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void send0(Message message, Address[] addressArray) throws MessagingException {
        if (addressArray == null || addressArray.length == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        Vector<Object> vector = new Vector<Object>();
        Vector<Address> vector2 = new Vector<Address>();
        Vector<Address> vector3 = new Vector<Address>();
        int n2 = 0;
        while (true) {
            Vector vector4;
            if (n2 >= addressArray.length) {
                int n3 = hashtable.size();
                if (n3 != 0) break;
                throw new SendFailedException("No recipient addresses");
            }
            if (hashtable.containsKey(addressArray[n2].getType())) {
                vector4 = (Vector)hashtable.get(addressArray[n2].getType());
                vector4.addElement(addressArray[n2]);
            } else {
                vector4 = new Vector();
                vector4.addElement(addressArray[n2]);
                hashtable.put(addressArray[n2].getType(), vector4);
            }
            ++n2;
        }
        Session session = message.session != null ? message.session : Session.getDefaultInstance(System.getProperties(), null);
        Object var10_10 = null;
        boolean bl2 = false;
        Enumeration enumeration = hashtable.elements();
        block6: while (true) {
            Object var22_28;
            void var10_11;
            Object[] objectArray;
            Object[] objectArray2;
            if (!enumeration.hasMoreElements()) {
                if (!bl2 && vector.size() == 0 && vector3.size() == 0) {
                    return;
                }
                objectArray2 = null;
                objectArray = null;
                Object[] objectArray3 = null;
                if (vector2.size() > 0) {
                    objectArray2 = new Address[vector2.size()];
                    vector2.copyInto(objectArray2);
                }
                if (vector3.size() > 0) {
                    objectArray = new Address[vector3.size()];
                    vector3.copyInto(objectArray);
                }
                if (vector.size() > 0) {
                    objectArray3 = new Address[vector.size()];
                    vector.copyInto(objectArray3);
                }
                throw new SendFailedException("Sending failed", (Exception)var10_11, (Address[])objectArray2, (Address[])objectArray, (Address[])objectArray3);
            }
            objectArray2 = (Object[])enumeration.nextElement();
            objectArray = new Address[objectArray2.size()];
            objectArray2.copyInto(objectArray);
            Transport transport = session.getTransport((Address)objectArray[0]);
            if (transport == null) {
                int n4 = 0;
                while (true) {
                    if (n4 >= objectArray.length) continue block6;
                    vector.addElement(objectArray[n4]);
                    ++n4;
                }
            }
            try {
                Address[] addressArray2;
                Address[] addressArray3;
                SendFailedException sendFailedException2;
                block28: {
                    int n5;
                    try {
                        transport.connect();
                        transport.sendMessage(message, (Address[])objectArray);
                    }
                    catch (SendFailedException sendFailedException2) {
                        bl2 = true;
                        if (var10_11 == null) {
                            SendFailedException sendFailedException3 = sendFailedException2;
                        } else {
                            var10_11.setNextException(sendFailedException2);
                        }
                        addressArray3 = sendFailedException2.getInvalidAddresses();
                        if (addressArray3 == null) break block28;
                        n5 = 0;
                    }
                    while (n5 < addressArray3.length) {
                        vector.addElement(addressArray3[n5]);
                        ++n5;
                    }
                }
                if ((addressArray3 = sendFailedException2.getValidSentAddresses()) != null) {
                    int n6 = 0;
                    while (n6 < addressArray3.length) {
                        vector2.addElement(addressArray3[n6]);
                        ++n6;
                    }
                }
                if ((addressArray2 = sendFailedException2.getValidUnsentAddresses()) != null) {
                    int n7 = 0;
                    while (true) {
                        if (n7 >= addressArray2.length) {
                            break;
                        }
                        vector3.addElement(addressArray2[n7]);
                        ++n7;
                    }
                }
                var22_28 = null;
                transport.close();
                continue;
                catch (MessagingException messagingException) {
                    bl2 = true;
                    if (var10_11 == null) {
                        MessagingException messagingException2 = messagingException;
                    } else {
                        var10_11.setNextException(messagingException);
                    }
                    var22_28 = null;
                    transport.close();
                    continue;
                }
                var22_28 = null;
            }
            catch (Throwable throwable) {
                var22_28 = null;
                transport.close();
                throw throwable;
            }
            transport.close();
        }
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;

    public synchronized void addTransportListener(TransportListener transportListener) {
        if (this.transportListeners == null) {
            this.transportListeners = new Vector();
        }
        this.transportListeners.addElement(transportListener);
    }

    public synchronized void removeTransportListener(TransportListener transportListener) {
        if (this.transportListeners != null) {
            this.transportListeners.removeElement(transportListener);
        }
    }

    protected void notifyTransportListeners(int n2, Address[] addressArray, Address[] addressArray2, Address[] addressArray3, Message message) {
        if (this.transportListeners == null) {
            return;
        }
        TransportEvent transportEvent = new TransportEvent(this, n2, addressArray, addressArray2, addressArray3, message);
        this.queueEvent(transportEvent, this.transportListeners);
    }
}

